/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.data;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.data.IChunkMetaDataHandler;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.event.world.ChunkEvent;

public class ChunkDataMessage
implements IMessage {
    int worldId;
    ChunkCoordIntPair chunk;
    NBTTagCompound data;
    IChunkMetaDataHandler handler;

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.worldId = tag.func_74762_e("wId");
        this.chunk = new ChunkCoordIntPair(tag.func_74762_e("posx"), tag.func_74762_e("posz"));
        this.handler = TecTech.chunkDataHandler.getChunkMetaDataHandler(tag.func_74779_i("handle"));
        if (tag.func_74764_b("data")) {
            this.data = tag.func_74775_l("data");
        }
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("wId", this.worldId);
        tag.func_74768_a("posx", this.chunk.field_77276_a);
        tag.func_74768_a("posz", this.chunk.field_77275_b);
        tag.func_74778_a("handle", this.handler.getTagName());
        if (this.data != null) {
            tag.func_74782_a("data", (NBTBase)this.data);
        }
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tag);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<ChunkDataQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, ChunkDataQuery pMessage, MessageContext pCtx) {
            return new ChunkDataData(pMessage);
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<ChunkDataData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, ChunkDataData pMessage, MessageContext pCtx) {
            if (Util.checkChunkExist(pPlayer.field_70170_p, pMessage.chunk)) {
                TecTech.chunkDataHandler.putChunkData(pMessage.handler, pMessage.worldId, pMessage.chunk, pMessage.data);
            }
            return null;
        }
    }

    public static class ChunkDataData
    extends ChunkDataMessage {
        public ChunkDataData() {
        }

        public ChunkDataData(int worldId, ChunkCoordIntPair chunk, IChunkMetaDataHandler handler) {
            this.worldId = worldId;
            this.chunk = chunk;
            this.handler = handler;
            this.data = TecTech.chunkDataHandler.getChunkData(handler, worldId, chunk);
        }

        public ChunkDataData(ChunkDataQuery query) {
            this.worldId = query.worldId;
            this.chunk = query.chunk;
            this.handler = query.handler;
            this.data = TecTech.chunkDataHandler.getChunkData(this.handler, this.worldId, this.chunk);
        }
    }

    public static class ChunkDataQuery
    extends ChunkDataMessage {
        public ChunkDataQuery() {
        }

        public ChunkDataQuery(ChunkEvent.Load aEvent, IChunkMetaDataHandler handler) {
            this.worldId = aEvent.world.field_73011_w.field_76574_g;
            this.chunk = aEvent.getChunk().func_76632_l();
            this.handler = handler;
        }
    }
}

