/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.openmodularturrets.entity.projectiles;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eQuarkDefinition;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import openmodularturrets.entity.projectiles.LaserProjectile;
import openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.util.PlayerUtil;
import openmodularturrets.util.TurretHeadUtil;

public class projectileEM
extends LaserProjectile {
    public float gravity = 0.0f;
    private TurretBase turretBase;
    private boolean exotic;
    private boolean antiMatter;
    private boolean isAmped;
    private int ampLevel;
    private float massFactor;

    public projectileEM(World par1World) {
        super(par1World);
    }

    public projectileEM(World par1World, TurretBase turretBase) {
        super(par1World, turretBase);
        int amp = TurretHeadUtil.getAmpLevel((TurretBase)turretBase);
        if (amp > 0) {
            this.isAmped = true;
            this.ampLevel = amp;
        }
    }

    public projectileEM(World par1World, TurretBase turretBase, cElementalInstanceStackMap avalableEM) {
        super(par1World, turretBase);
        this.turretBase = turretBase;
        boolean onlyQuarks = true;
        if (avalableEM != null && avalableEM.hasStacks()) {
            for (cElementalInstanceStack stack : avalableEM.values()) {
                if (stack.definition instanceof eQuarkDefinition) continue;
                onlyQuarks = false;
            }
            if (onlyQuarks) {
                avalableEM.clear();
            } else {
                cElementalInstanceStack consumeFromThis = avalableEM.get(TecTech.RANDOM.nextInt(avalableEM.size()));
                this.massFactor = consumeFromThis.definition.getMass() / dHadronDefinition.hadron_n_.getMass();
                if (consumeFromThis.definition.getType() > 1 || consumeFromThis.definition.getType() < -1) {
                    this.exotic = true;
                }
                if (consumeFromThis.definition.getType() < 0) {
                    this.antiMatter = true;
                }
                this.gravity = consumeFromThis.definition.getCharge() == 0 ? this.massFactor / 100.0f : Math.min(0.0025f / (float)Math.abs(consumeFromThis.definition.getCharge()), this.massFactor / 100.0f);
                avalableEM.removeAmount(false, consumeFromThis.definition.getStackForm(1L));
            }
        }
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        if (this.field_70173_aa > 1) {
            Block hitBlock;
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (hitBlock = this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d)) != null) {
                if (hitBlock.func_149688_o().func_76220_a() && TecTech.configTecTech.ENABLE_TURRET_EXPLOSIONS && this.antiMatter) {
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "openmodularturrets:laserHit", ConfigHandler.getTurretSoundVolume(), TecTech.RANDOM.nextFloat() + 0.5f);
                    GT_Utility.sendSoundToPlayers((World)this.field_70170_p, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)movingobjectposition.field_72311_b, (int)movingobjectposition.field_72312_c, (int)movingobjectposition.field_72309_d);
                    this.field_70170_p.func_72876_a(null, (double)movingobjectposition.field_72311_b + 0.5, (double)movingobjectposition.field_72312_c + 0.5, (double)movingobjectposition.field_72309_d + 0.5, (float)(this.exotic ? 10 : 1) * TecTech.configTecTech.TURRET_EXPLOSION_FACTOR * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f) * ((float)this.field_70173_aa / 250.0f), true);
                } else {
                    return;
                }
            }
            if (movingobjectposition.field_72308_g != null && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "openmodularturrets:laserHit", ConfigHandler.getTurretSoundVolume(), TecTech.RANDOM.nextFloat() + 0.5f);
                if (movingobjectposition.field_72308_g != null && !this.field_70170_p.field_72995_K) {
                    float damage = (float)(this.exotic ? 10 : 1) * TecTech.configTecTech.TURRET_DAMAGE_FACTOR * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f);
                    if (movingobjectposition.field_72308_g instanceof EntityPlayer) {
                        if (this.canDamagePlayer((EntityPlayer)movingobjectposition.field_72308_g)) {
                            movingobjectposition.field_72308_g.func_70015_d((this.exotic ? 10 : 1) * 2);
                            movingobjectposition.field_72308_g.func_70097_a((DamageSource)new NormalDamageSource("laser"), damage);
                            if (this.antiMatter) {
                                movingobjectposition.field_72308_g.field_70172_ad = 0;
                            }
                        }
                    } else {
                        movingobjectposition.field_72308_g.func_70015_d((this.exotic ? 10 : 1) * 2);
                        movingobjectposition.field_72308_g.func_70097_a((DamageSource)new NormalDamageSource("laser"), damage);
                        if (this.antiMatter) {
                            movingobjectposition.field_72308_g.field_70172_ad = 0;
                        }
                    }
                    if (TecTech.configTecTech.ENABLE_TURRET_EXPLOSIONS && this.antiMatter) {
                        GT_Utility.sendSoundToPlayers((World)this.field_70170_p, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((int)movingobjectposition.field_72308_g.field_70165_t), (int)((int)movingobjectposition.field_72308_g.field_70163_u), (int)((int)movingobjectposition.field_72308_g.field_70161_v));
                        this.field_70170_p.func_72876_a(null, movingobjectposition.field_72308_g.field_70165_t, movingobjectposition.field_72308_g.field_70163_u, movingobjectposition.field_72308_g.field_70161_v, (float)(this.exotic ? 10 : 1) * TecTech.configTecTech.TURRET_EXPLOSION_FACTOR * this.massFactor * (this.isAmped ? (float)this.ampLevel * 0.1f + 1.0f : 1.0f) * ((float)this.field_70173_aa / 250.0f), true);
                    }
                }
            }
            this.func_70106_y();
        }
    }

    public boolean canDamagePlayer(EntityPlayer entityPlayer) {
        return ConfigHandler.turretDamageTrustedPlayers || this.turretBase.getTrustedPlayer(entityPlayer.func_110124_au()) == null && !PlayerUtil.getPlayerUIDUnstable((String)this.turretBase.getOwner()).equals(entityPlayer.func_110124_au());
    }

    public void func_70030_z() {
        if (this.field_70173_aa >= 75) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return this.gravity;
    }
}

