/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.data.RendererMessage;
import com.github.technus.tectech.mechanics.data.ThaumSpark;
import com.github.technus.tectech.thing.cover.GT_Cover_TM_TeslaCoil;
import com.github.technus.tectech.thing.cover.GT_Cover_TM_TeslaCoil_Ultimate;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_TM_teslaCoil;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_MetaTileEntity_TeslaCoil
extends GT_MetaTileEntity_BasicBatteryBuffer {
    private static final HashSet<ThaumSpark> sparkList = new HashSet();
    private byte sparkCount = 0;
    private int maxTier = 4;
    private int minTier = 0;
    public Map<IGregTechTileEntity, Integer> eTeslaMap = new HashMap<IGregTechTileEntity, Integer>();
    private int transferRadiusMax = 20;
    private int transferRadiusMin = 4;
    private int transferRadiusLimitTop = (int)Util.map(this.mTier + 1, this.minTier + 1, this.maxTier + 1, this.transferRadiusMin, this.transferRadiusMax);
    private int transferRadiusLimitBottom = 1;
    private int transferRadius = this.transferRadiusLimitTop;
    private int transferRadiusTower = 0;
    private int transferRadiusCover = 0;
    public boolean powerPassToggle = false;
    private int histSteps = 20;
    private int histSettingLow = 3;
    private int histSettingHigh = 15;
    private int histLowLimit = 1;
    private int histHighLimit = 19;
    private float histLow = (float)this.histSettingLow / (float)this.histSteps;
    private float histHigh = (float)this.histSettingHigh / (float)this.histSteps;
    private long outputVoltage = CommonValues.V[this.mTier];
    private float minEfficiency;
    private float maxEfficiency;
    private float overdriveEfficiencyExtra;
    private float energyEfficiency;
    private float overdriveEfficiency;
    private boolean overdriveToggle;
    private String clientLocale;

    public GT_MetaTileEntity_TeslaCoil(int aID, String aName, String aNameRegional, int aTier, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, "", aSlotCount);
        this.minEfficiency = TecTech.configTecTech.TESLA_SINGLE_MIN_EFFICIENCY;
        this.maxEfficiency = TecTech.configTecTech.TESLA_SINGLE_MAX_EFFICIENCY;
        this.overdriveEfficiencyExtra = TecTech.configTecTech.TESLA_SINGLE_OVERDRIVE_LOSS;
        this.energyEfficiency = Util.map(this.mTier + 1, this.minTier + 1, this.maxTier + 1, this.minEfficiency, this.maxEfficiency);
        this.overdriveEfficiency = this.energyEfficiency - this.overdriveEfficiencyExtra;
        this.overdriveToggle = false;
        this.clientLocale = "en_US";
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_TeslaCoil(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
        this.minEfficiency = TecTech.configTecTech.TESLA_SINGLE_MIN_EFFICIENCY;
        this.maxEfficiency = TecTech.configTecTech.TESLA_SINGLE_MAX_EFFICIENCY;
        this.overdriveEfficiencyExtra = TecTech.configTecTech.TESLA_SINGLE_OVERDRIVE_LOSS;
        this.energyEfficiency = Util.map(this.mTier + 1, this.minTier + 1, this.maxTier + 1, this.minEfficiency, this.maxEfficiency);
        this.overdriveEfficiency = this.energyEfficiency - this.overdriveEfficiencyExtra;
        this.overdriveToggle = false;
        this.clientLocale = "en_US";
    }

    public String[] getDescription() {
        Object[] jargon = new String[]{CommonValues.BASS_MARK, StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.tesla.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.tesla.desc.1")};
        Object[] sDesc = super.getDescription();
        sDesc = Arrays.copyOfRange(sDesc, 1, sDesc.length);
        return (String[])ArrayUtils.addAll((Object[])jargon, (Object[])sDesc);
    }

    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.overdriveToggle) {
            this.overdriveToggle = false;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)StatCollector.func_74837_a((String)"tt.keyphrase.Overdrive_disengaged", (Object[])new Object[]{this.clientLocale}));
        } else {
            this.overdriveToggle = true;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)StatCollector.func_74837_a((String)"tt.keyphrase.Overdrive_engaged", (Object[])new Object[]{this.clientLocale}));
        }
        return true;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.histSettingHigh = this.histSettingHigh < this.histHighLimit ? ++this.histSettingHigh : this.histSettingLow + 1;
            this.histHigh = (float)this.histSettingHigh / (float)this.histSteps;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Hysteresis_high_set_to", (Object[])new Object[]{this.clientLocale}) + " " + Math.round(this.histHigh * 100.0f) + "%"));
        } else {
            this.histSettingLow = this.histSettingLow > this.histLowLimit ? --this.histSettingLow : this.histSettingHigh - 1;
            this.histLow = (float)this.histSettingLow / (float)this.histSteps;
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Hysteresis_low_set_to", (Object[])new Object[]{this.clientLocale}) + " " + Math.round(this.histLow * 100.0f) + "%"));
        }
    }

    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if (this.transferRadius > this.transferRadiusLimitBottom) {
                --this.transferRadius;
            }
        } else if (this.transferRadius < 0) {
            ++this.transferRadius;
        }
        PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)(StatCollector.func_74837_a((String)"tt.keyphrase.Tesla_radius_set_to", (Object[])new Object[]{this.clientLocale}) + " " + this.transferRadius + "m"));
        return false;
    }

    public boolean hasAlternativeModeText() {
        return true;
    }

    public String getAlternativeModeText() {
        long energyMax = this.getStoredEnergy()[1];
        long energyStored = this.getStoredEnergy()[0];
        float energyFrac = (float)energyStored / (float)energyMax;
        this.powerPassToggle = energyFrac > this.histHigh ? true : (energyFrac < this.histLow ? false : !this.powerPassToggle);
        return this.powerPassToggle ? StatCollector.func_74837_a((String)"tt.keyphrase.Sending_power", (Object[])new Object[]{this.clientLocale}) + "!" : StatCollector.func_74837_a((String)"tt.keyphrase.Receiving_power", (Object[])new Object[]{this.clientLocale}) + "!";
    }

    public boolean isFacingValid(byte aSide) {
        return aSide != 1;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[3][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.TESLA_TRANSCEIVER_TOP_BA};
            rTextures[2][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], this.mInventory.length == 16 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier] : (this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier] : Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier])};
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide == aFacing ? 2 : (aSide == 1 ? 1 : 0)][aColorIndex + 1];
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TeslaCoil(this.mName, this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    private void thaumLightning(IGregTechTileEntity mte, IGregTechTileEntity node) {
        byte zR;
        byte yR;
        byte xR;
        int x = mte.getXCoord();
        short y = mte.getYCoord();
        int z = mte.getZCoord();
        IMetaTileEntity nodeInside = node.getMetaTileEntity();
        if (nodeInside instanceof GT_MetaTileEntity_TM_teslaCoil) {
            GT_MetaTileEntity_TM_teslaCoil nodeTesla = (GT_MetaTileEntity_TM_teslaCoil)nodeInside;
            xR = (byte)(nodeTesla.posTop[0] - x);
            yR = (byte)(nodeTesla.posTop[1] - y);
            zR = (byte)(nodeTesla.posTop[2] - z);
        } else {
            xR = (byte)(node.getXCoord() - x);
            yR = (byte)(node.getYCoord() - y);
            zR = (byte)(node.getZCoord() - z);
        }
        int wID = mte.getWorld().field_73011_w.field_76574_g;
        sparkList.add(new ThaumSpark(x, y, z, xR, yR, zR, wID));
    }

    private long getEnergyEfficiency(long voltage, int distance, boolean overDriveToggle) {
        if (overDriveToggle) {
            return (long)((double)(voltage * 2L) - (double)voltage * Math.pow(this.overdriveEfficiency, distance));
        }
        return (long)((double)voltage * Math.pow(this.energyEfficiency, distance));
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide()) {
            return;
        }
        long energyMax = this.getStoredEnergy()[1];
        long energyStored = this.getStoredEnergy()[0];
        float energyFrac = (float)energyStored / (float)energyMax;
        if (!this.powerPassToggle && energyFrac > this.histHigh) {
            this.powerPassToggle = true;
        } else if (this.powerPassToggle && energyFrac < this.histLow) {
            this.powerPassToggle = false;
        }
        if (this.powerPassToggle) {
            float rangeFrac = (float)(-0.5 * Math.pow(energyFrac, 2.0) + 1.5 * (double)energyFrac);
            long outputCurrent = this.mBatteryCount;
            this.transferRadiusTower = (int)((float)this.transferRadius * rangeFrac);
            this.transferRadiusCover = (int)((double)this.transferRadiusTower / 1.25);
            for (Map.Entry<IGregTechTileEntity, Integer> Rx : this.eTeslaMap.entrySet()) {
                IGregTechTileEntity iGregTechTileEntity = Rx.getKey();
                if (iGregTechTileEntity != null) {
                    IMetaTileEntity nodeInside = iGregTechTileEntity.getMetaTileEntity();
                    try {
                        GT_MetaTileEntity_TM_teslaCoil teslaTower;
                        if (nodeInside instanceof GT_MetaTileEntity_TM_teslaCoil && iGregTechTileEntity.isActive() ? (teslaTower = (GT_MetaTileEntity_TM_teslaCoil)nodeInside).maxEUStore() > 0L : iGregTechTileEntity.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil && iGregTechTileEntity.getEUCapacity() > 0L) {
                            continue;
                        }
                    }
                    catch (Exception teslaTower) {
                        // empty catch block
                    }
                }
                this.eTeslaMap.remove(Rx.getKey());
            }
            while (outputCurrent > 0L) {
                boolean idle = true;
                for (Map.Entry entry : Util.entriesSortedByValues(this.eTeslaMap)) {
                    if (this.getEUVar() >= (this.overdriveToggle ? this.outputVoltage * 2L : this.outputVoltage)) {
                        Object nodeTesla;
                        long outputVoltageConsumption;
                        long outputVoltageInjectable;
                        IGregTechTileEntity node = (IGregTechTileEntity)entry.getKey();
                        IMetaTileEntity nodeInside = node.getMetaTileEntity();
                        if (this.overdriveToggle) {
                            outputVoltageInjectable = this.outputVoltage;
                            outputVoltageConsumption = this.getEnergyEfficiency(this.outputVoltage, (Integer)entry.getValue(), true);
                        } else {
                            outputVoltageInjectable = this.getEnergyEfficiency(this.outputVoltage, (Integer)entry.getValue(), false);
                            outputVoltageConsumption = this.outputVoltage;
                        }
                        if (nodeInside instanceof GT_MetaTileEntity_TM_teslaCoil && (Integer)entry.getValue() <= this.transferRadiusTower) {
                            nodeTesla = (GT_MetaTileEntity_TM_teslaCoil)nodeInside;
                            if (!nodeTesla.ePowerPass && nodeTesla.getEUVar() + outputVoltageInjectable <= nodeTesla.maxEUStore() / 2L) {
                                this.setEUVar(this.getEUVar() - outputVoltageConsumption);
                                node.increaseStoredEnergyUnits(outputVoltageInjectable, true);
                                this.thaumLightning(aBaseMetaTileEntity, node);
                                --outputCurrent;
                                idle = false;
                            }
                        } else if (node.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil && !(node.getCoverBehaviorAtSide((byte)1) instanceof GT_Cover_TM_TeslaCoil_Ultimate) && (Integer)entry.getValue() <= this.transferRadiusCover) {
                            if (nodeInside instanceof GT_MetaTileEntity_TeslaCoil) {
                                nodeTesla = (GT_MetaTileEntity_TeslaCoil)nodeInside;
                                if (((GT_MetaTileEntity_TeslaCoil)((Object)nodeTesla)).powerPassToggle) continue;
                            }
                            if (node.injectEnergyUnits((byte)1, outputVoltageInjectable, 1L) > 0L) {
                                this.setEUVar(this.getEUVar() - outputVoltageConsumption);
                                this.thaumLightning(aBaseMetaTileEntity, node);
                                --outputCurrent;
                                idle = false;
                            }
                        }
                        if (outputCurrent != 0L) continue;
                        break;
                    }
                    idle = true;
                    break;
                }
                if (!idle) continue;
                break;
            }
        }
        this.sparkCount = (byte)(this.sparkCount + 1);
        if (this.sparkCount == 60 && !sparkList.isEmpty()) {
            this.sparkCount = 0;
            NetworkDispatcher.INSTANCE.sendToAllAround(new RendererMessage.RendererData(sparkList), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
        }
        sparkList.clear();
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            this.clientLocale = "en_US";
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }
}

