/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OverflowElemental;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_Container_DebugPollutor;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_GUIContainer_DebugPollutor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.common.GT_Pollution;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_DebugPollutor
extends GT_MetaTileEntity_TieredMachineBlock {
    private static GT_RenderedTexture POLLUTOR;
    public int pollution = 0;
    public float anomaly = 0.0f;

    public GT_MetaTileEntity_DebugPollutor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_DebugPollutor(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        Util.setTier(aTier, (Object)this);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DebugPollutor(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        POLLUTOR = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/POLLUTOR"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
        iTextureArray[1] = aSide != aFacing ? (aActive ? new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_OverflowElemental.MufflerEM) : new GT_RenderedTexture((IIconContainer)GT_MetaTileEntity_Hatch_OverflowElemental.MufflerEMidle)) : POLLUTOR;
        return iTextureArray;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_DebugPollutor(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_DebugPollutor(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("ePollution", this.pollution);
        aNBT.func_74776_a("eAnomaly", this.anomaly);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.pollution = aNBT.func_74762_e("ePollution");
        this.anomaly = aNBT.func_74760_g("eAnomaly");
        this.getBaseMetaTileEntity().setActive(this.anomaly > 0.0f || this.pollution > 0);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(this.anomaly > 0.0f || this.pollution > 0);
            if (this.anomaly > 0.0f) {
                TecTech.anomalyHandler.addAnomaly(aBaseMetaTileEntity, this.anomaly);
            }
            if (this.pollution > 0) {
                GT_Pollution.addPollution((IGregTechTileEntity)aBaseMetaTileEntity, (int)this.pollution);
            }
        } else if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                if (i == aBaseMetaTileEntity.getFrontFacing()) continue;
                TecTech.proxy.em_particle(aBaseMetaTileEntity, i);
                TecTech.proxy.pollutor_particle(aBaseMetaTileEntity, i);
            }
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.1")};
    }

    public boolean isElectric() {
        return false;
    }
}

