/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.Vec3pos;
import com.github.technus.tectech.mechanics.dataTransport.QuantumDataPacket;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputData;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IHatchAdder;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_EM_switch
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static final String[][] shape = new String[][]{{"   ", " . ", "   "}, {"   ", " 0 ", "   "}, {"   ", "   ", "   "}};
    private static final Block[] blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT};
    private static final byte[] blockMeta = new byte[]{3};
    private final IHatchAdder[] addingMethods = new IHatchAdder[]{this::addClassicToMachineList};
    private static final short[] casingTextures = new short[]{1025};
    private static final Block[] blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT};
    private static final byte[] blockMetaFallback = new byte[]{1};
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", "1 - Classic/Data Hatches or Computer casing"};
    private static final INameFunction<GT_MetaTileEntity_EM_switch> ROUTE_NAME = (base, p) -> (p.parameterId() == 0 ? StatCollector.func_74838_a((String)"tt.keyword.Destination") + " " : StatCollector.func_74838_a((String)"tt.keyword.Weight") + " ") + p.hatchId();
    private static final IStatusFunction<GT_MetaTileEntity_EM_switch> WEI_STATUS = (base, p) -> {
        double v = p.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if (v < 0.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (v == 0.0) {
            return LedStatus.STATUS_LOW;
        }
        if (Double.isInfinite(v)) {
            return LedStatus.STATUS_HIGH;
        }
        return LedStatus.STATUS_OK;
    };
    private static final IStatusFunction<GT_MetaTileEntity_EM_switch> DST_STATUS = (base, p) -> {
        if (base.weight[p.hatchId()].getStatus((boolean)false).isOk) {
            double v = p.get();
            if (Double.isNaN(v)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((v = (double)((int)v)) <= 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (v >= (double)base.eOutputHatches.size()) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        }
        return LedStatus.STATUS_NEUTRAL;
    };
    protected Parameters.Group.ParameterIn[] dst;
    protected Parameters.Group.ParameterIn[] weight;
    public static final ResourceLocation activitySound = new ResourceLocation("tectech:fx_hi_freq");

    public GT_MetaTileEntity_EM_switch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_switch(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_switch(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM(shape, blockType, blockMeta, this.addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 1, 0);
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        int thingsActive = 0;
        for (GT_MetaTileEntity_Hatch_InputData di : this.eInputData) {
            if (di.q == null) continue;
            thingsActive = (short)(thingsActive + 1);
        }
        if (thingsActive > 0) {
            thingsActive = (short)(thingsActive + this.eOutputData.size());
            this.mEUt = -((int)CommonValues.V[7]);
            this.eAmpereFlow = 1 + (thingsActive >> 2);
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            return true;
        }
        return false;
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            double weight;
            double total = 0.0;
            for (int i = 0; i < 10; ++i) {
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(this.dst[i].get() >= 0.0)) continue;
                total += weight;
            }
            Vec3pos pos = new Vec3pos(this.getBaseMetaTileEntity());
            QuantumDataPacket pack = new QuantumDataPacket(0L).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (GT_MetaTileEntity_Hatch_InputData hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            long remaining = (Long)pack.getContent();
            for (int i = 0; i < 10; ++i) {
                int outIndex;
                double dest = this.dst[i].get();
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(dest >= 0.0) || (outIndex = (int)dest - 1) < 0 || outIndex >= this.eOutputData.size()) continue;
                GT_MetaTileEntity_Hatch_OutputData out = (GT_MetaTileEntity_Hatch_OutputData)this.eOutputData.get(outIndex);
                if (Double.isInfinite(total)) {
                    if (!Double.isInfinite(weight)) continue;
                    out.q = new QuantumDataPacket(remaining).unifyTraceWith(pack);
                    break;
                }
                long part = (long)Math.floor((double)((Long)pack.getContent()).longValue() * weight / total);
                if (part <= 0L) continue;
                if ((remaining -= part) > 0L) {
                    out.q = new QuantumDataPacket(part).unifyTraceWith(pack);
                    continue;
                }
                if (part + remaining <= 0L) break;
                out.q = new QuantumDataPacket(part + remaining).unifyTraceWith(pack);
                break;
            }
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.1")};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1], new TT_RenderedTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return activitySound;
    }

    @Override
    protected void parametersInstantiation_EM() {
        this.dst = new Parameters.Group.ParameterIn[10];
        this.weight = new Parameters.Group.ParameterIn[10];
        for (int i = 0; i < 10; ++i) {
            Parameters.Group hatch = this.parametrization.getGroup(i);
            this.dst[i] = hatch.makeInParameter(0, i, ROUTE_NAME, DST_STATUS);
            this.weight[i] = hatch.makeInParameter(1, 0.0, ROUTE_NAME, WEI_STATUS);
        }
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        Util.StructureBuilderExtreme(shape, blockType, blockMeta, 1, 1, 0, this.getBaseMetaTileEntity(), this, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }
}

