/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import com.github.technus.tectech.thing.metaTileEntity.pipe.GT_MetaTileEntity_Pipe_Energy;
import com.github.technus.tectech.thing.metaTileEntity.pipe.IConnectsToEnergyTunnel;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_Hatch_DynamoTunnel
extends GT_MetaTileEntity_Hatch_DynamoMulti
implements IConnectsToEnergyTunnel {
    public GT_MetaTileEntity_Hatch_DynamoTunnel(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dynamotunnel.desc.0"), aAmp);
        Util.setTier(aTier, this);
    }

    public GT_MetaTileEntity_Hatch_DynamoTunnel(String aName, int aTier, int aAmp, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier]};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return CommonValues.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return CommonValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return 512L + CommonValues.V[this.mTier] * 4L * (long)this.Amperes;
    }

    @Override
    public long maxAmperesOut() {
        return 0L;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_DynamoTunnel(this.mName, this.mTier, this.Amperes, this.mDescription, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, this.mDescription, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dynamotunnel.desc.1") + ": " + EnumChatFormatting.YELLOW + (long)this.Amperes * this.maxEUOutput() + EnumChatFormatting.RESET + " EU/t"};
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        byte Tick;
        if (aBaseMetaTileEntity.isServerSide() && 16 == (Tick = (byte)(aTick % 20L))) {
            if (aBaseMetaTileEntity.getStoredEU() > 0L) {
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - (long)this.Amperes);
                if (aBaseMetaTileEntity.getStoredEU() < 0L) {
                    this.setEUVar(0L);
                }
            }
            if (aBaseMetaTileEntity.getStoredEU() > this.getMinimumStoredEU()) {
                this.moveAround(aBaseMetaTileEntity);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        byte color = this.getBaseMetaTileEntity().getColorization();
        if (color < 0) {
            return;
        }
        byte front = aBaseMetaTileEntity.getFrontFacing();
        byte opposite = GT_Utility.getOppositeSide((int)front);
        for (int dist = 1; dist < 1000; dist = (int)((short)(dist + 1))) {
            IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(front, dist);
            if (tGTTileEntity == null || tGTTileEntity.getColorization() != color) return;
            IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
            if (aMetaTileEntity == null) return;
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyTunnel && opposite == tGTTileEntity.getFrontFacing()) {
                if (this.maxEUOutput() > ((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).maxEUInput()) {
                    aMetaTileEntity.doExplosion(this.maxEUOutput());
                    this.setEUVar(aBaseMetaTileEntity.getStoredEU() - this.maxEUOutput());
                    return;
                }
                if (this.maxEUOutput() != ((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).maxEUInput()) return;
                long diff = Math.min((long)(this.Amperes * 20), Math.min(((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), this.maxEUStore() - aBaseMetaTileEntity.getStoredEU()) / this.maxEUOutput()) * this.maxEUOutput();
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - diff);
                ((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                return;
            }
            if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_Energy)) return;
            if (((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).connectionCount < 2) {
                return;
            }
            ((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).markUsed();
        }
    }

    @Override
    public boolean canConnect(byte side) {
        return this.isOutputFacing(side);
    }
}

