/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity;

import com.github.technus.tectech.thing.metaTileEntity.IFrontRotation;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RotationMessage
implements IMessage {
    int mPosX;
    int mPosY;
    int mPosZ;
    int mPosD;
    int mRotF;

    public RotationMessage() {
    }

    private RotationMessage(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
        IGregTechTileEntity base = metaTile.getBaseMetaTileEntity();
        this.mPosX = base.getXCoord();
        this.mPosY = base.getYCoord();
        this.mPosZ = base.getZCoord();
        this.mPosD = base.getWorld().field_73011_w.field_76574_g;
        this.mRotF = metaTile.getFrontRotation();
    }

    private RotationMessage(World world, int x, int y, int z, IFrontRotation front) {
        this.mPosX = x;
        this.mPosY = y;
        this.mPosZ = z;
        this.mPosD = world.field_73011_w.field_76574_g;
        this.mRotF = front.getFrontRotation();
    }

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tTag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.mPosX = tTag.func_74762_e("posx");
        this.mPosY = tTag.func_74762_e("posy");
        this.mPosZ = tTag.func_74762_e("posz");
        this.mPosD = tTag.func_74762_e("posd");
        this.mRotF = tTag.func_74762_e("rotf");
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tFXTag = new NBTTagCompound();
        tFXTag.func_74768_a("posx", this.mPosX);
        tFXTag.func_74768_a("posy", this.mPosY);
        tFXTag.func_74768_a("posz", this.mPosZ);
        tFXTag.func_74768_a("posd", this.mPosD);
        tFXTag.func_74768_a("rotf", this.mRotF);
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tFXTag);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<RotationQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, RotationQuery pMessage, MessageContext pCtx) {
            WorldServer world = DimensionManager.getWorld((int)pMessage.mPosD);
            if (world != null) {
                TileEntity te = world.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ);
                if (te instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
                    if (meta instanceof IFrontRotation) {
                        pMessage.mRotF = ((IFrontRotation)meta).getFrontRotation();
                        return new RotationData(pMessage);
                    }
                } else if (te instanceof IFrontRotation) {
                    pMessage.mRotF = ((IFrontRotation)te).getFrontRotation();
                    return new RotationData(pMessage);
                }
            }
            return null;
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<RotationData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, RotationData pMessage, MessageContext pCtx) {
            if (pPlayer.field_70170_p.field_73011_w.field_76574_g == pMessage.mPosD) {
                TileEntity te = pPlayer.field_70170_p.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ);
                if (te instanceof IGregTechTileEntity) {
                    IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
                    if (meta instanceof IFrontRotation) {
                        ((IFrontRotation)meta).forceSetRotationDoRender((byte)pMessage.mRotF);
                    }
                } else if (te instanceof IFrontRotation) {
                    ((IFrontRotation)te).forceSetRotationDoRender((byte)pMessage.mRotF);
                }
            }
            return null;
        }
    }

    public static class RotationData
    extends RotationMessage {
        public RotationData() {
        }

        private RotationData(RotationQuery query) {
            this.mPosX = query.mPosX;
            this.mPosY = query.mPosY;
            this.mPosZ = query.mPosZ;
            this.mPosD = query.mPosD;
            this.mRotF = query.mRotF;
        }

        public RotationData(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
            super(metaTile);
        }

        public RotationData(World world, int x, int y, int z, IFrontRotation front) {
            super(world, x, y, z, front);
        }
    }

    public static class RotationQuery
    extends RotationMessage {
        public RotationQuery() {
        }

        public RotationQuery(GT_MetaTileEntity_MultiblockBase_EM metaTile) {
            super(metaTile);
        }

        public RotationQuery(World world, int x, int y, int z, IFrontRotation front) {
            super(world, x, y, z, front);
        }
    }
}

