/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.AspectDefinitionCompat;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.ePrimalAspectDefinition;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.iElementalAspect;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eBosonDefinition;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public final class dComplexAspectDefinition
extends cElementalDefinition
implements iElementalAspect {
    private final int hash;
    public final float mass;
    private static final byte nbtType = 99;
    private final cElementalDefinitionStackMap aspectStacks;

    @Deprecated
    public dComplexAspectDefinition(cElementalDefinition ... aspects) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(aspects));
    }

    @Deprecated
    private dComplexAspectDefinition(boolean check, cElementalDefinition ... aspects) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(aspects));
    }

    public dComplexAspectDefinition(cElementalDefinitionStack ... aspects) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(aspects));
    }

    private dComplexAspectDefinition(boolean check, cElementalDefinitionStack ... aspects) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(aspects));
    }

    public dComplexAspectDefinition(cElementalDefinitionStackMap aspects) throws tElementalException {
        this(true, aspects);
    }

    private dComplexAspectDefinition(boolean check, cElementalDefinitionStackMap aspects) throws tElementalException {
        if (check && !dComplexAspectDefinition.canTheyBeTogether(aspects)) {
            throw new tElementalException("Hadron Definition error");
        }
        this.aspectStacks = aspects;
        float mass = 0.0f;
        for (cElementalDefinitionStack stack : aspects.values()) {
            mass += stack.getMass();
        }
        this.mass = mass;
        this.hash = super.hashCode();
    }

    private static boolean canTheyBeTogether(cElementalDefinitionStackMap stacks) {
        long amount = 0L;
        for (cElementalDefinitionStack aspects : stacks.values()) {
            if (!(aspects.definition instanceof dComplexAspectDefinition) && !(aspects.definition instanceof ePrimalAspectDefinition)) {
                return false;
            }
            amount += aspects.amount;
        }
        return amount == 2L;
    }

    @Override
    public String getName() {
        String name = AspectDefinitionCompat.aspectDefinitionCompat.getAspectTag(this);
        name = name != null ? name.substring(0, 1).toUpperCase() + name.substring(1) : this.getSymbol();
        return StatCollector.func_74838_a((String)"tt.keyword.Aspect") + ": " + name;
    }

    @Override
    public String getSymbol() {
        StringBuilder symbol = new StringBuilder(8);
        for (cElementalDefinitionStack aspect : this.aspectStacks.values()) {
            int i;
            if (aspect.definition instanceof ePrimalAspectDefinition) {
                i = 0;
                while ((long)i < aspect.amount) {
                    symbol.append(aspect.definition.getSymbol());
                    ++i;
                }
                continue;
            }
            symbol.append('(');
            i = 0;
            while ((long)i < aspect.amount) {
                symbol.append(aspect.definition.getSymbol());
                ++i;
            }
            symbol.append(')');
        }
        return symbol.toString();
    }

    @Override
    public String getShortSymbol() {
        StringBuilder symbol = new StringBuilder(8);
        for (cElementalDefinitionStack aspect : this.aspectStacks.values()) {
            int i;
            if (aspect.definition instanceof ePrimalAspectDefinition) {
                i = 0;
                while ((long)i < aspect.amount) {
                    symbol.append(aspect.definition.getShortSymbol());
                    ++i;
                }
                continue;
            }
            symbol.append('(');
            i = 0;
            while ((long)i < aspect.amount) {
                symbol.append(aspect.definition.getShortSymbol());
                ++i;
            }
            symbol.append(')');
        }
        return symbol.toString();
    }

    @Override
    public NBTTagCompound toNBT() {
        return dComplexAspectDefinition.getNbtTagCompound((byte)99, this.aspectStacks);
    }

    public static NBTTagCompound getNbtTagCompound(byte nbtType, cElementalDefinitionStackMap aspectStacks) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("t", nbtType);
        cElementalDefinitionStack[] quarkStacksValues = aspectStacks.values();
        nbt.func_74768_a("i", quarkStacksValues.length);
        for (int i = 0; i < quarkStacksValues.length; ++i) {
            nbt.func_74782_a(Integer.toString(i), (NBTBase)quarkStacksValues[i].toNBT());
        }
        return nbt;
    }

    public static dComplexAspectDefinition fromNBT(NBTTagCompound nbt) {
        cElementalDefinitionStack[] stacks = new cElementalDefinitionStack[nbt.func_74762_e("i")];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = cElementalDefinitionStack.fromNBT(nbt.func_74775_l(Integer.toString(i)));
        }
        try {
            return new dComplexAspectDefinition(stacks);
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public float getRawTimeSpan(long currentEnergy) {
        return -1.0f;
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return false;
    }

    @Override
    public int getCharge() {
        return 0;
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public byte getColor() {
        return -1;
    }

    @Override
    public cElementalDefinitionStackMap getSubParticles() {
        return this.aspectStacks;
    }

    @Override
    public cElementalDecay[] getEnergyInducedDecay(long energyLevel) {
        return new cElementalDecay[]{new cElementalDecay(0.75f, this.aspectStacks), eBosonDefinition.deadEnd};
    }

    @Override
    public float getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0f * (float)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public cElementalDecay[] getNaturalDecayInstant() {
        return cElementalDecay.noDecay;
    }

    @Override
    public cElementalDecay[] getDecayArray() {
        return cElementalDecay.noDecay;
    }

    @Override
    public float getMass() {
        return this.mass;
    }

    @Override
    public aFluidDequantizationInfo someAmountIntoFluidStack() {
        return null;
    }

    @Override
    public aItemDequantizationInfo someAmountIntoItemsStack() {
        return null;
    }

    @Override
    public aOredictDequantizationInfo someAmountIntoOredictStack() {
        return null;
    }

    @Override
    public Object materializeIntoAspect() {
        return AspectDefinitionCompat.aspectDefinitionCompat.getAspect(this);
    }

    @Override
    public iElementalDefinition getAnti() {
        return null;
    }

    public static void run() {
        block3: {
            try {
                cElementalDefinition.addCreatorFromNBT((byte)99, dComplexAspectDefinition.class.getMethod("fromNBT", NBTTagCompound.class), (byte)-96);
            }
            catch (Exception e) {
                if (!TecTechConfig.DEBUG_MODE) break block3;
                e.printStackTrace();
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)"Registered Elemental Matter Class: ComplexAspect 99 -96");
        }
    }

    @Override
    public byte getClassType() {
        return -96;
    }

    public static byte getClassTypeStatic() {
        return -96;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public void addScanShortSymbols(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(25, capabilities)) {
            lines.add(this.getShortSymbol());
        }
    }

    @Override
    public void addScanResults(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(2048, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.CLASS") + " = " + 99 + ' ' + this.getClassType());
        }
        if (Util.areBitsSet(25, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.NAME") + " = " + this.getName());
        }
        if (Util.areBitsSet(8, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.CHARGE") + " = " + (float)this.getCharge() / 3.0f + " e");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add(this.getColor() < 0 ? StatCollector.func_74838_a((String)"tt.keyword.COLORLESS") : StatCollector.func_74838_a((String)"tt.keyphrase.CARRIES_COLOR"));
        }
        if (Util.areBitsSet(16, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.MASS") + " = " + this.getMass() + " eV/c\u00b2");
        }
        if (Util.areBitsSet(64, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyphrase.LIFE_TIME") + " = " + this.getRawTimeSpan(energyLevel) + " s");
            lines.add("    " + StatCollector.func_74838_a((String)"tt.keyphrase.At_current_energy_level"));
        }
    }
}

