/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.openComputers;

import com.github.technus.avrClone.AvrCore;
import com.github.technus.avrClone.instructions.ExecutionEvent;
import com.github.technus.avrClone.instructions.InstructionRegistry;
import com.github.technus.avrClone.instructions.exceptions.DelayEvent;
import com.github.technus.avrClone.memory.EepromMemory;
import com.github.technus.avrClone.memory.RemovableMemory;
import com.github.technus.avrClone.memory.program.ProgramMemory;
import com.github.technus.tectech.Converter;
import com.github.technus.tectech.TecTech;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.Settings;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Item;
import li.cil.oc.api.driver.item.Memory;
import li.cil.oc.api.machine.Architecture;
import li.cil.oc.api.machine.ExecutionResult;
import li.cil.oc.api.machine.Machine;
import li.cil.oc.api.machine.MachineHost;
import li.cil.oc.api.machine.Signal;
import li.cil.oc.common.SaveHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

@Architecture.Name(value="AVR 32Bit Clone")
@Architecture.NoMemoryRequirements
public class AvrArchitecture
implements Architecture {
    private final Machine machine;
    private AvrCore core;
    private boolean debugRun;
    private int delay;
    private int[] tempData;
    private int memSize;

    public AvrArchitecture(Machine machine) {
        this.machine = machine;
    }

    public boolean isInitialized() {
        return this.core != null && this.core.checkValid();
    }

    public boolean recomputeMemory(Iterable<ItemStack> components) {
        this.computeMemory(components);
        return true;
    }

    private void computeMemory(Iterable<ItemStack> components) {
        int memory = 0;
        for (ItemStack component : components) {
            Item driver = Driver.driverFor((ItemStack)component);
            if (!(driver instanceof Memory)) continue;
            Memory memoryDriver = (Memory)driver;
            memory = (int)((double)memory + memoryDriver.amount(component) * 256.0);
        }
        if ((memory = Math.min(Math.max(memory, 0), Settings.get().maxTotalRam())) != this.memSize) {
            // empty if block
        }
    }

    public boolean initialize() {
        this.core = new AvrCore();
        this.computeMemory(this.machine.host().internalComponents());
        if (this.isInitialized()) {
            this.machine.beep(".");
            return true;
        }
        return false;
    }

    public void close() {
        this.core = null;
        this.tempData = null;
        this.delay = 0;
    }

    public void runSynchronized() {
        this.core.cycle();
    }

    public ExecutionResult runThreaded(boolean isSynchronizedReturn) {
        if (this.core.awoken) {
            this.delay = 0;
            for (int load = 0; load < 512; load += this.core.getInstruction().getCost(this.core)) {
                ExecutionEvent executionEvent = this.core.cpuCycleForce();
                if (executionEvent == null) continue;
                if (!(executionEvent.throwable instanceof DelayEvent)) continue;
                this.delay = executionEvent.data[0];
                break;
            }
        } else if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.core.awoken = true;
            }
        }
        return null;
    }

    public void onSignal() {
        Signal signal = this.machine.popSignal();
        this.core.interruptsHandle();
    }

    public void onConnect() {
    }

    public void load(NBTTagCompound avr) {
        byte[] data;
        this.debugRun = avr.func_74767_n("debugRun");
        this.delay = avr.func_74762_e("delay");
        this.core.active = avr.func_74767_n("active");
        this.core.awoken = avr.func_74767_n("awoken");
        this.core.programCounter = avr.func_74762_e("programCounter");
        InstructionRegistry registry = InstructionRegistry.REGISTRIES.get(avr.func_74779_i("instructionRegistry"));
        if (registry != null) {
            byte[] instructions = SaveHandler.load((NBTTagCompound)avr, (String)(this.machine.node().address() + "_instructionsMemory"));
            byte[] param0 = SaveHandler.load((NBTTagCompound)avr, (String)(this.machine.node().address() + "_param0Memory"));
            byte[] param1 = SaveHandler.load((NBTTagCompound)avr, (String)(this.machine.node().address() + "_param1Memory"));
            if (instructions != null && param0 != null && param1 != null && instructions.length > 0 && param0.length > 0 && param1.length > 0) {
                GZIPInputStream gzis;
                int[] instr = null;
                int[] par0 = null;
                int[] par1 = null;
                try {
                    gzis = new GZIPInputStream(new ByteArrayInputStream(instructions));
                    instr = Converter.readInts(IOUtils.toByteArray((InputStream)gzis));
                    IOUtils.closeQuietly((InputStream)gzis);
                }
                catch (IOException e) {
                    TecTech.LOGGER.error((Object)"Failed to decompress instructions memory from disk.");
                    e.printStackTrace();
                }
                try {
                    gzis = new GZIPInputStream(new ByteArrayInputStream(param0));
                    par0 = Converter.readInts(IOUtils.toByteArray((InputStream)gzis));
                    IOUtils.closeQuietly((InputStream)gzis);
                }
                catch (IOException e) {
                    TecTech.LOGGER.error((Object)"Failed to decompress param0 memory from disk.");
                    e.printStackTrace();
                }
                try {
                    gzis = new GZIPInputStream(new ByteArrayInputStream(param1));
                    par1 = Converter.readInts(IOUtils.toByteArray((InputStream)gzis));
                    IOUtils.closeQuietly((InputStream)gzis);
                }
                catch (IOException e) {
                    TecTech.LOGGER.error((Object)"Failed to decompress param1 memory from disk.");
                    e.printStackTrace();
                }
                if (instr != null && par0 != null && par1 != null && instr.length == par0.length && instr.length == par1.length) {
                    this.core.setProgramMemory(new ProgramMemory(registry, avr.func_74767_n("immersive"), instr, par0, par1));
                }
            }
        }
        if (avr.func_74764_b("eepromSize")) {
            this.core.restoreEepromDefinition(EepromMemory.make(avr.func_74762_e("eepromSize")));
        }
        if ((data = SaveHandler.load((NBTTagCompound)avr, (String)(this.machine.node().address() + "_dataMemory"))) != null && data.length > 0) {
            try {
                GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(data));
                this.tempData = Converter.readInts(IOUtils.toByteArray((InputStream)gzis));
                IOUtils.closeQuietly((InputStream)gzis);
            }
            catch (IOException e) {
                TecTech.LOGGER.error((Object)"Failed to decompress data memory from disk.");
                e.printStackTrace();
            }
        }
        this.core.checkValid();
    }

    public void save(NBTTagCompound avr) {
        RemovableMemory<EepromMemory> eeprom;
        avr.func_74757_a("debugRun", this.debugRun);
        avr.func_74768_a("delay", this.delay);
        avr.func_74757_a("active", this.core.active);
        avr.func_74757_a("awoken", this.core.awoken);
        avr.func_74768_a("programCounter", this.core.programCounter);
        ProgramMemory programMemory = this.core.getProgramMemory();
        if (programMemory != null) {
            GZIPOutputStream gzos;
            ByteArrayOutputStream baos;
            try {
                baos = new ByteArrayOutputStream();
                gzos = new GZIPOutputStream(baos);
                gzos.write(Converter.writeInts(programMemory.instructions));
                gzos.close();
                SaveHandler.scheduleSave((MachineHost)this.machine.host(), (NBTTagCompound)avr, (String)(this.machine.node().address() + "_instructionsMemory"), (byte[])baos.toByteArray());
            }
            catch (IOException e) {
                TecTech.LOGGER.error((Object)"Failed to compress instructions memory to disk");
                e.printStackTrace();
            }
            try {
                baos = new ByteArrayOutputStream();
                gzos = new GZIPOutputStream(baos);
                gzos.write(Converter.writeInts(programMemory.param0));
                gzos.close();
                SaveHandler.scheduleSave((MachineHost)this.machine.host(), (NBTTagCompound)avr, (String)(this.machine.node().address() + "_param0Memory"), (byte[])baos.toByteArray());
            }
            catch (IOException e) {
                TecTech.LOGGER.error((Object)"Failed to compress param0 memory to disk");
                e.printStackTrace();
            }
            try {
                baos = new ByteArrayOutputStream();
                gzos = new GZIPOutputStream(baos);
                gzos.write(Converter.writeInts(programMemory.param1));
                gzos.close();
                SaveHandler.scheduleSave((MachineHost)this.machine.host(), (NBTTagCompound)avr, (String)(this.machine.node().address() + "_param1Memory"), (byte[])baos.toByteArray());
            }
            catch (IOException e) {
                TecTech.LOGGER.error((Object)"Failed to compress param1 memory to disk");
                e.printStackTrace();
            }
            avr.func_74757_a("immersive", programMemory.immersiveOperands);
            avr.func_74778_a("instructionRegistry", programMemory.registry.toString());
        }
        if ((eeprom = this.core.getEepromMemory()) != null) {
            avr.func_74768_a("eepromSize", eeprom.getDefinition().getSize());
        }
        if (this.core.dataMemory != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(Converter.writeInts(this.core.dataMemory));
                gzos.close();
                SaveHandler.scheduleSave((MachineHost)this.machine.host(), (NBTTagCompound)avr, (String)(this.machine.node().address() + "_dataMemory"), (byte[])baos.toByteArray());
            }
            catch (IOException e) {
                TecTech.LOGGER.error((Object)"Failed to compress data memory to disk");
                e.printStackTrace();
            }
        }
    }
}

