/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.avrClone.registerPackages;

import com.github.technus.avrClone.registerPackages.IInterrupt;
import com.github.technus.avrClone.registerPackages.IRegister;
import com.github.technus.avrClone.registerPackages.IRegisterBit;
import com.github.technus.avrClone.registerPackages.IRegisterPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class RegisterPackage
implements IRegisterPackage {
    protected final Map<String, IRegisterBit> bits = new HashMap<String, IRegisterBit>();
    protected final Map<String, IRegister> registers = new HashMap<String, IRegister>();
    protected final Map<Integer, ArrayList<IRegister>> addresses = new HashMap<Integer, ArrayList<IRegister>>();
    protected final Map<Integer, IInterrupt> interrupts = new HashMap<Integer, IInterrupt>();
    private final int offset;
    private final int size;

    protected RegisterPackage(int offset, int size) {
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Map<String, IRegister> registersMap() {
        return this.registers;
    }

    @Override
    public Map<Integer, ArrayList<IRegister>> addressesMap() {
        return this.addresses;
    }

    @Override
    public Map<String, IRegisterBit> bitsMap() {
        return this.bits;
    }

    @Override
    public int[] getDataDefault() {
        return new int[this.getSize()];
    }

    @Override
    public Map<Integer, IInterrupt> interruptsMap() {
        return this.interrupts;
    }

    protected void addRegisters(IRegister ... registers) {
        for (IRegister register : registers) {
            this.registers.put(register.name(), register);
            this.addresses.computeIfAbsent(register.getAddress(this), ArrayList::new).add(register);
        }
    }

    protected void addBits(IRegisterBit ... bits) {
        for (IRegisterBit bit : bits) {
            this.bits.put(bit.name(), bit);
        }
    }

    protected void addInterrupts(IInterrupt ... interrupts) {
        for (IInterrupt interrupt : interrupts) {
            this.interrupts.put(interrupt.getVector(), interrupt);
        }
    }
}

