/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.em_machine;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.atom.dAtomDefinition;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.MultiblockControl;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_machine.GT_MetaTileEntity_EM_machine;
import java.util.ArrayList;

public class Behaviour_ElectromagneticSeparator
extends GT_MetaTileEntity_EM_machine.Behaviour {
    private final byte tier;
    private final int ticks;
    private final byte precisionFull;
    private final byte precisionMinimal;
    private final float maxCapacity;
    private final long maxCharge;
    private final int offsetMax;
    private static final String[] DESCRIPTION_I = new String[]{"Full Precision Input [e/3]", "Minimal Precision Input [e/3]", "Offset Input [e/3]", null};
    private static final String[] DESCRIPTION_O = new String[]{"Full Precision Limit [e/3]", "Minimal Precision Limit [e/3]", "Offset Limit [e/3]", null, "Max Charge [e/3]", "Max Capacity [eV/c^2]", "Max Power Usage[EU/t]", "Max Recipe Rime [tick]"};

    public Behaviour_ElectromagneticSeparator(int desiredTier) {
        this.tier = (byte)desiredTier;
        this.ticks = Math.max(20, (1 << 12 - desiredTier) * 20);
        this.maxCapacity = dAtomDefinition.getSomethingHeavy().getMass() * (float)(2 << this.tier);
        this.maxCharge = 144 * (1 << this.tier - 5);
        switch (this.tier) {
            case 12: {
                this.precisionFull = 1;
                this.precisionMinimal = 1;
                break;
            }
            case 11: {
                this.precisionFull = (byte)2;
                this.precisionMinimal = 1;
                break;
            }
            case 10: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = 1;
                break;
            }
            case 9: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = (byte)2;
                break;
            }
            case 8: {
                this.precisionFull = (byte)3;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 7: {
                this.precisionFull = (byte)6;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 6: {
                this.precisionFull = (byte)12;
                this.precisionMinimal = (byte)3;
                break;
            }
            case 5: {
                this.precisionFull = (byte)24;
                this.precisionMinimal = (byte)6;
                break;
            }
            default: {
                this.precisionMinimal = (byte)127;
                this.precisionFull = (byte)127;
            }
        }
        this.offsetMax = 1 << (this.tier - 8 << 1);
    }

    @Override
    protected void getFullLedDescriptionIn(ArrayList<String> baseDescr, int hatchNo, int paramID) {
        String desc;
        if (hatchNo <= 1 && (desc = DESCRIPTION_I[(hatchNo << 1) + paramID]) != null) {
            baseDescr.add(desc);
        }
    }

    @Override
    protected void getFullLedDescriptionOut(ArrayList<String> baseDescr, int hatchNo, int paramID) {
        String desc;
        if (hatchNo <= 3 && (desc = DESCRIPTION_O[(hatchNo << 1) + paramID]) != null) {
            baseDescr.add(desc);
        }
    }

    @Override
    public boolean setAndCheckParametersOutAndStatuses(GT_MetaTileEntity_EM_machine te, double[] parametersToCheckAndFix) {
        int i;
        boolean check = true;
        te.setParameterOut(0, 0, this.precisionFull);
        te.setParameterOut(0, 1, this.precisionMinimal);
        te.setParameterOut(1, 0, this.offsetMax);
        te.setStatusOfParameterOut(1, 1, (byte)7);
        te.setParameterOut(2, 0, this.maxCharge);
        te.setParameterOut(2, 1, this.maxCapacity);
        te.setParameterOut(3, 0, CommonValues.V[this.tier]);
        te.setParameterOut(3, 1, this.ticks);
        for (i = 4; i <= 9; ++i) {
            te.setStatusOfParameterOut(i, 0, (byte)7);
            te.setStatusOfParameterOut(i, 1, (byte)7);
        }
        te.setStatusOfParameterIn(1, 1, (byte)7);
        for (i = 2; i <= 3; ++i) {
            te.setStatusOfParameterIn(i, 0, (byte)7);
            te.setStatusOfParameterIn(i, 1, (byte)7);
        }
        double full = parametersToCheckAndFix[0];
        if (Double.isInfinite(full) && full > 0.0) {
            te.setStatusOfParameterIn(0, 0, (byte)5);
            check = false;
        } else if (full > (double)this.precisionFull) {
            te.setStatusOfParameterIn(0, 0, (byte)6);
        } else if (full == (double)this.precisionFull) {
            te.setStatusOfParameterIn(0, 0, (byte)4);
        } else if (full < (double)this.precisionFull) {
            te.setStatusOfParameterIn(0, 0, (byte)1);
            check = false;
        } else {
            te.setStatusOfParameterIn(0, 0, (byte)3);
            check = false;
        }
        double minimal = parametersToCheckAndFix[1];
        if (Double.isInfinite(minimal) && minimal > 0.0) {
            te.setStatusOfParameterIn(0, 1, (byte)5);
            check = false;
        } else if (minimal > (double)this.precisionMinimal) {
            if (minimal > full) {
                te.setStatusOfParameterIn(0, 1, (byte)5);
                check = false;
            } else {
                te.setStatusOfParameterIn(0, 1, (byte)6);
            }
        } else if (minimal == (double)this.precisionMinimal) {
            if (minimal > full) {
                te.setStatusOfParameterIn(0, 1, (byte)5);
                check = false;
            } else {
                te.setStatusOfParameterIn(0, 1, (byte)4);
            }
        } else if (minimal < (double)this.precisionMinimal) {
            te.setStatusOfParameterIn(0, 1, (byte)1);
            check = false;
        } else {
            te.setStatusOfParameterIn(0, 1, (byte)3);
            check = false;
        }
        double offset = parametersToCheckAndFix[2];
        if (offset > (double)this.offsetMax) {
            te.setStatusOfParameterIn(1, 0, (byte)5);
            check = false;
        } else if (offset > 0.0) {
            te.setStatusOfParameterIn(1, 0, (byte)6);
        } else if (offset == 0.0) {
            te.setStatusOfParameterIn(1, 0, (byte)4);
        } else if (offset >= (double)(-this.offsetMax)) {
            te.setStatusOfParameterIn(1, 0, (byte)2);
        } else if (offset < (double)(-this.offsetMax)) {
            te.setStatusOfParameterIn(1, 0, (byte)1);
            check = false;
        } else {
            te.setStatusOfParameterIn(1, 0, (byte)3);
            check = false;
        }
        return check;
    }

    @Override
    public MultiblockControl<cElementalInstanceStackMap[]> process(cElementalInstanceStackMap[] inputs, double[] checkedAndFixedParameters) {
        cElementalInstanceStackMap input = inputs[0];
        if (input == null || input.isEmpty()) {
            return null;
        }
        cElementalInstanceStack[] stacks = input.values();
        double inputMass = 0.0;
        for (cElementalInstanceStack stack : stacks) {
            inputMass += (double)Math.abs(stack.getMass());
        }
        float excessMass = 0.0f;
        while (inputMass > (double)this.maxCapacity) {
            cElementalInstanceStack randomStack = stacks[TecTech.RANDOM.nextInt(stacks.length)];
            int amountToRemove = TecTech.RANDOM.nextInt((int)randomStack.getAmount()) + 1;
            randomStack.amount -= (long)amountToRemove;
            if (randomStack.amount <= 0L) {
                input.remove(randomStack.definition);
            }
            float mass = Math.abs(randomStack.getDefinition().getMass()) * (float)amountToRemove;
            excessMass += mass;
            inputMass -= (double)mass;
        }
        long totalCharge = Math.abs(input.getCharge());
        if (totalCharge > this.maxCharge) {
            return new MultiblockControl<cElementalInstanceStackMap[]>(excessMass);
        }
        int mEut = (int)((double)totalCharge / (double)this.maxCharge * (double)CommonValues.V[this.tier]);
        mEut = Math.max(mEut, 512);
        int mTicks = (int)((double)this.ticks * (inputMass / (double)this.maxCapacity));
        mTicks = Math.max(mTicks, 20);
        cElementalInstanceStackMap[] outputs = new cElementalInstanceStackMap[3];
        for (int i = 0; i < 3; ++i) {
            outputs[i] = new cElementalInstanceStackMap();
        }
        double offsetIn = checkedAndFixedParameters[2];
        double precisionFullIn = checkedAndFixedParameters[0];
        double precisionMinimalIn = checkedAndFixedParameters[1];
        double levelsCountPlus1 = precisionFullIn - precisionMinimalIn + 1.0;
        for (cElementalInstanceStack stack : stacks = input.takeAllToNewMap().values()) {
            double charge = (double)stack.definition.getCharge() - offsetIn;
            if (charge < precisionMinimalIn && charge > -precisionMinimalIn) {
                outputs[1].putReplace(stack);
                continue;
            }
            if (charge >= precisionFullIn) {
                outputs[2].putReplace(stack);
                continue;
            }
            if (charge <= -precisionFullIn) {
                outputs[0].putReplace(stack);
                continue;
            }
            long amount = (long)((double)stack.amount * ((Math.abs(charge) - precisionMinimalIn + 1.0) / levelsCountPlus1));
            if (amount >= stack.amount) {
                if (charge > 0.0) {
                    outputs[2].putReplace(stack);
                    continue;
                }
                outputs[0].putReplace(stack);
                continue;
            }
            cElementalInstanceStack clone = stack.clone();
            clone.amount -= amount;
            outputs[1].putReplace(clone);
            stack.amount = amount;
            if (charge > 0.0) {
                outputs[2].putReplace(stack);
                continue;
            }
            outputs[0].putReplace(stack);
        }
        return new MultiblockControl<cElementalInstanceStackMap[]>(outputs, mEut, 1 + (int)Math.abs(offsetIn) / 3, 0, 10000, mTicks, 0, excessMass);
    }
}

