/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.atom;

import com.github.technus.tectech.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

public final class iaeaNuclide {
    public static final double AMU_TO_EV_DIV_C_C = 9.31494061E8;
    public static final double MICRO_AMU_TO_EV_DIV_C_C = 931.494061;
    private static final HashMap<Integer, iaeaNuclide> NUCLIDES = new HashMap();
    public final short N;
    public final short Z;
    public final float halfTime;
    public final float mass;
    public final short discovery;
    private TreeMap<Float, energeticState> energeticStates;
    public energeticState[] energeticStatesArray;
    private static final energeticState[] empty = new energeticState[0];
    private static HashSet<String> decays = new HashSet();

    public static void run() {
        String[] split;
        BufferedReader reader;
        String line = "";
        try {
            reader = new BufferedReader(new InputStreamReader(iaeaNuclide.class.getResourceAsStream("nuclides.csv")));
            ArrayList<String[]> blockOfData = new ArrayList<String[]>(4);
            while ((line = reader.readLine()) != null) {
                String[] split2 = Util.splitButDifferent(line, ",");
                if (split2.length != 19) {
                    throw new Error("Invalid count (" + split2.length + ") of separators in IAEA nuclides database " + line);
                }
                if (!split2[1].isEmpty() && !blockOfData.isEmpty()) {
                    new iaeaNuclide((String[][])blockOfData.toArray((T[])new String[blockOfData.size()][]));
                    blockOfData.clear();
                }
                blockOfData.add(split2);
            }
            if (!blockOfData.isEmpty()) {
                new iaeaNuclide((String[][])blockOfData.toArray((T[])new String[blockOfData.size()][]));
                blockOfData.clear();
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(iaeaNuclide.class.getResourceAsStream("nuclidesTable.csv")));
            while ((line = reader.readLine()) != null) {
                split = Util.splitButDifferent(line, ",");
                if (split.length != 47) {
                    throw new Error("Invalid count (" + split.length + ") of separators in IAEA nuvlidesTable database " + line);
                }
                iaeaNuclide.get(Integer.parseInt(split[0]), Integer.parseInt(split[1])).getMoreData(split);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(iaeaNuclide.class.getResourceAsStream("energyLevels.csv")));
            while ((line = reader.readLine()) != null) {
                split = Util.splitButDifferent(line, ",");
                if (split.length != 27) {
                    throw new Error("Invalid count (" + split.length + ") of separators in IAEA energyLevels database " + line);
                }
                new energeticState(split);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(line);
            e.printStackTrace();
        }
        for (iaeaNuclide nuclide : NUCLIDES.values()) {
            nuclide.makeArrayOfEnergyStates();
        }
    }

    public static iaeaNuclide get(int protons, int neutrons) {
        return NUCLIDES.get((protons << 16) + neutrons);
    }

    private iaeaNuclide(String[][] rows) {
        this.N = Short.parseShort(rows[1][2]);
        this.Z = Short.parseShort(rows[1][0]);
        NUCLIDES.put((this.Z << 16) + this.N, this);
        String[] parts = Util.splitButDifferent(rows[0][16], "|");
        double Mass = this.doubleOrNaN(parts[0], "mass");
        this.mass = !Double.isNaN(Mass) ? (float)(Mass * 931.494061) : Float.NaN;
        this.discovery = (short)this.doubleOrNaN(rows[0][18], "discovery");
        if (rows[0][3].contains("STABLE")) {
            this.halfTime = 1.5E36f;
        } else {
            parts = Util.splitButDifferent(rows[0][4], "|");
            this.halfTime = (float)this.doubleOrNaN(parts[0], "half life");
        }
    }

    private void getMoreData(String[] cells) {
        new energeticState(this, this.halfTime, iaeaNuclide.getDecaysFixed(cells[14], this.doubleOrNaN(cells[15], "chance1"), cells[17], this.doubleOrNaN(cells[18], "chance1"), cells[20], this.doubleOrNaN(cells[21], "chance1")));
    }

    private void makeArrayOfEnergyStates() {
        this.energeticStatesArray = this.energeticStates == null || this.energeticStates.isEmpty() ? empty : this.energeticStates.values().toArray(new energeticState[this.energeticStates.size()]);
    }

    private double doubleOrNaN(String s, String name) {
        if (!(s = s.replaceAll("#", "")).isEmpty()) {
            try {
                double value = Double.parseDouble(s);
                if (Double.isNaN(value)) {
                    return Double.NaN;
                }
                return value != 0.0 ? value : Double.NaN;
            }
            catch (Exception e) {
                System.out.println("Invalid Value " + name + ' ' + this.N + ' ' + this.Z + ' ' + s);
                e.printStackTrace();
            }
        }
        return Double.NaN;
    }

    private static boolean add(String s) {
        if (decays.add(s)) {
            System.out.println(s);
            return true;
        }
        return false;
    }

    private static iaeaDecay[] getDecaysFixed(String decay1, double chance1, String decay2, double chance2, String decay3, double chance3) {
        boolean do1 = !decay1.isEmpty() && !Double.isNaN(chance1);
        boolean do2 = !decay2.isEmpty() && !Double.isNaN(chance2);
        boolean do3 = !decay3.isEmpty() && !Double.isNaN(chance3);
        TreeMap<Double, iaeaDecay> decays = new TreeMap<Double, iaeaDecay>();
        if (do1 && do2 && chance1 == 100.0 && chance2 == 100.0 && chance3 != 100.0) {
            decays.put(1.0, new iaeaDecay(1.0f, decay1));
            if (do3) {
                decays.put(chance3 /= 100.0, new iaeaDecay((float)chance3, decay2));
                chance2 = 1.0 - chance3;
            }
            decays.put(chance2 /= 2.0, new iaeaDecay((float)chance2, decay2));
        } else if (do1 && chance1 == 100.0) {
            decays.put(1.0, new iaeaDecay(1.0f, decay1));
            if (do2) {
                decays.put(chance2 /= 100.0, new iaeaDecay((float)chance2, decay2));
            }
            if (do3) {
                chance3 /= 100.0;
                if (do2) {
                    chance3 *= chance2;
                }
                decays.put(chance3, new iaeaDecay((float)chance3, decay3));
            }
        } else {
            double normalization = (do1 ? chance1 : 0.0) + (do2 ? chance2 : 0.0) + (do3 ? chance3 : 0.0);
            if (do1) {
                decays.put(chance1 /= normalization, new iaeaDecay((float)chance1, decay1));
            }
            if (do2) {
                decays.put(chance2 /= normalization, new iaeaDecay((float)chance2, decay2));
            }
            if (do3) {
                decays.put(chance3 /= normalization, new iaeaDecay((float)chance3, decay3));
            }
            if (do1 || do2 || do3) {
                decays.put(1.0, iaeaDecay.DEAD_END);
            }
        }
        return decays.values().toArray(new iaeaDecay[decays.size()]);
    }

    public static final class iaeaDecay {
        public final float chance;
        public final String decayName;
        public static final iaeaDecay DEAD_END = new iaeaDecay(1.0f, "DEAD_END");

        private iaeaDecay(float chance, String decayName) {
            this.chance = chance;
            this.decayName = decayName;
        }
    }

    public static final class energeticState {
        public final float energy;
        public final float Thalf;
        public final iaeaDecay[] decaymodes;

        private energeticState(iaeaNuclide nuclide, float Thalf, iaeaDecay[] decaymodes) {
            this.energy = 0.0f;
            this.Thalf = Thalf;
            this.decaymodes = decaymodes;
            if (nuclide.energeticStates == null) {
                nuclide.energeticStates = new TreeMap();
            }
            nuclide.energeticStates.put(Float.valueOf(this.energy), this);
        }

        private energeticState(String[] cells) {
            iaeaNuclide nuclide = iaeaNuclide.get((int)this.doubleOrNaN(cells[0], "protons"), (int)this.doubleOrNaN(cells[1], "neutrons"));
            if (nuclide == null) {
                throw new Error("Missing nuclide " + (int)this.doubleOrNaN(cells[0], "protons") + ' ' + (int)this.doubleOrNaN(cells[1], "neutrons"));
            }
            this.energy = (float)(this.doubleOrNaN(cells[3], "energy level", nuclide) * 1000.0);
            if (this.energy < 0.0f) {
                throw new Error("Invalid energy " + nuclide.N + ' ' + nuclide.Z + ' ' + cells[3]);
            }
            this.Thalf = (float)this.doubleOrNaN(cells[10], "half life", nuclide);
            if (nuclide.energeticStates == null) {
                new Exception("Should be initialized before doing this... " + nuclide.N + ' ' + nuclide.Z).printStackTrace();
                nuclide.energeticStates = new TreeMap();
            }
            nuclide.energeticStates.put(Float.valueOf(this.energy), this);
            this.decaymodes = iaeaNuclide.getDecaysFixed(cells[12], this.doubleOrNaN(cells[13], "chance 1", nuclide), cells[15], this.doubleOrNaN(cells[16], "chance 2", nuclide), cells[18], this.doubleOrNaN(cells[19], "chance 3", nuclide));
        }

        private double doubleOrNaN(String s, String name) {
            return this.doubleOrNaN(s, name, null);
        }

        private double doubleOrNaN(String s, String name, iaeaNuclide nuclide) {
            if (!(s = s.replaceAll("#", "")).isEmpty()) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception e) {
                    if (nuclide == null) {
                        System.out.println("Invalid Value " + name + ' ' + s);
                    } else {
                        System.out.println("Invalid Value " + name + ' ' + nuclide.N + ' ' + nuclide.Z + ' ' + s);
                    }
                    e.printStackTrace();
                }
            }
            return Double.NaN;
        }
    }
}

