/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core;

import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;

public final class cElementalMutableDefinitionStackMap
extends cElementalStackMap {
    public cElementalMutableDefinitionStackMap() {
        this.map = new TreeMap();
    }

    @Deprecated
    public cElementalMutableDefinitionStackMap(iElementalDefinition ... in) {
        this.map = new TreeMap();
        for (iElementalDefinition def : in) {
            this.putUnify(new cElementalDefinitionStack(def, 1L));
        }
    }

    public cElementalMutableDefinitionStackMap(cElementalDefinitionStack ... in) {
        this.map = new TreeMap();
        this.putUnifyAll(in);
    }

    public cElementalMutableDefinitionStackMap(TreeMap<iElementalDefinition, cElementalDefinitionStack> in) {
        this(true, in);
    }

    public cElementalMutableDefinitionStackMap(boolean clone, TreeMap<iElementalDefinition, cElementalDefinitionStack> in) {
        this.map = clone ? new TreeMap<iElementalDefinition, cElementalDefinitionStack>((SortedMap<iElementalDefinition, cElementalDefinitionStack>)in) : in;
    }

    @Override
    public cElementalMutableDefinitionStackMap clone() {
        return new cElementalMutableDefinitionStackMap(this.map);
    }

    public cElementalDefinitionStackMap toImmutable() {
        return new cElementalDefinitionStackMap(this.map);
    }

    public cElementalDefinitionStackMap toImmutable_optimized_unsafeLeavesExposedElementalTree() {
        return new cElementalDefinitionStackMap(this);
    }

    @Override
    @Deprecated
    public TreeMap<iElementalDefinition, cElementalDefinitionStack> getRawMap() {
        return this.map;
    }

    public void clear() {
        this.map.clear();
    }

    public cElementalDefinitionStack remove(iElementalDefinition def) {
        return (cElementalDefinitionStack)this.map.remove(def);
    }

    @Deprecated
    public cElementalDefinitionStack remove(iHasElementalDefinition has) {
        return (cElementalDefinitionStack)this.map.remove(has.getDefinition());
    }

    public void removeAll(iElementalDefinition ... definitions) {
        for (iElementalDefinition def : definitions) {
            this.map.remove(def);
        }
    }

    @Deprecated
    public void removeAll(iHasElementalDefinition ... hasElementalDefinition) {
        for (iHasElementalDefinition has : hasElementalDefinition) {
            this.map.remove(has.getDefinition());
        }
    }

    public boolean removeAmount(boolean testOnly, cElementalInstanceStack instance) {
        cElementalDefinitionStack target = (cElementalDefinitionStack)this.map.get(instance.definition);
        if (target == null) {
            return false;
        }
        if (testOnly) {
            return target.amount >= instance.amount;
        }
        long diff = target.amount - instance.amount;
        if (diff > 0L) {
            this.map.put(target.definition, new cElementalDefinitionStack(target.definition, diff));
            return true;
        }
        if (diff == 0L) {
            this.map.remove(instance.definition);
            return true;
        }
        return false;
    }

    public boolean removeAmount(boolean testOnly, iHasElementalDefinition stack) {
        cElementalDefinitionStack target = (cElementalDefinitionStack)this.map.get(stack.getDefinition());
        if (target == null) {
            return false;
        }
        if (testOnly) {
            return target.amount >= stack.getAmount();
        }
        long diff = target.amount - stack.getAmount();
        if (diff > 0L) {
            this.map.put(target.definition, new cElementalDefinitionStack(target.definition, diff));
            return true;
        }
        if (diff == 0L) {
            this.map.remove(stack.getDefinition());
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeAmount(boolean testOnly, iElementalDefinition def) {
        return this.removeAmount(testOnly, new cElementalDefinitionStack(def, 1L));
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalInstanceStack ... instances) {
        boolean test = true;
        for (cElementalInstanceStack stack : instances) {
            test &= this.removeAmount(true, stack);
        }
        if (testOnly || !test) {
            return test;
        }
        for (cElementalInstanceStack stack : instances) {
            this.removeAmount(false, stack);
        }
        return true;
    }

    public boolean removeAllAmounts(boolean testOnly, iHasElementalDefinition ... stacks) {
        boolean test = true;
        for (iHasElementalDefinition stack : stacks) {
            test &= this.removeAmount(true, stack);
        }
        if (testOnly || !test) {
            return test;
        }
        for (iHasElementalDefinition stack : stacks) {
            this.removeAmount(false, stack);
        }
        return true;
    }

    @Deprecated
    public boolean removeAllAmounts(boolean testOnly, iElementalDefinition ... definitions) {
        iHasElementalDefinition[] stacks = new cElementalDefinitionStack[definitions.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = new cElementalDefinitionStack(definitions[i], 1L);
        }
        return this.removeAllAmounts(testOnly, stacks);
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalStackMap container) {
        boolean test = true;
        for (Map.Entry<iElementalDefinition, cElementalDefinitionStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(true, entry.getValue());
        }
        if (testOnly || !test) {
            return test;
        }
        for (Map.Entry<iElementalDefinition, cElementalDefinitionStack> entry : container.map.entrySet()) {
            this.removeAmount(false, entry.getValue());
        }
        return true;
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalInstanceStackMap container) {
        boolean test = true;
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(true, entry.getValue());
        }
        if (testOnly || !test) {
            return test;
        }
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(false, entry.getValue());
        }
        return true;
    }

    public cElementalDefinitionStack putReplace(cElementalDefinitionStack defStackUnsafe) {
        return this.map.put(defStackUnsafe.definition, defStackUnsafe);
    }

    public void putReplaceAll(cElementalDefinitionStack ... defStacks) {
        for (cElementalDefinitionStack defStack : defStacks) {
            this.map.put(defStack.definition, defStack);
        }
    }

    public void putReplaceAll(cElementalStackMap inContainerUnsafe) {
        this.map.putAll(inContainerUnsafe.map);
    }

    public cElementalDefinitionStack putUnify(cElementalDefinitionStack def) {
        cElementalDefinitionStack stack = (cElementalDefinitionStack)this.map.get(def.definition);
        if (stack == null) {
            return this.map.put(def.definition, def);
        }
        return this.map.put(def.definition, stack.addAmountIntoNewInstance(def.amount));
    }

    @Deprecated
    public cElementalDefinitionStack putUnify(iElementalDefinition def) {
        return this.putUnify(new cElementalDefinitionStack(def, 1L));
    }

    public void putUnifyAll(cElementalDefinitionStack ... defs) {
        for (cElementalDefinitionStack def : defs) {
            this.putUnify(def);
        }
    }

    @Deprecated
    public void putUnifyAll(iElementalDefinition ... defs) {
        for (iElementalDefinition def : defs) {
            this.putUnify(def);
        }
    }

    private void putUnifyAll(Map<iElementalDefinition, cElementalDefinitionStack> inTreeUnsafe) {
        for (cElementalDefinitionStack in : inTreeUnsafe.values()) {
            this.putUnify(in);
        }
    }

    public void putUnifyAll(cElementalStackMap containerUnsafe) {
        for (cElementalDefinitionStack in : containerUnsafe.map.values()) {
            this.putUnify(in);
        }
    }

    public static cElementalMutableDefinitionStackMap fromNBT(NBTTagCompound nbt) throws tElementalException {
        cElementalDefinitionStack[] defStacks = new cElementalDefinitionStack[nbt.func_74762_e("i")];
        for (int i = 0; i < defStacks.length; ++i) {
            defStacks[i] = cElementalDefinitionStack.fromNBT(nbt.func_74775_l(Integer.toString(i)));
            if (!defStacks[i].definition.equals(cPrimitiveDefinition.nbtE__)) continue;
            throw new tElementalException("Something went Wrong");
        }
        return new cElementalMutableDefinitionStackMap(defStacks);
    }

    public void cleanUp() {
        for (Map.Entry entry : this.map.entrySet()) {
            if (((cElementalDefinitionStack)entry.getValue()).amount > 0L) continue;
            this.map.remove(entry.getKey());
        }
    }
}

