/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class GT_MetaTileEntity_OwnerDetector
extends GT_MetaTileEntity_TieredMachineBlock {
    private static GT_RenderedTexture OWNER_ONLINE;
    private static GT_RenderedTexture OWNER_OFFLINE;
    private String uuid;
    private boolean interdimensional = true;

    public GT_MetaTileEntity_OwnerDetector(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Screwdrive to change mode", new ITexture[0]);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_OwnerDetector(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OwnerDetector(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        OWNER_ONLINE = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OWNER_ONLINE"));
        OWNER_OFFLINE = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/OWNER_OFFLINE"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aActive ? OWNER_ONLINE : OWNER_OFFLINE};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("eUUID", this.uuid);
        aNBT.func_74757_a("eInterDim", this.interdimensional);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.uuid = aNBT.func_74779_i("eUUID");
        this.interdimensional = aNBT.func_74767_n("eInterDim");
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        String name;
        if (aBaseMetaTileEntity.isServerSide() && (this.uuid == null || this.uuid.length() == 0) && !"Player".equals(name = aBaseMetaTileEntity.getOwnerName())) {
            this.uuid = TecTech.proxy.getUUID(name);
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 6L) {
            boolean detected = TecTech.proxy.isOnlineUUID(this.uuid) || this.uuid != null && this.uuid.length() > 0 && TecTech.proxy.isOnlineName(aBaseMetaTileEntity.getOwnerName());
            aBaseMetaTileEntity.setActive(detected);
            aBaseMetaTileEntity.setGenericRedstoneOutput(detected);
            byte value = (byte)(detected ? 15 : 0);
            for (byte b = 0; b < 6; b = (byte)(b + 1)) {
                aBaseMetaTileEntity.setStrongOutputRedstoneSignal(b, value);
            }
        }
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.interdimensional ^= true;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.interdimensional ? "Running interdimensional scan" : "Running local dimension scan"));
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, this.mDescription, EnumChatFormatting.BLUE + "Looks for his pa", EnumChatFormatting.BLUE + "Emits signal when happy"};
    }

    public boolean isElectric() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }

    public long maxEUInput() {
        return Integer.MAX_VALUE;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public int getProgresstime() {
        return this.interdimensional ? 1 : 0;
    }

    public int maxProgresstime() {
        return 1;
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return true;
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }
}

