/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.em_machine;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.thing.block.QuantumGlassBlock;
import com.github.technus.tectech.thing.block.QuantumStuffBlock;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.MultiblockControl;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_EM_machine
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    public static final String machine = "EM Machinery";
    private Behaviour currentBehaviour;
    private static final String[][] shape = new String[][]{{"B0", "A   ", "0 - 0", "A   ", "B0"}, {"A000", "00000", "00.00", "00000", "A000"}, {"A121", "1---1", "2---2", "1---1", "A121"}, {"A131", "1---1", "3-A-3", "1---1", "A131"}, {"A121", "1---1", "2---2", "1---1", "A121"}, {"A000", "00000", "00-00", "00000", "A000"}, {"B0", "A!!!", "0!!!0", "A!!!", "B0"}};
    private static final Block[] blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, QuantumGlassBlock.INSTANCE, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
    private static final byte[] blockMeta = new byte[]{4, 0, 5, 6};
    private static final String[] addingMethods = new String[]{"addClassicToMachineList", "addElementalToMachineList"};
    private static final short[] casingTextures = new short[]{1024, 1028};
    private static final Block[] blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
    private static final byte[] blockMetaFallback = new byte[]{0, 4};
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + "Hint Details:", "1 - Classic Hatches or High Power Casing", "2 - Elemental Hatches or Molecular Casing"};
    private static final HashMap<Util.TT_ItemStack, Behaviour> map = new HashMap();

    public GT_MetaTileEntity_EM_machine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_machine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_machine(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM(shape, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 2, 2, 1);
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        Util.StructureBuilderExtreme(shape, blockType, blockMeta, 2, 2, 1, this.getBaseMetaTileEntity(), this, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, "Processing quantum matter since...", EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + "the time u started using it."};
    }

    @Override
    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.quantumStuff(aBaseMetaTileEntity.isActive());
        }
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide() && (aTick & 2L) == 0L) {
            this.currentBehaviour = map.get(new Util.TT_ItemStack(this.mInventory[1]));
            if (aBaseMetaTileEntity.isActive()) {
                int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2 + aBaseMetaTileEntity.getXCoord();
                int yDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetY * 2 + aBaseMetaTileEntity.getYCoord();
                int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2 + aBaseMetaTileEntity.getZCoord();
                aBaseMetaTileEntity.getWorld().func_147458_c(xDir, yDir, zDir, xDir, yDir, zDir);
            }
        }
    }

    private boolean setCurrentBehaviour(Behaviour newBehaviour) {
        boolean changed;
        boolean bl = changed = this.currentBehaviour != newBehaviour;
        if (changed) {
            this.setDefaultParametersAndStatuses();
        }
        this.currentBehaviour = newBehaviour;
        return changed;
    }

    private void setDefaultParametersAndStatuses() {
        int i;
        for (i = 0; i <= 3; ++i) {
            this.setStatusOfParameterIn(i, 0, (byte)0);
            this.setStatusOfParameterIn(i, 1, (byte)0);
        }
        for (i = 0; i <= 9; ++i) {
            this.setStatusOfParameterOut(i, 0, (byte)0);
            this.setStatusOfParameterOut(i, 1, (byte)0);
            this.setParameterOut(i, 0, 0.0);
            this.setParameterOut(i, 1, 0.0);
        }
    }

    @Override
    public void onRemoval() {
        this.quantumStuff(false);
        super.onRemoval();
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        this.setCurrentBehaviour(map.get(new Util.TT_ItemStack(itemStack)));
        if (this.currentBehaviour == null) {
            return false;
        }
        double[] parameters = new double[]{this.getParameterIn(0, 0), this.getParameterIn(0, 1), this.getParameterIn(1, 0), this.getParameterIn(1, 1), this.getParameterIn(2, 0), this.getParameterIn(2, 1), this.getParameterIn(3, 0), this.getParameterIn(3, 1)};
        if (!this.currentBehaviour.setAndCheckParametersOutAndStatuses(this, parameters)) {
            return false;
        }
        cElementalInstanceStackMap[] handles = new cElementalInstanceStackMap[6];
        int pointer = this.getParameterInInt(4, 0) - 1;
        if (pointer >= 0 && pointer < this.eInputHatches.size()) {
            handles[0] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(4, 1) - 1) >= 0 && pointer < this.eInputHatches.size()) {
            handles[1] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(5, 0) - 1) >= 0 && pointer < this.eInputHatches.size()) {
            handles[2] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(5, 1) - 1) >= 0 && pointer < this.eInputHatches.size()) {
            handles[3] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(6, 0) - 1) >= 0 && pointer < this.eInputHatches.size()) {
            handles[4] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(6, 1) - 1) >= 0 && pointer < this.eInputHatches.size()) {
            handles[5] = ((GT_MetaTileEntity_Hatch_InputElemental)this.eInputHatches.get(pointer)).getContainerHandler();
        }
        for (int i = 1; i < 6; ++i) {
            if (handles[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (handles[i] != handles[j]) continue;
                return false;
            }
        }
        MultiblockControl<cElementalInstanceStackMap[]> control = this.currentBehaviour.process(handles, parameters);
        if (control == null) {
            return false;
        }
        this.cleanMassEM_EM(control.getExcessMass());
        if (control.shouldExplode()) {
            this.explodeMultiblock();
            return false;
        }
        this.outputEM = control.getValue();
        this.mEUt = control.getEUT();
        this.eAmpereFlow = control.getAmperage();
        this.mMaxProgresstime = control.getMaxProgressTime();
        this.eRequiredData = control.getRequiredData();
        this.mEfficiencyIncrease = control.getEffIncrease();
        boolean polluted = this.polluteEnvironment(control.getPollutionToAdd());
        this.quantumStuff(polluted);
        return polluted;
    }

    @Override
    protected void afterRecipeCheckFailed() {
        this.quantumStuff(false);
        super.afterRecipeCheckFailed();
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (this.setCurrentBehaviour(map.get(new Util.TT_ItemStack(this.mInventory[1])))) {
            return;
        }
        cElementalInstanceStackMap[] handles = new cElementalInstanceStackMap[6];
        int pointer = this.getParameterInInt(7, 0) - 1;
        if (pointer >= 0 && pointer < this.eOutputHatches.size()) {
            handles[0] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(7, 1) - 1) >= 0 && pointer < this.eOutputHatches.size()) {
            handles[1] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(8, 0) - 1) >= 0 && pointer < this.eOutputHatches.size()) {
            handles[2] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(8, 1) - 1) >= 0 && pointer < this.eOutputHatches.size()) {
            handles[3] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(9, 0) - 1) >= 0 && pointer < this.eOutputHatches.size()) {
            handles[4] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        if ((pointer = this.getParameterInInt(9, 1) - 1) >= 0 && pointer < this.eOutputHatches.size()) {
            handles[5] = ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(pointer)).getContainerHandler();
        }
        for (int i = 0; i < 6 && i < this.outputEM.length; ++i) {
            if (handles[i] == null || this.outputEM[i] == null || !this.outputEM[i].hasStacks()) continue;
            handles[i].putUnifyAll(this.outputEM[i]);
            this.outputEM[i] = null;
        }
        this.quantumStuff(false);
    }

    @Override
    public void stopMachine() {
        this.quantumStuff(false);
        super.stopMachine();
    }

    @Override
    protected void parametersLoadDefault_EM() {
        this.setParameterPairIn_ClearOut(4, false, 1.0, 2.0);
        this.setParameterPairIn_ClearOut(5, false, 3.0, 4.0);
        this.setParameterPairIn_ClearOut(6, false, 5.0, 6.0);
        this.setParameterPairIn_ClearOut(7, false, 1.0, 2.0);
        this.setParameterPairIn_ClearOut(8, false, 3.0, 4.0);
        this.setParameterPairIn_ClearOut(9, false, 5.0, 6.0);
    }

    @Override
    public void parametersOutAndStatusesWrite_EM(boolean machineBusy) {
        int pointer;
        BitSet checkArray = new BitSet();
        for (int i = 4; i <= 6; ++i) {
            pointer = this.getParameterInInt(i, 0);
            if (Double.isNaN(pointer)) {
                this.setStatusOfParameterIn(i, 0, (byte)3);
            } else if (pointer <= 0) {
                this.setStatusOfParameterIn(i, 0, (byte)1);
            } else if (pointer <= this.eInputHatches.size()) {
                if (checkArray.get(pointer)) {
                    this.setStatusOfParameterIn(i, 0, (byte)3);
                } else {
                    this.setStatusOfParameterIn(i, 0, (byte)4);
                    checkArray.set(pointer);
                }
            } else {
                this.setStatusOfParameterIn(i, 0, (byte)5);
            }
            pointer = this.getParameterInInt(i, 1);
            if (Double.isNaN(pointer)) {
                this.setStatusOfParameterIn(i, 1, (byte)3);
                continue;
            }
            if (pointer < 0) {
                this.setStatusOfParameterIn(i, 1, (byte)1);
                continue;
            }
            if (pointer == 0) {
                this.setStatusOfParameterIn(i, 1, (byte)2);
                continue;
            }
            if (pointer <= this.eInputHatches.size()) {
                if (checkArray.get(pointer)) {
                    this.setStatusOfParameterIn(i, 1, (byte)3);
                    continue;
                }
                this.setStatusOfParameterIn(i, 1, (byte)4);
                checkArray.set(pointer);
                continue;
            }
            this.setStatusOfParameterIn(i, 1, (byte)5);
        }
        for (int i = 7; i <= 9; ++i) {
            pointer = this.getParameterInInt(i, 0);
            if (Double.isNaN(pointer)) {
                this.setStatusOfParameterIn(i, 0, (byte)3);
            } else if (pointer < 0) {
                this.setStatusOfParameterIn(i, 0, (byte)1);
            } else if (pointer == 0) {
                this.setStatusOfParameterIn(i, 0, (byte)2);
            } else if (pointer <= this.eOutputHatches.size()) {
                this.setStatusOfParameterIn(i, 0, (byte)4);
            } else {
                this.setStatusOfParameterIn(i, 0, (byte)5);
            }
            pointer = this.getParameterInInt(i, 1);
            if (Double.isNaN(pointer)) {
                this.setStatusOfParameterIn(i, 1, (byte)3);
                continue;
            }
            if (pointer < 0) {
                this.setStatusOfParameterIn(i, 1, (byte)1);
                continue;
            }
            if (pointer == 0) {
                this.setStatusOfParameterIn(i, 1, (byte)2);
                continue;
            }
            if (pointer <= this.eOutputHatches.size()) {
                this.setStatusOfParameterIn(i, 1, (byte)4);
                continue;
            }
            this.setStatusOfParameterIn(i, 1, (byte)5);
        }
        this.setCurrentBehaviour(map.get(new Util.TT_ItemStack(this.mInventory[1])));
        if (this.currentBehaviour == null) {
            this.setDefaultParametersAndStatuses();
        } else {
            double[] parameters = new double[]{this.getParameterIn(0, 0), this.getParameterIn(0, 1), this.getParameterIn(1, 0), this.getParameterIn(1, 1), this.getParameterIn(2, 0), this.getParameterIn(2, 1), this.getParameterIn(3, 0), this.getParameterIn(3, 1)};
            this.currentBehaviour.setAndCheckParametersOutAndStatuses(this, parameters);
        }
    }

    public static void registerBehaviour(Behaviour behaviour, ItemStack is) {
        map.put(new Util.TT_ItemStack(is), behaviour);
        TecTech.LOGGER.info((Object)("Registered EM machine behaviour " + behaviour.getClass().getSimpleName() + ' ' + new Util.TT_ItemStack(is).toString()));
    }

    @Override
    public ArrayList<String> getFullLedDescriptionIn(int hatchNo, int paramID) {
        ArrayList<String> base = super.getFullLedDescriptionIn(hatchNo, paramID);
        if (hatchNo >= 7) {
            base.add("Output mux " + ((hatchNo - 7) * 2 + paramID + 1));
        } else if (hatchNo >= 4) {
            base.add("Input mux " + ((hatchNo - 4) * 2 + paramID + 1));
        } else if (this.currentBehaviour != null) {
            this.currentBehaviour.getFullLedDescriptionIn(base, hatchNo, paramID);
        }
        return base;
    }

    @Override
    public ArrayList<String> getFullLedDescriptionOut(int hatchNo, int paramID) {
        ArrayList<String> base = super.getFullLedDescriptionOut(hatchNo, paramID);
        if (this.currentBehaviour != null) {
            this.currentBehaviour.getFullLedDescriptionOut(base, hatchNo, paramID);
        }
        return base;
    }

    private void quantumStuff(boolean shouldExist) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (base != null && base.getWorld() != null) {
            int xDir = ForgeDirection.getOrientation((int)base.getBackFacing()).offsetX * 2 + base.getXCoord();
            int yDir = ForgeDirection.getOrientation((int)base.getBackFacing()).offsetY * 2 + base.getYCoord();
            int zDir = ForgeDirection.getOrientation((int)base.getBackFacing()).offsetZ * 2 + base.getZCoord();
            Block block = base.getWorld().func_147439_a(xDir, yDir, zDir);
            if (shouldExist) {
                if (block != null && block.func_149688_o() == Material.field_151579_a) {
                    base.getWorld().func_147465_d(xDir, yDir, zDir, (Block)QuantumStuffBlock.INSTANCE, 0, 2);
                }
            } else if (block instanceof QuantumStuffBlock) {
                base.getWorld().func_147465_d(xDir, yDir, zDir, Blocks.field_150350_a, 0, 2);
            }
        }
    }

    public static abstract class Behaviour {
        public abstract boolean setAndCheckParametersOutAndStatuses(GT_MetaTileEntity_EM_machine var1, double[] var2);

        public abstract MultiblockControl<cElementalInstanceStackMap[]> process(cElementalInstanceStackMap[] var1, double[] var2);

        protected void getFullLedDescriptionIn(ArrayList<String> baseDescr, int hatchNo, int paramID) {
        }

        protected void getFullLedDescriptionOut(ArrayList<String> baseDescr, int hatchNo, int paramID) {
        }
    }
}

