/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.dComplexAspectDefinition;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.ePrimalAspectDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalMutableDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalPrimitive;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.atom.dAtomDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.hadron.dHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eQuarkDefinition;
import com.github.technus.tectech.thing.block.QuantumGlassBlock;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_EM_collider
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static Textures.BlockIcons.CustomIcon ScreenON_Slave;
    private static Textures.BlockIcons.CustomIcon ScreenOFF_Slave;
    private static double MASS_TO_EU_PARTIAL;
    private static double MASS_TO_EU_INSTANT;
    private static int STARTUP_COST;
    private static int KEEPUP_COST;
    private long plasmaEnergy;
    public static final HashMap<Integer, ColliderHandler> FUSE_HANDLERS;
    public static final HashMap<String, PrimitiveColliderHandler> PRIMITIVE_FUSE_HANDLERS;
    protected byte eTier = 0;
    protected cElementalInstanceStack stack;
    protected static final byte FUSE_MODE = 0;
    protected static final byte COLLIDE_MODE = 1;
    protected boolean started = false;
    private static final String[][] shape;
    private static final Block[] blockType;
    private static final byte[] blockMeta1;
    private static final byte[] blockMeta2;
    private static final String[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;

    public static void setValues(int heliumPlasmaValue) {
        MASS_TO_EU_PARTIAL = (double)heliumPlasmaValue / 1.75893000478707E7;
        MASS_TO_EU_INSTANT = MASS_TO_EU_PARTIAL * 20.0;
        STARTUP_COST = -heliumPlasmaValue * 10000;
        KEEPUP_COST = -heliumPlasmaValue;
    }

    private static boolean fuseAspects(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
        try {
            cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
            defs.putUnify(in1.definition.getStackForm(1L));
            defs.putUnify(in2.definition.getStackForm(1L));
            dComplexAspectDefinition aspect = new dComplexAspectDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
            out.putUnify(new cElementalInstanceStack(aspect, Math.min(in1.amount, in2.amount)));
        }
        catch (Exception e) {
            out.putUnifyAll(in1, in2);
            return true;
        }
        return false;
    }

    private static void registerSimpleAspectFuse(byte classTypeStatic) {
        FUSE_HANDLERS.put(dComplexAspectDefinition.getClassTypeStatic() << 16 | classTypeStatic, new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    private static void registerSimpleAtomFuse(byte classTypeStatic) {
        FUSE_HANDLERS.put(dAtomDefinition.getClassTypeStatic() << 16 | classTypeStatic, new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnify(in2.definition.getStackForm(1L));
                    dAtomDefinition atom = new dAtomDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(atom, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    public GT_MetaTileEntity_EM_collider(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_collider(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_collider(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE");
        ScreenOFF_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_SLAVE");
        ScreenON_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE_SLAVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aFacing % 2 == 0) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedTexture((IIconContainer)(aActive ? ScreenON_Slave : ScreenOFF_Slave))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4]};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("eTier", this.eTier);
        aNBT.func_74757_a("eStarted", this.started);
        if (this.stack != null) {
            aNBT.func_74782_a("eStack", (NBTBase)this.stack.toNBT());
        }
        aNBT.func_74772_a("ePlasmaEnergy", this.plasmaEnergy);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.eTier = aNBT.func_74771_c("eTier");
        this.started = aNBT.func_74767_n("eStarted");
        if (aNBT.func_74764_b("eStack")) {
            this.stack = cElementalInstanceStack.fromNBT(aNBT.func_74775_l("eStack"));
        }
        this.plasmaEnergy = aNBT.func_74763_f("ePlasmaEnergy");
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        boolean test;
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 2;
        if (iGregTechTileEntity.getBlockOffset(xDir, 0, zDir) != TT_Container_Casings.sBlockCasingsTT) {
            this.eTier = 0;
            return false;
        }
        if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 8) {
            this.eTier = 1;
        } else if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 9) {
            this.eTier = (byte)2;
        } else {
            this.eTier = 0;
            return false;
        }
        switch (this.eTier) {
            case 1: {
                test = this.structureCheck_EM(shape, blockType, blockMeta1, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 11, 1, 18);
                break;
            }
            case 2: {
                test = this.structureCheck_EM(shape, blockType, blockMeta2, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 11, 1, 18);
                break;
            }
            default: {
                this.eTier = 0;
                return false;
            }
        }
        if (test) {
            return true;
        }
        this.eTier = 0;
        return false;
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 4;
        int yDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetY * 4;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 4;
        if (hintsOnly) {
            TecTech.proxy.hint_particle(iGregTechTileEntity.getWorld(), iGregTechTileEntity.getXCoord() + xDir, iGregTechTileEntity.getYCoord() + yDir, iGregTechTileEntity.getZCoord() + zDir, TT_Container_Casings.sHintCasingsTT, 12);
        } else if (iGregTechTileEntity.getBlockOffset(xDir, 0, zDir).func_149688_o() == Material.field_151579_a) {
            iGregTechTileEntity.getWorld().func_147465_d(iGregTechTileEntity.getXCoord() + xDir, iGregTechTileEntity.getYCoord() + yDir, iGregTechTileEntity.getZCoord() + zDir, TT_Container_Casings.sHintCasingsTT, 12, 2);
        }
        if ((stackSize & 1) == 1) {
            Util.StructureBuilderExtreme(shape, blockType, blockMeta1, 11, 1, 18, iGregTechTileEntity, this, hintsOnly);
        } else {
            Util.StructureBuilderExtreme(shape, blockType, blockMeta2, 11, 1, 18, iGregTechTileEntity, this, hintsOnly);
        }
    }

    @Override
    public void parametersOutAndStatusesWrite_EM(boolean machineBusy) {
        if (this.isMaster()) {
            double mode = this.getParameterIn(0, 0);
            if (mode == 0.0 || mode == 1.0) {
                this.setStatusOfParameterIn(0, 0, (byte)4);
            } else if (mode > 1.0) {
                this.setStatusOfParameterIn(0, 0, (byte)5);
            } else if (mode < 0.0) {
                this.setStatusOfParameterIn(0, 0, (byte)1);
            } else {
                this.setStatusOfParameterIn(0, 0, (byte)3);
            }
        }
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            return false;
        }
        this.mEfficiencyIncrease = 10000;
        if (this.started) {
            if (this.stack == null) {
                for (GT_MetaTileEntity_Hatch_InputElemental inputElemental : this.eInputHatches) {
                    cElementalInstanceStackMap container = inputElemental.getContainerHandler();
                    if (container.isEmpty()) continue;
                    this.stack = container.remove(container.getFirst().definition);
                    long eut = (long)KEEPUP_COST + (long)((float)KEEPUP_COST * Math.abs(this.stack.getMass() / dAtomDefinition.getSomethingHeavy().getMass())) / 2L;
                    if (eut < -2147483641L) {
                        return false;
                    }
                    this.mMaxProgresstime = 20;
                    this.mEUt = (int)eut;
                    this.eAmpereFlow = 5L;
                    return true;
                }
                this.mMaxProgresstime = 20;
                this.mEUt = KEEPUP_COST;
                this.eAmpereFlow = 1L;
                return true;
            }
            this.mMaxProgresstime = 20;
            this.mEUt = KEEPUP_COST;
            this.eAmpereFlow = 2L;
            return true;
        }
        this.started = true;
        this.mMaxProgresstime = 20;
        this.mEUt = STARTUP_COST;
        this.eAmpereFlow = 10L;
        return true;
    }

    protected double fuse(GT_MetaTileEntity_EM_collider partner) {
        if (partner.stack != null && this.stack != null) {
            ColliderHandler colliderHandler;
            boolean check = this.stack.definition.fusionMakesEnergy(this.stack.getEnergy()) && partner.stack.definition.fusionMakesEnergy(partner.stack.getEnergy());
            cElementalInstanceStack stack2 = partner.stack;
            double preMass = stack2.getMass() + this.stack.getMass();
            cElementalInstanceStackMap map = new cElementalInstanceStackMap();
            if (stack2.definition.getClassType() > this.stack.definition.getClassType() ? this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(stack2.definition.getClassType() << 16 | this.stack.definition.getClassType())) : this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(this.stack.definition.getClassType() << 16 | stack2.definition.getClassType()))) {
                return 0.0;
            }
            for (cElementalInstanceStack newStack : map.values()) {
                check &= newStack.definition.fusionMakesEnergy(newStack.getEnergy());
            }
            this.outputEM = new cElementalInstanceStackMap[]{map};
            this.stack = null;
            partner.stack = null;
            return check ? preMass - (double)map.getMass() : Math.min(preMass - (double)map.getMass(), 0.0);
        }
        return 0.0;
    }

    private boolean handleRecipe(cElementalInstanceStack stack2, cElementalInstanceStackMap map, ColliderHandler colliderHandler) {
        if (colliderHandler == null || this.eTier < colliderHandler.getRequiredTier()) {
            map.putUnifyAll(this.stack, stack2);
            this.outputEM = new cElementalInstanceStackMap[]{map};
            return true;
        }
        colliderHandler.collide(stack2, this.stack, map);
        return false;
    }

    @Override
    protected void afterRecipeCheckFailed() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        this.getBaseMetaTileEntity().disableWorking();
        super.afterRecipeCheckFailed();
    }

    @Override
    public void stopMachine() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        super.stopMachine();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            this.started = false;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    protected GT_MetaTileEntity_EM_collider getPartner() {
        int zDir;
        int yDir;
        int xDir;
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        IGregTechTileEntity gregTechBaseTileEntity = iGregTechTileEntity.getIGregTechTileEntityOffset(xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 4, yDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetY * 4, zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 4);
        if (gregTechBaseTileEntity != null) {
            IMetaTileEntity gregTechMetaTileEntity = gregTechBaseTileEntity.getMetaTileEntity();
            return gregTechMetaTileEntity instanceof GT_MetaTileEntity_EM_collider && ((GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity).mMachine && gregTechBaseTileEntity.getBackFacing() == iGregTechTileEntity.getFrontFacing() ? (GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity : null;
        }
        return null;
    }

    protected final boolean isMaster() {
        return this.getBaseMetaTileEntity().getFrontFacing() % 2 == 0;
    }

    @Override
    public void outputAfterRecipe_EM() {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            if (this.stack != null) {
                this.cleanMassEM_EM(this.stack.getMass());
                this.stack = null;
            }
            return;
        }
        if (this.isMaster()) {
            switch (this.getParameterInInt(0, 0)) {
                case 0: {
                    this.makeEU(this.fuse(partner));
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.outputEM = new cElementalInstanceStackMap[2];
                    this.outputEM[1] = this.tickStack();
                    if (this.outputEM[1] == null) {
                        this.outputEM[1] = partner.tickStack();
                        break;
                    }
                    cElementalInstanceStackMap map = partner.tickStack();
                    if (map == null) break;
                    this.outputEM[1].putUnifyAll(map);
                }
            }
            if (this.outputEM != null) {
                int lim = Math.min(this.outputEM.length, this.eOutputHatches.size());
                for (int i = 0; i < lim; ++i) {
                    if (this.outputEM[i] == null) continue;
                    ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(i)).getContainerHandler().putUnifyAll(this.outputEM[i]);
                    this.outputEM[i] = null;
                }
            }
        }
    }

    private void makeEU(double massDiff) {
        this.plasmaEnergy = (long)((double)this.plasmaEnergy + massDiff * MASS_TO_EU_INSTANT);
        System.out.println("plasmaEnergy = " + this.plasmaEnergy);
    }

    private cElementalInstanceStackMap tickStack() {
        cElementalInstanceStackMap newInstances;
        if (this.stack == null) {
            return null;
        }
        if ((newInstances = this.stack.decay(1.0f, ++this.stack.age, 0L)) == null) {
            this.stack.nextColor();
        } else {
            this.stack = newInstances.remove(newInstances.getLast().definition);
        }
        return newInstances;
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, "Collide matter at extreme velocities.", EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + "Faster than light*!!!"};
    }

    static {
        FUSE_HANDLERS = new HashMap();
        PRIMITIVE_FUSE_HANDLERS = new HashMap();
        FUSE_HANDLERS.put(dAtomDefinition.getClassTypeStatic() << 16 | dAtomDefinition.getClassTypeStatic(), new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnifyAll(in2.definition.getSubParticles());
                    dAtomDefinition atom = new dAtomDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(atom, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(dHadronDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(dComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(cElementalPrimitive.getClassTypeStatic());
        FUSE_HANDLERS.put(dHadronDefinition.getClassTypeStatic() << 16 | dHadronDefinition.getClassTypeStatic(), new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnifyAll(in2.definition.getSubParticles());
                    dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        FUSE_HANDLERS.put(dHadronDefinition.getClassTypeStatic() << 16 | cElementalPrimitive.getClassTypeStatic(), new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnify(in2.definition.getStackForm(1L));
                    dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(dComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(cElementalPrimitive.getClassTypeStatic());
        FUSE_HANDLERS.put(cElementalPrimitive.getClassTypeStatic() << 16 | cElementalPrimitive.getClassTypeStatic(), new ColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                PrimitiveColliderHandler collisionHandler = PRIMITIVE_FUSE_HANDLERS.get(in1.definition.getClass().getName() + '\u0000' + in2.definition.getClass().getName());
                if (collisionHandler != null) {
                    collisionHandler.collide(in2, in1, out);
                } else {
                    out.putUnifyAll(in1, in2);
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(eQuarkDefinition.class.getName() + '\u0000' + eQuarkDefinition.class.getName(), new PrimitiveColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnify(in1.definition.getStackForm(1L));
                    defs.putUnify(in2.definition.getStackForm(1L));
                    dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(ePrimalAspectDefinition.class.getName() + '\u0000' + ePrimalAspectDefinition.class.getName(), new PrimitiveColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }
        });
        shape = new String[][]{{"I0A0A0", "I00000", "I0A0A0"}, {"H0000000", "G001111100", "H0000000"}, {"F22223332222", "F41155555114", "F22223332222"}, {"E2000000000002", "E4155111115514", "E2000000000002"}, {"D20000E00002", "D41511E11514", "D20000E00002"}, {"C2000I0002", "C4151I1514", "C2000I0002"}, {"B2000K0002", "B4151K1514", "B2000K0002"}, {"B200M002", "A0151M1510", "B200M002"}, {"A0200M0020", "A0151M1510", "A0200M0020"}, {"0020O0200", "0151O1510", "0020O0200"}, {"A030O030", "0151O1510", "A030O030"}, {"0030O0300", "0151O1510", "0030O0300"}, {"A030O030", "0151O1510", "A030O030"}, {"0020O0200", "0151O1510", "0020O0200"}, {"A0200M0020", "A0151M1510", "A0200M0020"}, {"B200M002", "A0151M1510", "B200M002"}, {"B2000K0002", "B4151K1514", "B2000K0002"}, {"C2000I0002", "C4151I1514", "C2000I0002"}, {"D200002   200002", "D415112 . 211514", "D200002   200002"}, {"E20!!22222!!02", "E4155111115514", "E20!!22222!!02"}, {"F2222#\"#2222", "F41155555114", "F2222#\"#2222"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, QuantumGlassBlock.INSTANCE, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta1 = new byte[]{4, 7, 4, 0, 4, 8};
        blockMeta2 = new byte[]{4, 7, 5, 0, 6, 9};
        addingMethods = new String[]{"addClassicToMachineList", "addElementalInputToMachineList", "addElementalOutputToMachineList", "addElementalMufflerToMachineList"};
        casingTextures = new short[]{1024, 1028, 1028, 1028};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMetaFallback = new byte[]{0, 4, 4, 4};
        description = new String[]{EnumChatFormatting.AQUA + "Hint Details:", "1 - Classic Hatches or High Power Casing", "2 - Elemental Input Hatches or Molecular Casing", "3 - Elemental Output Hatches or Molecular Casing", "4 - Elemental Overflow Hatches or Molecular Casing", "General - Another Controller facing opposite direction"};
    }

    public static interface ColliderHandler
    extends PrimitiveColliderHandler {
        public byte getRequiredTier();
    }

    public static interface PrimitiveColliderHandler {
        public void collide(cElementalInstanceStack var1, cElementalInstanceStack var2, cElementalInstanceStackMap var3);
    }
}

