/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eBosonDefinition;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class cElementalInstanceStack
implements iHasElementalDefinition {
    public static int MIN_MULTIPLE_DECAY_CALLS = 4;
    public static int MAX_MULTIPLE_DECAY_CALLS = 16;
    public static int DECAY_CALL_PER = 144;
    public final iElementalDefinition definition;
    private long energy;
    private byte color;
    public long age;
    public long amount;
    private float lifeTime;
    private float lifeTimeMult;

    public cElementalInstanceStack(cElementalDefinitionStack stackSafe) {
        this(stackSafe.definition, stackSafe.amount, 1.0f, 0L, 0L);
    }

    public cElementalInstanceStack(cElementalDefinitionStack stackSafe, float lifeTimeMult, long age, long energy) {
        this(stackSafe.definition, stackSafe.amount, lifeTimeMult, age, energy);
    }

    public cElementalInstanceStack(iElementalDefinition defSafe, long amount) {
        this(defSafe, amount, 1.0f, 0L, 0L);
    }

    public cElementalInstanceStack(iElementalDefinition defSafe, long amount, float lifeTimeMult, long age, long energy) {
        this.definition = defSafe == null ? cPrimitiveDefinition.null__ : defSafe;
        byte bColor = this.definition.getColor();
        this.color = bColor < 0 || bColor > 2 ? bColor : (byte)TecTech.RANDOM.nextInt(3);
        this.lifeTimeMult = lifeTimeMult;
        this.lifeTime = this.definition.getRawTimeSpan(energy) * this.lifeTimeMult;
        this.setEnergy(energy);
        this.age = age;
        this.amount = amount;
    }

    private cElementalInstanceStack(cElementalInstanceStack stack) {
        this.definition = stack.definition;
        this.color = stack.color;
        this.age = stack.age;
        this.amount = stack.amount;
        this.lifeTime = stack.lifeTime;
        this.lifeTimeMult = stack.lifeTimeMult;
        this.energy = stack.energy;
    }

    @Override
    public cElementalInstanceStack clone() {
        return new cElementalInstanceStack(this);
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getCharge() {
        return (long)this.definition.getCharge() * this.amount;
    }

    @Override
    public float getMass() {
        return this.definition.getMass() * (float)this.amount;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(long newEnergyLevel) {
        this.energy = newEnergyLevel;
        this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
    }

    public float getEnergySettingCost(long currentEnergyLevel, long newEnergyLevel) {
        return this.definition.getEnergyDiffBetweenStates(currentEnergyLevel, newEnergyLevel) * (float)this.amount;
    }

    public float getEnergySettingCost(long newEnergyLevel) {
        return this.definition.getEnergyDiffBetweenStates(this.energy, newEnergyLevel) * (float)this.amount;
    }

    public cElementalDefinitionStack getDefinitionStack() {
        return new cElementalDefinitionStack(this.definition, this.amount);
    }

    @Override
    public iElementalDefinition getDefinition() {
        return this.definition;
    }

    public byte getColor() {
        return this.color;
    }

    public byte setColor(byte color) {
        if (this.color < 0 || this.color > 2 || color < 0 || color >= 3) {
            return this.color;
        }
        this.color = color;
        return this.color;
    }

    public byte nextColor() {
        if (this.color < 0 || this.color > 2) {
            return this.color;
        }
        this.color = (byte)TecTech.RANDOM.nextInt(3);
        return this.color;
    }

    public float getLifeTime() {
        return this.lifeTime;
    }

    public float setLifeTimeMultiplier(float mult) {
        if (mult <= 0.0f) {
            throw new IllegalArgumentException("multiplier must be >0");
        }
        this.lifeTimeMult = mult;
        if (this.definition.getRawTimeSpan(this.energy) <= 0.0f) {
            return this.lifeTime;
        }
        this.lifeTime = this.definition.getRawTimeSpan(this.energy) * this.lifeTimeMult;
        return this.lifeTime;
    }

    public float getLifeTimeMultiplier() {
        return this.lifeTimeMult;
    }

    public cElementalInstanceStackMap tickStackByOneSecond(float lifeTimeMult, int postEnergize) {
        return this.tickStack(lifeTimeMult, postEnergize, 1);
    }

    public cElementalInstanceStackMap tickStack(float lifeTimeMult, int postEnergize, int seconds) {
        cElementalInstanceStackMap newInstances = this.decay(lifeTimeMult, this.age += (long)seconds, postEnergize);
        if (newInstances == null) {
            this.nextColor();
        } else {
            for (cElementalInstanceStack newInstance : newInstances.values()) {
                newInstance.nextColor();
            }
        }
        return newInstances;
    }

    public cElementalInstanceStackMap decay() {
        return this.decay(1.0f, this.age, 0L);
    }

    public cElementalInstanceStackMap decay(long apparentAge, long postEnergize) {
        return this.decay(1.0f, apparentAge, postEnergize);
    }

    public cElementalInstanceStackMap decay(float lifeTimeMult, long apparentAge, long postEnergize) {
        long newEnergyLevel = postEnergize + this.energy;
        if (newEnergyLevel > 0L) {
            --newEnergyLevel;
        } else if (newEnergyLevel < 0L) {
            ++newEnergyLevel;
        }
        if (this.definition.usesMultipleDecayCalls(this.energy)) {
            long amountTemp = this.amount;
            long decayCnt = Math.min(Math.max(this.amount / (long)DECAY_CALL_PER, (long)MIN_MULTIPLE_DECAY_CALLS), (long)MAX_MULTIPLE_DECAY_CALLS);
            long amountPer = this.amount / decayCnt;
            this.amount -= amountPer * --decayCnt;
            cElementalInstanceStackMap output = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
            if (output == null) {
                this.amount = amountTemp;
                return null;
            }
            if (amountPer > 0L) {
                this.amount = amountPer;
                int i = 0;
                while ((long)i < decayCnt) {
                    cElementalInstanceStackMap map = this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
                    if (map != null) {
                        output.putUnifyAll(map);
                    }
                    ++i;
                }
            }
            this.amount = amountTemp;
            return output;
        }
        return this.decayMechanics(lifeTimeMult, apparentAge, newEnergyLevel);
    }

    private cElementalInstanceStackMap decayMechanics(float lifeTimeMult, long apparentAge, long newEnergyLevel) {
        if (this.energy > 0L && !this.definition.usesSpecialEnergeticDecayHandling()) {
            this.setLifeTimeMultiplier(this.getLifeTimeMultiplier());
            return this.decayCompute(this.definition.getEnergyInducedDecay(this.energy), lifeTimeMult, -1L, newEnergyLevel);
        }
        if (this.definition.getRawTimeSpan(this.energy) < 0.0f) {
            return null;
        }
        if (this.definition.isTimeSpanHalfLife()) {
            return this.exponentialDecayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getDecayArray(), lifeTimeMult, -1L, newEnergyLevel);
        }
        if (1.0f > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getNaturalDecayInstant(), lifeTimeMult, 0L, newEnergyLevel);
        }
        if ((float)apparentAge > this.lifeTime) {
            return this.decayCompute(this.energy > 0L ? this.definition.getEnergyInducedDecay(this.energy) : this.definition.getDecayArray(), lifeTimeMult, 0L, newEnergyLevel);
        }
        return null;
    }

    private cElementalInstanceStackMap exponentialDecayCompute(cElementalDecay[] decays, float lifeTimeMult, long newProductsAge, long newEnergyLevel) {
        double decayInverseRatio = Math.pow(2.0, 1.0 / (double)this.lifeTime);
        double newAmount = (double)this.amount / decayInverseRatio;
        long amountRemaining = (long)Math.floor(newAmount) + (long)(TecTech.RANDOM.nextDouble() <= newAmount - Math.floor(newAmount) ? 1 : 0);
        if (amountRemaining == this.amount) {
            return null;
        }
        if (amountRemaining <= 0L) {
            return this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        }
        long amount = this.amount;
        this.amount -= amountRemaining;
        cElementalInstanceStackMap products = this.decayCompute(decays, lifeTimeMult, newProductsAge, newEnergyLevel);
        this.amount = amountRemaining;
        products.putUnify(this.clone());
        this.amount = amount;
        return products;
    }

    private cElementalInstanceStackMap decayCompute(cElementalDecay[] decays, float lifeTimeMult, long newProductsAge, long newEnergyLevel) {
        int i;
        if (decays == null) {
            return null;
        }
        if (decays.length == 0) {
            if (this.definition.decayMakesEnergy(this.energy)) {
                return null;
            }
            return new cElementalInstanceStackMap();
        }
        if (decays.length == 1) {
            if (decays[0] == eBosonDefinition.deadEnd && this.definition.decayMakesEnergy(this.energy)) {
                return null;
            }
            cElementalInstanceStackMap products = decays[0].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, this.amount);
            if (newProductsAge < 0L) {
                for (cElementalInstanceStack stack : products.values()) {
                    if (!stack.definition.equals(this.definition)) continue;
                    stack.age = this.age;
                    stack.setEnergy(this.energy);
                }
            } else {
                for (cElementalInstanceStack stack : products.values()) {
                    if (!stack.definition.equals(this.definition)) continue;
                    stack.setEnergy(this.energy);
                }
            }
            if (this.energy <= 0L && products.getMass() > this.getMass()) {
                return null;
            }
            return products;
        }
        cElementalInstanceStackMap output = new cElementalInstanceStackMap();
        int differentDecays = decays.length;
        long[] qttyOfDecay = new long[differentDecays];
        long amountRemaining = this.amount;
        long amount = this.amount;
        float remainingProbability = 1.0f;
        for (i = 0; i < differentDecays; ++i) {
            long thisDecayAmount;
            if (decays[i].probability >= 1.0f) {
                thisDecayAmount = (long)Math.floor((double)remainingProbability * (double)amount);
                if (thisDecayAmount <= 0L) break;
                if (thisDecayAmount <= amountRemaining) {
                    amountRemaining -= thisDecayAmount;
                    int n = i;
                    qttyOfDecay[n] = qttyOfDecay[n] + thisDecayAmount;
                    break;
                }
                int n = i;
                qttyOfDecay[n] = qttyOfDecay[n] + amountRemaining;
                amountRemaining = 0L;
                break;
            }
            thisDecayAmount = (long)Math.floor((double)decays[i].probability * (double)amount);
            if (thisDecayAmount <= amountRemaining && thisDecayAmount > 0L) {
                amountRemaining -= thisDecayAmount;
                int n = i;
                qttyOfDecay[n] = qttyOfDecay[n] + thisDecayAmount;
            } else if (thisDecayAmount > amountRemaining) {
                int n = i;
                qttyOfDecay[n] = qttyOfDecay[n] + amountRemaining;
                amountRemaining = 0L;
                break;
            }
            if ((remainingProbability -= decays[i].probability) <= 0.0f) break;
        }
        i = 0;
        while ((long)i < amountRemaining) {
            double rand = TecTech.RANDOM.nextDouble();
            for (int j = 0; j < differentDecays; ++j) {
                if (!((rand -= (double)decays[j].probability) <= 0.0)) continue;
                int n = j;
                qttyOfDecay[n] = qttyOfDecay[n] + 1L;
                break;
            }
            ++i;
        }
        if (this.definition.decayMakesEnergy(this.energy)) {
            for (i = 0; i < differentDecays; ++i) {
                if (qttyOfDecay[i] <= 0L) continue;
                if (decays[i] == eBosonDefinition.deadEnd) {
                    cElementalInstanceStack clone = this.clone();
                    clone.amount = qttyOfDecay[i];
                    output.putUnify(clone);
                    continue;
                }
                output.putUnifyAll(decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]));
            }
        } else {
            for (i = 0; i < differentDecays; ++i) {
                if (qttyOfDecay[i] <= 0L) continue;
                output.putUnifyAll(decays[i].getResults(lifeTimeMult, newProductsAge, newEnergyLevel, qttyOfDecay[i]));
            }
        }
        if (newProductsAge < 0L) {
            for (cElementalInstanceStack stack : output.values()) {
                if (!stack.definition.equals(this.definition)) continue;
                stack.age = this.age;
                stack.setEnergy(this.energy);
            }
        } else {
            for (cElementalInstanceStack stack : output.values()) {
                if (!stack.definition.equals(this.definition)) continue;
                stack.setEnergy(this.energy);
            }
        }
        if (this.energy <= 0L && output.getMass() > this.getMass()) {
            return null;
        }
        return output;
    }

    public cElementalInstanceStack unifyIntoThis(cElementalInstanceStack ... instances) {
        if (instances == null) {
            return this;
        }
        double energy = this.energy * this.amount;
        long maxEnergy = this.energy;
        float lifeTimeMul = this.lifeTimeMult;
        for (cElementalInstanceStack instance : instances) {
            if (instance == null || this.compareTo(instance) != 0) continue;
            this.amount += instance.amount;
            energy += (double)(instance.energy * instance.amount);
            if (instance.energy > maxEnergy) {
                maxEnergy = instance.energy;
            }
            lifeTimeMul = Math.min(lifeTimeMul, instance.lifeTimeMult);
            this.age = Math.max(this.age, instance.age);
        }
        if (this.amount != 0L) {
            energy /= (double)Math.abs(this.amount);
        }
        double wholeParts = Math.floor(energy);
        energy = Math.min(energy - wholeParts, 1.0) + (wholeParts >= 0.0 ? -0.11709966304863834 : 0.11709966304863834);
        this.setEnergy(Math.min(maxEnergy, (long)wholeParts + (long)(energy > TecTech.RANDOM.nextDouble() ? 1 : 0)));
        return this;
    }

    public void addScanResults(ArrayList<String> lines, int[] detailsOnDepthLevels) {
        int capabilities = detailsOnDepthLevels[0];
        if (Util.areBitsSet(2, capabilities)) {
            lines.add("DEPTH = 0");
        }
        this.definition.addScanResults(lines, capabilities, this.energy);
        if (Util.areBitsSet(1024, capabilities)) {
            lines.add("TIME SPAN MULTIPLIER = " + this.lifeTimeMult);
            if (Util.areBitsSet(64, capabilities)) {
                lines.add("TIME SPAN MULTIPLIED = " + this.lifeTime + " s");
            }
        }
        if (Util.areBitsSet(512, capabilities)) {
            lines.add("AGE = " + this.age + " s");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add("COLOR = " + this.color + " RGB or CMY");
        }
        if (Util.areBitsSet(32, capabilities)) {
            lines.add("E. LEVEL = " + this.energy);
        }
        if (Util.areBitsSet(4, capabilities)) {
            lines.add("AMOUNT = " + this.amount);
        }
        this.scanContents(lines, this.definition.getSubParticles(), 1, detailsOnDepthLevels);
    }

    private void scanContents(ArrayList<String> lines, cElementalDefinitionStackMap definitions, int depth, int[] detailsOnDepthLevels) {
        if (definitions != null && depth < detailsOnDepthLevels.length) {
            int deeper = depth + 1;
            for (cElementalDefinitionStack definitionStack : definitions.values()) {
                lines.add("");
                if (Util.areBitsSet(2, detailsOnDepthLevels[depth])) {
                    lines.add("DEPTH = " + depth);
                }
                this.definition.addScanResults(lines, detailsOnDepthLevels[depth], this.energy);
                if (Util.areBitsSet(4, detailsOnDepthLevels[depth])) {
                    lines.add("AMOUNT = " + definitionStack.amount);
                }
                this.scanContents(lines, definitionStack.definition.getSubParticles(), deeper, detailsOnDepthLevels);
            }
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("d", (NBTBase)this.definition.toNBT());
        nbt.func_74772_a("q", this.amount);
        nbt.func_74772_a("e", this.energy);
        nbt.func_74774_a("c", this.color);
        nbt.func_74772_a("a", this.age);
        nbt.func_74776_a("m", this.lifeTimeMult);
        return nbt;
    }

    public static cElementalInstanceStack fromNBT(NBTTagCompound nbt) {
        NBTTagCompound definition = nbt.func_74775_l("d");
        cElementalInstanceStack instance = new cElementalInstanceStack(cElementalDefinition.fromNBT(definition), nbt.func_74763_f("q"), nbt.func_74760_g("m"), nbt.func_74763_f("a"), nbt.func_74763_f("e"));
        instance.setColor(nbt.func_74771_c("c"));
        return instance;
    }

    @Override
    public int compareTo(iHasElementalDefinition o) {
        return this.definition.compareTo(o.getDefinition());
    }

    public boolean equals(Object obj) {
        if (obj instanceof iElementalDefinition) {
            return this.definition.compareTo((iElementalDefinition)obj) == 0;
        }
        if (obj instanceof iHasElementalDefinition) {
            return this.definition.compareTo(((iHasElementalDefinition)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public String toString() {
        return this.definition.getName() + '\n' + this.definition.getSymbol() + '\n' + this.amount + '\n' + this.getMass();
    }
}

