/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Materials;
import java.util.ArrayList;
import java.util.List;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.util.IToolPart;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.reference.PartTypes;
import vexatos.tgregworks.util.TGregUtils;

public class ItemTGregPart
extends CraftingItem
implements IToolPart {
    private PartTypes type;
    public static ArrayList<String> toolMaterialNames = TGregworks.registry.toolMaterialNames;

    public ItemTGregPart(PartTypes p) {
        super(toolMaterialNames.toArray(new String[toolMaterialNames.size()]), ItemTGregPart.buildTextureNames(p), "parts/", "tinker", (CreativeTabs)TGregworks.tab);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.type = p;
    }

    public PartTypes getType() {
        return this.type;
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        String matName = !data.func_74764_b("material") || Materials.get((String)data.func_74779_i("material")) == Materials._NULL ? StatCollector.func_74838_a((String)"tgregworks.materials.unknown") : Materials.get((String)data.func_74779_i((String)"material")).mLocalizedName;
        String name = StatCollector.func_74838_a((String)("tgregworks.toolpart." + this.type.getPartName().replace(" ", "_").toLowerCase()));
        matName = name.replaceAll("%%material", matName);
        if (stack.func_77960_j() == 0) {
            matName = matName + StatCollector.func_74838_a((String)"tgregworks.tool.deprecated");
        }
        return matName;
    }

    public String func_77667_c(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        String matName = !data.func_74764_b("material") || Materials.get((String)data.func_74779_i("material")) == Materials._NULL ? "Unknown" : Materials.get((String)data.func_74779_i((String)"material")).mDefaultLocalName;
        return matName;
    }

    public String func_77658_a() {
        return this.type.getPartName();
    }

    private static String[] buildTextureNames(PartTypes p) {
        String[] names = new String[]{p.getTextureName()};
        return names;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[1];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.textureNames[i].equals("")) continue;
            this.icons[i] = iconRegister.func_94245_a(this.modTexPrefix + ":" + this.folder + this.textureNames[i]);
        }
    }

    public void func_150895_a(Item b, CreativeTabs tab, List list) {
        for (Materials m : TGregworks.registry.toolMaterials) {
            ItemStack stack = new ItemStack(b, 1, TGregworks.registry.matIDs.get(m).intValue());
            NBTTagCompound data = TGregUtils.getTagCompound(stack);
            data.func_74778_a("material", m.name());
            stack.func_77982_d(data);
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.func_74764_b("material")) {
            return super.func_82790_a(stack, pass);
        }
        int[] rgba = this.toIntArray(ItemTGregPart.getRGBa(stack));
        int colour = rgba[0] << 16 | rgba[1] << 8 | rgba[2];
        return colour;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        Integer matID;
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.func_74764_b("material")) {
            return;
        }
        Materials m = Materials.get((String)data.func_74779_i("material"));
        if (m != null && (matID = TGregworks.registry.matIDs.get(m)).intValue() != stack.func_77960_j()) {
            stack.func_77964_b(matID.intValue());
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean par4) {
        super.func_77624_a(stack, player, tooltip, par4);
        if (stack.func_77960_j() == 0) {
            tooltip.add(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.ITALIC.toString() + "Put this into your inventory to update it.");
        }
    }

    private int[] toIntArray(short[] r) {
        int[] i = new int[r.length];
        for (int j = 0; j < r.length; ++j) {
            i[j] = r[j];
        }
        return i;
    }

    public static short[] getRGBa(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.func_74764_b("material")) {
            return Materials._NULL.mRGBa;
        }
        Materials m = Materials.get((String)data.func_74779_i("material"));
        if (m == null || m == Materials._NULL) {
            return Materials._NULL.mRGBa;
        }
        for (int i = 0; i < m.mRGBa.length; i = (int)((byte)(i + 1))) {
            if (m.mRGBa[i] > 255) {
                m.mRGBa[i] = 255;
            }
            if (m.mRGBa[i] >= 0) continue;
            m.mRGBa[i] = 0;
        }
        return m.mRGBa;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public int getMaterialID(ItemStack stack) {
        return TGregUtils.getMaterialID(stack);
    }
}

