/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregAlternateBoltRecipe;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregAmmoRecipe;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregBowRecipe;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregFluidType;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregToolRecipe;
import vexatos.tgregworks.integration.smeltery.CastLegacy;
import vexatos.tgregworks.item.ItemTGregPart;
import vexatos.tgregworks.reference.Config;
import vexatos.tgregworks.reference.PartTypes;
import vexatos.tgregworks.reference.Pattern;
import vexatos.tgregworks.util.TGregUtils;

public class TGregRecipeRegistry {
    private HashMap<PartTypes, ItemTGregPart> partMap = new HashMap();
    public boolean addReverseSmelting = false;
    public boolean addShardToIngotSmelting = false;
    public boolean addIngotToShard = false;
    public boolean addMoltenToShard = false;
    public boolean addShardToToolPart = false;
    public boolean addExtruderRecipes = false;
    public boolean addSolidifierRecipes = false;
    public boolean addFluidExtractorRecipes = false;
    public boolean addShardExtractorRecipes = false;
    public boolean addShardRepair = true;
    public boolean addIngotRepair = false;
    public boolean addGemToolPartRecipes = true;
    public boolean addCastExtruderRecipes = true;
    public boolean addCastSolidifierRecipes = false;
    public boolean useNonGTFluidsForBolts = true;
    public boolean useNonGTToolRodsForBolts = true;
    public float energyMultiplier = 0.0f;

    public void addGregTechPartRecipes() {
        this.addGemToolPartRecipes = TGregworks.config.getBoolean("gemToolPartRecipes", Config.concat("enable", "recipe"), true, "Enable recipes for tool parts made of gems");
        this.energyMultiplier = TGregworks.config.getFloat("energyUsageMultiplier", Config.concat("general", new String[0]), 1.0f, 0.0f, 4500.0f, "Energy usage multiplier for the extruder and solidifier. Base EU/t is either 30 or 120");
        this.addReverseSmelting = TGregworks.config.getBoolean("reverseSmelting", Config.concat("enable", "recipe", "alloysmelter"), true, "Enable smelting tool parts in an alloy smelter to get shards back");
        this.addShardToIngotSmelting = TGregworks.config.getBoolean("shardToIngotSmelting", Config.concat("enable", "recipe", "alloysmelter"), true, "Enable smelting two shards into one ingot in an alloy smelter");
        this.addExtruderRecipes = TGregworks.config.getBoolean("extruderRecipes", Config.concat("enable", "recipe", "extruder"), true, "Enable tool part recipes in the extruder");
        this.addShardToToolPart = TGregworks.config.getBoolean("shardToToolPartRecipe", Config.concat("enable", "recipe", "extruder"), true, "Enable creating tool parts from shards in the extruder (if 'extruderRecipes' is enabled)");
        this.addIngotToShard = TGregworks.config.getBoolean("ingotToShardRecipe", Config.concat("enable", "recipe", "extruder"), true, "Enable creating shards from ingots in the extruder");
        this.addCastExtruderRecipes = TGregworks.config.getBoolean("castExtruderRecipes", Config.concat("enable", "recipe", "extruder"), CastLegacy.metalPattern != null, "Enable creating tool part casts in the extruder");
        this.addSolidifierRecipes = TGregworks.config.getBoolean("solidifierRecipes", Config.concat("enable", "recipe", "fluidsolidifier"), false, "Enable tool part recipes in the fluid solidifier");
        this.addMoltenToShard = TGregworks.config.getBoolean("moltenToShardRecipe", Config.concat("enable", "recipe", "fluidsolidifier"), false, "Enable creating shards from molten material in the fluid solidifier");
        this.addCastSolidifierRecipes = TGregworks.config.getBoolean("castSolidifierRecipes", Config.concat("enable", "recipe", "fluidsolidifier"), false, "Enable creating tool part casts in the fluid solidifier");
        this.useNonGTFluidsForBolts = TGregworks.config.getBoolean("useNonGTFluidsForBolts", Config.concat("enable", "recipe", "fluidsolidifier"), true, "Register Fluid Solidifier recipes for bolts with non-GT fluids.");
        this.useNonGTToolRodsForBolts = TGregworks.config.getBoolean("useNonGTToolRodsForBolts", Config.concat("enable", "recipe", "fluidsolidifier"), true, "Register Fluid Solidifier recipes for bolts with tool rods from non-GT materials.");
        this.addFluidExtractorRecipes = TGregworks.config.getBoolean("fluidExtractorRecipes", Config.concat("enable", "recipe", "fluidextractor"), false, "Enable extracting the molten material out of tool parts in the fluid extractor");
        this.addShardExtractorRecipes = TGregworks.config.getBoolean("shardExtractorRecipes", Config.concat("enable", "recipe", "fluidextractor"), false, "Enable extracting the molten material out of shards in the fluid extractor");
        if (this.energyMultiplier < 0.0f || 120.0f * this.energyMultiplier > 524288.0f) {
            TGregworks.log.error("Invalid energy multiplier found in config: " + this.energyMultiplier + ". Reverting back to 1.");
            this.energyMultiplier = 1.0f;
        }
        for (Materials m : TGregworks.registry.toolMaterials) {
            int powerRequired = this.getPowerRequired(m);
            for (PartTypes p : PartTypes.VALUES) {
                FluidStack molten;
                ItemStack input = TGregUtils.newItemStack(m, p, 1);
                ItemStack pattern = p.getPatternItem();
                if (pattern == null) continue;
                int price = p.getPrice();
                ItemStack stack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)m, (long)(price % 2 != 0 ? (long)(price / 2 + 1) : (long)MathHelper.func_76143_f((double)((double)price / 2.0))));
                if (this.addGemToolPartRecipes && stack == null) {
                    stack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)m, (long)(price % 2 != 0 ? (long)(price / 2 + 1) : (long)MathHelper.func_76143_f((double)((double)price / 2.0))));
                }
                if (stack == null) continue;
                if (this.addExtruderRecipes) {
                    GT_Values.RA.addExtruderRecipe(stack.func_77946_l(), pattern.func_77946_l(), input.func_77946_l(), Math.max(80, m.mDurability * price), powerRequired);
                }
                if ((molten = m.getMolten(72L * (long)p.getPrice())) != null && molten.getFluid() != null) {
                    if (this.addSolidifierRecipes) {
                        GT_Values.RA.addFluidSolidifierRecipe(pattern.func_77946_l(), molten.copy(), input.func_77946_l(), Math.max(80, m.mDurability * price), powerRequired);
                    }
                    if (this.addFluidExtractorRecipes) {
                        GT_Values.RA.addFluidExtractionRecipe(input.func_77946_l(), null, molten.copy(), 0, Math.max(80, m.mDurability * price), powerRequired);
                    }
                }
                if ((stack = this.getChunk(m, price)) == null) continue;
                if (this.addExtruderRecipes && this.addShardToToolPart) {
                    GT_Values.RA.addExtruderRecipe(stack.func_77946_l(), pattern.func_77946_l(), input.func_77946_l(), 80 + m.mDurability * price, powerRequired);
                }
                if (!this.addReverseSmelting) continue;
                GT_Values.RA.addAlloySmelterRecipe(input.func_77946_l(), new ItemStack(TGregworks.shardCast, 0, 0), stack.func_77946_l(), 80 + m.mDurability * price, powerRequired);
            }
            ItemStack stack = this.getChunk(m, 2);
            ItemStack ingotStack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)m, (long)1L);
            if (this.addGemToolPartRecipes && ingotStack == null) {
                ingotStack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)m, (long)1L);
            }
            if (stack == null || ingotStack == null) continue;
            if (this.addIngotToShard) {
                GT_Values.RA.addExtruderRecipe(ingotStack, new ItemStack(TGregworks.shardCast, 0, 0), stack.func_77946_l(), Math.max(160, m.mDurability), powerRequired);
            }
            ItemStack halfStack = stack.func_77946_l();
            halfStack.field_77994_a = 1;
            FluidStack molten = m.getMolten(72L);
            if (molten != null && molten.getFluid() != null) {
                if (this.addMoltenToShard) {
                    GT_Values.RA.addFluidSolidifierRecipe(new ItemStack(TGregworks.shardCast, 0, 0), molten.copy(), halfStack.func_77946_l(), Math.max(160, m.mDurability), powerRequired);
                }
                if (this.addShardExtractorRecipes) {
                    GT_Values.RA.addFluidExtractionRecipe(halfStack.func_77946_l(), null, molten.copy(), 0, Math.max(160, m.mDurability), powerRequired);
                }
            }
            if (!this.addShardToIngotSmelting) continue;
            GT_Values.RA.addAlloySmelterRecipe(stack.func_77946_l(), new ItemStack(Pattern.MetalPatterns.ingot.getPatternItem(), 0, Pattern.MetalPatterns.ingot.ordinal()), ingotStack.func_77946_l(), Math.max(160, m.mDurability), powerRequired);
        }
        if (TGregworks.config.getBoolean("tinkersconstructcastrecipe", Config.concat("enable", "recipe"), true, "Enable the Shard Cast recipe using Tinkers' Construct shards")) {
            ItemStack brassstack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Brass, (long)1L);
            if (TinkerTools.toolShard != null) {
                if (TinkerTools.blankPattern != null) {
                    GT_Values.RA.addExtruderRecipe(new ItemStack(TinkerTools.blankPattern, 1, 1), new ItemStack(TinkerTools.toolShard, 1, 6), new ItemStack(TGregworks.shardCast, 1, 0), 800, Math.round(30.0f * this.energyMultiplier));
                    GT_Values.RA.addExtruderRecipe(new ItemStack(TinkerTools.blankPattern, 1, 2), new ItemStack(TinkerTools.toolShard, 1, 6), new ItemStack(TGregworks.shardCast, 1, 0), 800, Math.round(30.0f * this.energyMultiplier));
                }
                if (brassstack != null && !this.addCastExtruderRecipes) {
                    GT_Values.RA.addExtruderRecipe(brassstack, new ItemStack(TinkerTools.toolShard, 1, 6), new ItemStack(TGregworks.shardCast, 1, 0), 800, Math.round(30.0f * this.energyMultiplier));
                }
            }
        }
        if (TGregworks.config.getBoolean("gregtechcastrecipe", Config.concat("enable", "recipe"), true, "Enable the GregTech style Shard Cast recipe")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TGregworks.shardCast, 1, 0), new Object[]{" CH", " PF", "   ", Character.valueOf('C'), ToolDictNames.craftingToolHardHammer.name(), Character.valueOf('H'), ToolDictNames.craftingToolKnife.name(), Character.valueOf('F'), ToolDictNames.craftingToolFile.name(), Character.valueOf('P'), "plateBrass"}));
        }
    }

    private int getPowerRequired(Materials m) {
        return Math.round(m.mToolQuality < 3 ? 30.0f * this.energyMultiplier : 120.0f * this.energyMultiplier);
    }

    private ItemStack getChunk(Materials m, int amount) {
        return TGregUtils.newItemStack(m, PartTypes.Chunk, amount);
    }

    public void registerRepairMaterials() {
        this.addShardRepair = TGregworks.config.getBoolean("addShardRepair", Config.concat("enable", "recipe"), true, "Allow repairing TGregworks tools with shards");
        this.addIngotRepair = TGregworks.config.getBoolean("addIngotRepair", Config.concat("enable", "recipe"), false, "Allow repairing TGregworks tools with ingots");
        for (Materials m : TGregworks.registry.toolMaterials) {
            ToolMaterial mat;
            Integer matID = TGregworks.registry.matIDs.get(m);
            if (matID == null || (mat = TConstructRegistry.getMaterial((int)matID)) == null) continue;
            if (this.addShardRepair) {
                ItemStack shard = TGregUtils.newItemStack(m, PartTypes.Chunk, 1);
                if (PatternBuilder.instance.materialSets.containsKey(mat.materialName)) {
                    PatternBuilder.instance.registerMaterial(shard, 1, mat.materialName);
                } else {
                    ItemStack rod = TGregUtils.newItemStack(m, PartTypes.ToolRod, 1);
                    PatternBuilder.instance.registerFullMaterial(shard, 1, mat.materialName, shard, rod, matID.intValue());
                }
                TGregworks.repair.registerShardRepairMaterial(m, 1);
            }
            if (!this.addIngotRepair) continue;
            ArrayList ingots = GT_OreDictUnificator.getOres((OrePrefixes)OrePrefixes.ingot, (Object)m);
            if (!ingots.isEmpty()) {
                TGregworks.repair.registerOreDictRepairMaterial(m, OrePrefixes.ingot.get((Object)m).toString(), 2);
            } else if (this.addGemToolPartRecipes) {
                ingots.addAll(GT_OreDictUnificator.getOres((OrePrefixes)OrePrefixes.gem, (Object)m));
                TGregworks.repair.registerOreDictRepairMaterial(m, OrePrefixes.gem.get((Object)m).toString(), 2);
            }
            for (ItemStack ingot : ingots) {
                if (ingot == null || ingot.func_77973_b() == null) continue;
                if (PatternBuilder.instance.materialSets.containsKey(mat.materialName)) {
                    PatternBuilder.instance.registerMaterial(ingot, 1, mat.materialName);
                    continue;
                }
                ItemStack rod = TGregUtils.newItemStack(m, PartTypes.ToolRod, 1);
                PatternBuilder.instance.registerFullMaterial(ingot, 2, mat.materialName, ingot, rod, matID.intValue());
            }
        }
    }

    public void registerBoltRecipes() {
        if (!TConstruct.pulsar.isPulseLoaded("Tinkers' Weaponry")) {
            return;
        }
        if (PHConstruct.alternativeBoltRecipe) {
            GameRegistry.addRecipe((IRecipe)new TGregAlternateBoltRecipe());
        }
        if (!TConstruct.pulsar.isPulseLoaded("Tinkers' Smeltery")) {
            return;
        }
        LiquidCasting tb = TConstructRegistry.getTableCasting();
        for (Map.Entry fluidEntry : FluidType.fluidTypes.entrySet()) {
            int arrowheadMaterialID;
            if (!((FluidType)fluidEntry.getValue()).isToolpart) continue;
            FluidStack liquid = new FluidStack(((FluidType)fluidEntry.getValue()).fluid, 144);
            if (fluidEntry.getValue() instanceof TGregFluidType) {
                arrowheadMaterialID = ((TGregFluidType)((Object)fluidEntry.getValue())).matID;
            } else {
                CastingRecipe recipe = tb.getCastingRecipe(liquid, new ItemStack(TinkerSmeltery.metalPattern, 1, 2));
                if (recipe == null) continue;
                arrowheadMaterialID = recipe.getResult().func_77960_j();
            }
            for (Integer toolRodMaterialID : TConstructRegistry.toolMaterials.keySet()) {
                ItemStack toolRod;
                if (TGregworks.registry.materialIDMap.containsKey(toolRodMaterialID)) {
                    toolRod = TGregUtils.newItemStack(TGregworks.registry.materialIDMap.get(toolRodMaterialID), PartTypes.ToolRod, 1);
                } else {
                    toolRod = new ItemStack(TinkerTools.toolRod, 1, toolRodMaterialID.intValue());
                    if (((IToolPart)TinkerTools.toolRod).getMaterialID(toolRod) == -1) continue;
                }
                if (!TGregworks.registry.materialIDMap.containsKey(toolRodMaterialID) && !(fluidEntry.getValue() instanceof TGregFluidType) || !this.useNonGTToolRodsForBolts && !TGregworks.registry.materialIDMap.containsKey(toolRodMaterialID) || !this.useNonGTFluidsForBolts && !(fluidEntry.getValue() instanceof TGregFluidType)) continue;
                this.addBoltRecipe(toolRod, liquid.copy(), toolRodMaterialID, arrowheadMaterialID);
            }
        }
        ArrayList castingRecipes = TConstructRegistry.getTableCasting().getCastingRecipes();
        ArrayList<CastingRecipe> toRemove = new ArrayList<CastingRecipe>();
        for (CastingRecipe cr : castingRecipes) {
            if (cr == null || cr.cast == null || cr.cast.func_77973_b() != TinkerTools.toolRod || !TGregworks.registry.materialIDMap.containsKey(((IToolPart)TinkerTools.toolRod).getMaterialID(cr.cast))) continue;
            toRemove.add(cr);
        }
        castingRecipes.removeAll(toRemove);
    }

    private int getPowerRequired(ToolMaterial toolMaterial) {
        return Math.round(toolMaterial.harvestLevel < 3 ? 30.0f * this.energyMultiplier : 120.0f * this.energyMultiplier);
    }

    private void addBoltRecipe(ItemStack toolRod, FluidStack fluid, int toolRodMaterialID, int arrowheadMaterialID) {
        ToolMaterial toolRodMaterial = (ToolMaterial)TConstructRegistry.toolMaterials.get(toolRodMaterialID);
        ToolMaterial arrowheadMaterial = (ToolMaterial)TConstructRegistry.toolMaterials.get(arrowheadMaterialID);
        if (toolRodMaterial != null && arrowheadMaterial != null) {
            GT_Values.RA.addFluidSolidifierRecipe(toolRod, fluid, DualMaterialToolPart.createDualMaterial((Item)TinkerWeaponry.partBolt, (int)toolRodMaterialID, (int)arrowheadMaterialID), 80 + (toolRodMaterial.durability + arrowheadMaterial.durability) * 2, Math.max(this.getPowerRequired(toolRodMaterial), this.getPowerRequired(arrowheadMaterial)));
        }
    }

    public void addRecipesForToolBuilder() {
        for (PartTypes p : PartTypes.VALUES) {
            this.partMap.put(p, TGregworks.registry.toolParts.get((Object)p));
        }
        this.addTGregToolRecipe(TinkerTools.pickaxe, PartTypes.PickaxeHead, PartTypes.ToolRod, PartTypes.Binding);
        this.addTGregToolRecipe(TinkerTools.shovel, PartTypes.ShovelHead, PartTypes.ToolRod);
        this.addTGregToolRecipe(TinkerTools.hatchet, PartTypes.AxeHead, PartTypes.ToolRod);
        this.addTGregToolRecipe(TinkerTools.mattock, PartTypes.AxeHead, PartTypes.ToolRod, PartTypes.ShovelHead);
        this.addTGregToolRecipe(TinkerTools.chisel, PartTypes.ChiselHead, PartTypes.ToolRod);
        this.addTGregToolRecipe(TinkerTools.broadsword, PartTypes.SwordBlade, PartTypes.ToolRod, PartTypes.LargeGuard);
        this.addTGregToolRecipe(TinkerTools.longsword, PartTypes.SwordBlade, PartTypes.ToolRod, PartTypes.MediumGuard);
        this.addTGregToolRecipe(TinkerTools.rapier, PartTypes.SwordBlade, PartTypes.ToolRod, PartTypes.Crossbar);
        this.addTGregToolRecipe(TinkerTools.dagger, PartTypes.KnifeBlade, PartTypes.ToolRod, PartTypes.Crossbar);
        this.addTGregToolRecipe(TinkerTools.cutlass, PartTypes.SwordBlade, PartTypes.ToolRod, PartTypes.FullGuard);
        this.addTGregToolRecipe(TinkerTools.frypan, PartTypes.FrypanHead, PartTypes.ToolRod);
        this.addTGregToolRecipe(TinkerTools.battlesign, PartTypes.SignHead, PartTypes.ToolRod);
        this.addTGregToolRecipe(TinkerTools.scythe, PartTypes.ScytheHead, PartTypes.ToughRod, PartTypes.ToughBind, PartTypes.ToughRod);
        this.addTGregToolRecipe(TinkerTools.lumberaxe, PartTypes.LumberHead, PartTypes.ToughRod, PartTypes.LargePlate, PartTypes.ToughBind);
        this.addTGregToolRecipe(TinkerTools.cleaver, PartTypes.LargeSwordBlade, PartTypes.ToughRod, PartTypes.LargePlate, PartTypes.ToughRod);
        this.addTGregToolRecipe(TinkerTools.excavator, PartTypes.ExcavatorHead, PartTypes.ToughRod, PartTypes.LargePlate, PartTypes.ToughBind);
        this.addTGregToolRecipe(TinkerTools.hammer, PartTypes.HammerHead, PartTypes.ToughRod, PartTypes.LargePlate, PartTypes.LargePlate);
        this.addTGregToolRecipe(TinkerTools.battleaxe, PartTypes.LumberHead, PartTypes.ToughRod, PartTypes.LumberHead, PartTypes.ToughBind);
        if (TConstruct.pulsar.isPulseLoaded("Tinkers' Weaponry")) {
            ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregBowRecipe(this.partMap.get((Object)PartTypes.BowLimb), TinkerWeaponry.bowstring, this.partMap.get((Object)PartTypes.BowLimb), (ToolCore)TinkerWeaponry.shortbow));
            ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregBowRecipe(this.partMap.get((Object)PartTypes.BowLimb), TinkerWeaponry.bowstring, this.partMap.get((Object)PartTypes.BowLimb), this.partMap.get((Object)PartTypes.LargePlate), (ToolCore)TinkerWeaponry.longbow));
            ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregBowRecipe(this.partMap.get((Object)PartTypes.CrossbowLimb), this.partMap.get((Object)PartTypes.CrossbowBody), TinkerWeaponry.bowstring, this.partMap.get((Object)PartTypes.ToughBind), (ToolCore)TinkerWeaponry.crossbow));
            TGregAmmoRecipe arrowRecipe = new TGregAmmoRecipe(this.partMap.get((Object)PartTypes.ArrowHead), this.partMap.get((Object)PartTypes.ToolRod), TinkerWeaponry.fletching, (ToolCore)TinkerWeaponry.arrowAmmo);
            arrowRecipe.addHandleItem((Item)TinkerWeaponry.partArrowShaft);
            ToolBuilder.addCustomToolRecipe((ToolRecipe)arrowRecipe);
            ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregToolRecipe(this.partMap.get((Object)PartTypes.Shuriken), this.partMap.get((Object)PartTypes.Shuriken), this.partMap.get((Object)PartTypes.Shuriken), this.partMap.get((Object)PartTypes.Shuriken), (ToolCore)TinkerWeaponry.shuriken));
            this.addTGregToolRecipe((ToolCore)TinkerWeaponry.throwingknife, PartTypes.KnifeBlade, PartTypes.ToolRod);
            this.addTGregToolRecipe((ToolCore)TinkerWeaponry.javelin, PartTypes.ArrowHead, PartTypes.ToughRod, PartTypes.ToughRod);
        }
    }

    private void addTGregToolRecipe(ToolCore output, PartTypes head, PartTypes handle) {
        ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregToolRecipe(this.partMap.get((Object)head), this.partMap.get((Object)handle), output));
    }

    private void addTGregToolRecipe(ToolCore output, PartTypes head, PartTypes handle, PartTypes accessory) {
        ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregToolRecipe(this.partMap.get((Object)head), this.partMap.get((Object)handle), this.partMap.get((Object)accessory), output));
    }

    private void addTGregToolRecipe(ToolCore output, PartTypes head, PartTypes handle, PartTypes accessory, PartTypes extra) {
        ToolBuilder.addCustomToolRecipe((ToolRecipe)new TGregToolRecipe(this.partMap.get((Object)head), this.partMap.get((Object)handle), this.partMap.get((Object)accessory), this.partMap.get((Object)extra), output));
    }

    public void registerCastRecipes() {
        FluidStack molten;
        ItemStack stack;
        Materials[] castingMaterials = new Materials[]{Materials.Brass, Materials.Gold};
        if (this.addCastExtruderRecipes) {
            for (PartTypes partTypes : PartTypes.VALUES) {
                stack = partTypes.getPatternItem();
                if (stack == null || stack.func_77973_b() == null) continue;
                for (Materials m : castingMaterials) {
                    GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)m, (long)1L), new ItemStack(partTypes.getCounterpart(), 0, Short.MAX_VALUE), stack.func_77946_l(), 800, this.getPowerRequired(m));
                    GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)m, (long)1L), new ItemStack((Item)TGregworks.registry.toolParts.get((Object)partTypes), 0, Short.MAX_VALUE), stack.func_77946_l(), 800, this.getPowerRequired(m));
                }
            }
            for (PartTypes partTypes : castingMaterials) {
                molten = partTypes.getMolten(144L);
                if (molten == null || molten.getFluid() == null) continue;
                GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)((Object)partTypes), (long)1L), new ItemStack((Item)TGregworks.registry.toolParts.get((Object)PartTypes.Chunk), 0, Short.MAX_VALUE), new ItemStack(TGregworks.shardCast, 1, 0), 800, this.getPowerRequired((Materials)partTypes));
            }
        }
        if (this.addCastSolidifierRecipes) {
            for (PartTypes partTypes : PartTypes.VALUES) {
                stack = partTypes.getPatternItem();
                if (stack == null || stack.func_77973_b() == null || partTypes.getCounterpart() == null) continue;
                stack.field_77994_a = 1;
                for (Materials m : castingMaterials) {
                    FluidStack molten2 = m.getMolten(144L);
                    if (molten2 == null || molten2.getFluid() == null) continue;
                    GT_Values.RA.addFluidSolidifierRecipe(new ItemStack(partTypes.getCounterpart(), 0, Short.MAX_VALUE), molten2.copy(), stack.func_77946_l(), 800, this.getPowerRequired(m));
                    GT_Values.RA.addFluidSolidifierRecipe(new ItemStack((Item)TGregworks.registry.toolParts.get((Object)partTypes), 0, Short.MAX_VALUE), molten2.copy(), stack.func_77946_l(), 800, this.getPowerRequired(m));
                }
            }
            for (PartTypes partTypes : castingMaterials) {
                molten = partTypes.getMolten(144L);
                if (molten == null || molten.getFluid() == null) continue;
                GT_Values.RA.addFluidSolidifierRecipe(new ItemStack((Item)TGregworks.registry.toolParts.get((Object)PartTypes.Chunk), 0, Short.MAX_VALUE), molten.copy(), new ItemStack(TGregworks.shardCast, 1, 0), 800, this.getPowerRequired((Materials)partTypes));
            }
        }
    }
}

