/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mantle.blocks.BlockUtils;
import mantle.blocks.abstracts.MultiServantLogic;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.util.IPattern;
import tconstruct.smeltery.SmelteryProxyCommon;
import tconstruct.smeltery.TinkerSmelteryEvents;
import tconstruct.smeltery.blocks.BloodBlock;
import tconstruct.smeltery.blocks.CastingChannelBlock;
import tconstruct.smeltery.blocks.GlassBlockConnected;
import tconstruct.smeltery.blocks.GlassBlockConnectedMeta;
import tconstruct.smeltery.blocks.GlassPaneConnected;
import tconstruct.smeltery.blocks.GlassPaneStained;
import tconstruct.smeltery.blocks.GlueBlock;
import tconstruct.smeltery.blocks.GlueFluid;
import tconstruct.smeltery.blocks.LavaTankBlock;
import tconstruct.smeltery.blocks.PigIronMoltenBlock;
import tconstruct.smeltery.blocks.SearedBlock;
import tconstruct.smeltery.blocks.SearedSlab;
import tconstruct.smeltery.blocks.SmelteryBlock;
import tconstruct.smeltery.blocks.SpeedBlock;
import tconstruct.smeltery.blocks.SpeedSlab;
import tconstruct.smeltery.blocks.TConstructFluid;
import tconstruct.smeltery.itemblocks.CastingChannelItem;
import tconstruct.smeltery.itemblocks.GlassBlockItem;
import tconstruct.smeltery.itemblocks.GlassPaneItem;
import tconstruct.smeltery.itemblocks.LavaTankItemBlock;
import tconstruct.smeltery.itemblocks.SearedSlabItem;
import tconstruct.smeltery.itemblocks.SearedTableItemBlock;
import tconstruct.smeltery.itemblocks.SmelteryItemBlock;
import tconstruct.smeltery.itemblocks.SpeedBlockItem;
import tconstruct.smeltery.itemblocks.SpeedSlabItem;
import tconstruct.smeltery.itemblocks.StainedGlassClearItem;
import tconstruct.smeltery.itemblocks.StainedGlassClearPaneItem;
import tconstruct.smeltery.items.ClayPattern;
import tconstruct.smeltery.items.FilledBucket;
import tconstruct.smeltery.items.MetalPattern;
import tconstruct.smeltery.logic.CastingBasinLogic;
import tconstruct.smeltery.logic.CastingChannelLogic;
import tconstruct.smeltery.logic.CastingTableLogic;
import tconstruct.smeltery.logic.FaucetLogic;
import tconstruct.smeltery.logic.LavaTankLogic;
import tconstruct.smeltery.logic.SmelteryDrainLogic;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;
import tconstruct.world.items.OreBerries;

@GameRegistry.ObjectHolder(value="TConstruct")
@Pulse(id="Tinkers' Smeltery", description="Liquid metals, casting, and the multiblock structure.")
public class TinkerSmeltery {
    @SidedProxy(clientSide="tconstruct.smeltery.SmelteryProxyClient", serverSide="tconstruct.smeltery.SmelteryProxyCommon")
    public static SmelteryProxyCommon proxy;
    public static Item metalPattern;
    public static Item clayPattern;
    public static Item buckets;
    public static Block smeltery;
    public static Block lavaTank;
    public static Block searedBlock;
    public static Block castingChannel;
    public static Block smelteryNether;
    public static Block lavaTankNether;
    public static Block searedBlockNether;
    public static Block searedSlab;
    public static Block glueBlock;
    public static Block clearGlass;
    public static Block stainedGlassClear;
    public static Block glassPane;
    public static Block stainedGlassClearPane;
    public static Block glassMagicSlab;
    public static Block stainedGlassMagicSlab;
    public static Block stainedGlassClearMagicSlab;
    public static Material liquidMetal;
    public static Fluid moltenIronFluid;
    public static Fluid moltenGoldFluid;
    public static Fluid moltenCopperFluid;
    public static Fluid moltenTinFluid;
    public static Fluid moltenAluminumFluid;
    public static Fluid moltenCobaltFluid;
    public static Fluid moltenArditeFluid;
    public static Fluid moltenBronzeFluid;
    public static Fluid moltenAlubrassFluid;
    public static Fluid moltenManyullynFluid;
    public static Fluid moltenAlumiteFluid;
    public static Fluid moltenObsidianFluid;
    public static Fluid moltenSteelFluid;
    public static Fluid moltenGlassFluid;
    public static Fluid moltenStoneFluid;
    public static Fluid moltenEmeraldFluid;
    public static Fluid moltenQuartzFluid;
    public static Fluid moltenNickelFluid;
    public static Fluid moltenLeadFluid;
    public static Fluid moltenSilverFluid;
    public static Fluid moltenShinyFluid;
    public static Fluid moltenInvarFluid;
    public static Fluid moltenElectrumFluid;
    public static Fluid moltenLumiumFluid;
    public static Fluid moltenSignalumFluid;
    public static Fluid moltenMithrilFluid;
    public static Fluid moltenEnderiumFluid;
    public static Fluid moltenEnderFluid;
    public static Block moltenIron;
    public static Block moltenGold;
    public static Block moltenCopper;
    public static Block moltenTin;
    public static Block moltenAluminum;
    public static Block moltenCobalt;
    public static Block moltenArdite;
    public static Block moltenBronze;
    public static Block moltenAlubrass;
    public static Block moltenManyullyn;
    public static Block moltenAlumite;
    public static Block moltenObsidian;
    public static Block moltenSteel;
    public static Block moltenGlass;
    public static Block moltenStone;
    public static Block moltenEmerald;
    public static Block moltenQuartz;
    public static Block moltenNickel;
    public static Block moltenLead;
    public static Block moltenSilver;
    public static Block moltenShiny;
    public static Block moltenInvar;
    public static Block moltenElectrum;
    public static Block moltenLumium;
    public static Block moltenSignalum;
    public static Block moltenMithril;
    public static Block moltenEnderium;
    public static Block moltenEnder;
    public static Fluid glueFluid;
    public static Block glueFluidBlock;
    public static Fluid pigIronFluid;
    public static Block pigIronFluidBlock;
    public static Fluid[] fluids;
    public static Block[] fluidBlocks;
    public static FluidStack[] liquids;
    public static Block speedSlab;
    public static Block speedBlock;
    public static Fluid bloodFluid;
    public static Block blood;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        TinkerSmelteryEvents smelteryEvents = new TinkerSmelteryEvents();
        MinecraftForge.EVENT_BUS.register((Object)smelteryEvents);
        FMLCommonHandler.instance().bus().register((Object)smelteryEvents);
        buckets = new FilledBucket(BlockUtils.getBlockFromItem((Item)buckets));
        GameRegistry.registerItem((Item)buckets, (String)"buckets");
        searedSlab = new SearedSlab().func_149663_c("SearedSlab");
        TinkerSmeltery.searedSlab.field_149762_H = Block.field_149769_e;
        speedSlab = new SpeedSlab().func_149663_c("SpeedSlab");
        TinkerSmeltery.speedSlab.field_149762_H = Block.field_149769_e;
        glueBlock = new GlueBlock().func_149663_c("GlueBlock").func_149647_a((CreativeTabs)TConstructRegistry.blockTab);
        smeltery = new SmelteryBlock().func_149663_c("Smeltery");
        smelteryNether = new SmelteryBlock("nether").func_149663_c("Smeltery");
        lavaTank = new LavaTankBlock().func_149663_c("LavaTank");
        lavaTank.func_149672_a(Block.field_149778_k);
        lavaTankNether = new LavaTankBlock("nether").func_149672_a(Block.field_149778_k).func_149663_c("LavaTank");
        searedBlock = new SearedBlock().func_149663_c("SearedBlock");
        searedBlockNether = new SearedBlock("nether").func_149663_c("SearedBlock");
        castingChannel = new CastingChannelBlock().func_149663_c("CastingChannel");
        liquidMetal = new MaterialLiquid(MapColor.field_151656_f);
        moltenIronFluid = TinkerSmeltery.registerFluid("iron");
        moltenIron = moltenIronFluid.getBlock();
        moltenGoldFluid = TinkerSmeltery.registerFluid("gold");
        moltenGold = moltenGoldFluid.getBlock();
        moltenCopperFluid = TinkerSmeltery.registerFluid("copper");
        moltenCopper = moltenCopperFluid.getBlock();
        moltenTinFluid = TinkerSmeltery.registerFluid("tin");
        moltenTin = moltenTinFluid.getBlock();
        moltenAluminumFluid = TinkerSmeltery.registerFluid("aluminum");
        moltenAluminum = moltenAluminumFluid.getBlock();
        moltenCobaltFluid = TinkerSmeltery.registerFluid("cobalt");
        moltenCobalt = moltenCobaltFluid.getBlock();
        moltenArditeFluid = TinkerSmeltery.registerFluid("ardite");
        moltenArdite = moltenArditeFluid.getBlock();
        moltenBronzeFluid = TinkerSmeltery.registerFluid("bronze");
        moltenBronze = moltenBronzeFluid.getBlock();
        moltenAlubrassFluid = TinkerSmeltery.registerFluid("aluminiumbrass", "aluminumbrass.molten", "fluid.molten.alubrass", "liquid_alubrass", 3000, 6000, 1300, Material.field_151587_i);
        moltenAlubrass = moltenAlubrassFluid.getBlock();
        moltenManyullynFluid = TinkerSmeltery.registerFluid("manyullyn");
        moltenManyullyn = moltenManyullynFluid.getBlock();
        moltenAlumiteFluid = TinkerSmeltery.registerFluid("alumite");
        moltenAlumite = moltenAlumiteFluid.getBlock();
        moltenObsidianFluid = TinkerSmeltery.registerFluid("obsidian");
        moltenObsidian = moltenObsidianFluid.getBlock();
        moltenSteelFluid = TinkerSmeltery.registerFluid("steel");
        moltenSteel = moltenSteelFluid.getBlock();
        moltenGlassFluid = TinkerSmeltery.registerFluid("glass");
        moltenGlass = moltenGlassFluid.getBlock();
        moltenStoneFluid = TinkerSmeltery.registerFluid("stone", "stone.seared", "molten.stone", "liquid_stone", 3000, 6000, 1300, Material.field_151587_i);
        moltenStone = moltenStoneFluid.getBlock();
        moltenEmeraldFluid = TinkerSmeltery.registerFluid("emerald", "emerald.liquid", "molten.emerald", "liquid_villager", 3000, 6000, 1300, Material.field_151587_i);
        moltenEmerald = moltenEmeraldFluid.getBlock();
        moltenQuartzFluid = TinkerSmeltery.registerFluid("quartz", "quartz.molten", "molten.quartz", "liquid_quartz", 3000, 6000, 1300, Material.field_151587_i);
        moltenQuartz = moltenQuartzFluid.getBlock();
        moltenNickelFluid = TinkerSmeltery.registerFluid("nickel", "liquid_ferrous");
        moltenNickel = moltenNickelFluid.getBlock();
        moltenLeadFluid = TinkerSmeltery.registerFluid("lead");
        moltenLead = moltenLeadFluid.getBlock();
        moltenSilverFluid = TinkerSmeltery.registerFluid("silver");
        moltenSilver = moltenSilverFluid.getBlock();
        moltenShinyFluid = TinkerSmeltery.registerFluid("platinum", "platinum.molten", "fluid.molten.shiny", "liquid_shiny", 3000, 6000, 1300, Material.field_151587_i);
        moltenShiny = moltenShinyFluid.getBlock();
        moltenInvarFluid = TinkerSmeltery.registerFluid("invar");
        moltenInvar = moltenInvarFluid.getBlock();
        moltenElectrumFluid = TinkerSmeltery.registerFluid("electrum");
        moltenElectrum = moltenElectrumFluid.getBlock();
        moltenEnderFluid = TinkerSmeltery.registerFluid("ender", "ender", "fluid.ender", "liquid_ender", 3000, 6000, 295, Material.field_151586_h);
        moltenEnder = moltenEnderFluid.getBlock();
        moltenLumiumFluid = TinkerSmeltery.registerFluid("lumium");
        moltenLumium = moltenLumiumFluid.getBlock();
        moltenSignalumFluid = TinkerSmeltery.registerFluid("signalum");
        moltenSignalum = moltenSignalumFluid.getBlock();
        moltenMithrilFluid = TinkerSmeltery.registerFluid("mithril");
        moltenMithril = moltenMithrilFluid.getBlock();
        moltenEnderiumFluid = TinkerSmeltery.registerFluid("enderium");
        moltenEnderium = moltenEnderiumFluid.getBlock();
        bloodFluid = new Fluid("blood").setDensity(3000).setViscosity(6000).setTemperature(1300);
        boolean isBloodPreReg = !FluidRegistry.registerFluid((Fluid)bloodFluid);
        blood = new BloodBlock(bloodFluid, Material.field_151586_h, "liquid_cow").func_149663_c("liquid.blood");
        GameRegistry.registerBlock((Block)blood, (String)"liquid.blood");
        if (isBloodPreReg) {
            bloodFluid = FluidRegistry.getFluid((String)"blood");
            Block regBloodBlock = bloodFluid.getBlock();
            if (regBloodBlock != null) {
                ((TConstructFluid)blood).suppressOverwritingFluidIcons();
                blood = regBloodBlock;
            } else {
                bloodFluid.setBlock(blood);
            }
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(bloodFluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(bloodFluid, 1000), new ItemStack(buckets, 1, 16), new ItemStack(Items.field_151133_ar)));
        }
        boolean isGluePreReg = !FluidRegistry.registerFluid((Fluid)(glueFluid = new Fluid("glue").setDensity(6000).setViscosity(6000).setTemperature(200)));
        glueFluidBlock = new GlueFluid(glueFluid, Material.field_151586_h).func_149647_a(TConstructRegistry.blockTab).func_149672_a(TinkerWorld.slimeStep).func_149663_c("liquid.glue");
        GameRegistry.registerBlock((Block)glueFluidBlock, (String)"liquid.glue");
        if (isGluePreReg) {
            glueFluid = FluidRegistry.getFluid((String)"glue");
            Block regGlueFluidBlock = glueFluid.getBlock();
            if (regGlueFluidBlock != null) {
                ((GlueFluid)glueFluidBlock).suppressOverwritingFluidIcons();
                glueFluidBlock = regGlueFluidBlock;
            } else {
                glueFluid.setBlock(glueFluidBlock);
            }
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(glueFluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(glueFluid, 1000), new ItemStack(buckets, 1, 25), new ItemStack(Items.field_151133_ar)));
        }
        boolean isPigIronPreReg = !FluidRegistry.registerFluid((Fluid)(pigIronFluid = new Fluid("pigiron.molten").setDensity(3000).setViscosity(6000).setTemperature(1300)));
        pigIronFluidBlock = new PigIronMoltenBlock(pigIronFluid, Material.field_151586_h, "liquid_pigiron").func_149663_c("fluid.molten.pigiron");
        GameRegistry.registerBlock((Block)pigIronFluidBlock, (String)"fluid.molten.pigiron");
        if (isPigIronPreReg) {
            pigIronFluid = FluidRegistry.getFluid((String)"pigiron.molten");
            Block regPigIronFluid = pigIronFluid.getBlock();
            if (regPigIronFluid != null) {
                ((PigIronMoltenBlock)pigIronFluidBlock).suppressOverwritingFluidIcons();
                pigIronFluidBlock = regPigIronFluid;
            } else {
                pigIronFluid.setBlock(pigIronFluidBlock);
            }
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(pigIronFluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(pigIronFluid, 1000), new ItemStack(buckets, 1, 26), new ItemStack(Items.field_151133_ar)));
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(TinkerWorld.blueSlimeFluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(TinkerWorld.blueSlimeFluid, 1000), new ItemStack(buckets, 1, 24), new ItemStack(Items.field_151133_ar)));
        }
        fluids = new Fluid[]{moltenIronFluid, moltenGoldFluid, moltenCopperFluid, moltenTinFluid, moltenAluminumFluid, moltenCobaltFluid, moltenArditeFluid, moltenBronzeFluid, moltenAlubrassFluid, moltenManyullynFluid, moltenAlumiteFluid, moltenObsidianFluid, moltenSteelFluid, moltenGlassFluid, moltenStoneFluid, moltenEmeraldFluid, bloodFluid, moltenNickelFluid, moltenLeadFluid, moltenSilverFluid, moltenShinyFluid, moltenInvarFluid, moltenElectrumFluid, moltenEnderFluid, TinkerWorld.blueSlimeFluid, glueFluid, pigIronFluid, moltenQuartzFluid};
        fluidBlocks = new Block[]{moltenIron, moltenGold, moltenCopper, moltenTin, moltenAluminum, moltenCobalt, moltenArdite, moltenBronze, moltenAlubrass, moltenManyullyn, moltenAlumite, moltenObsidian, moltenSteel, moltenGlass, moltenStone, moltenEmerald, blood, moltenNickel, moltenLead, moltenSilver, moltenShiny, moltenInvar, moltenElectrum, moltenEnder, TinkerWorld.slimePool, glueFluidBlock, pigIronFluidBlock, moltenLumium, moltenSignalum, moltenMithril, moltenEnderium, moltenQuartz};
        FluidType.registerFluidType("Water", Blocks.field_150433_aE, 0, 20, FluidRegistry.getFluid((String)"water"), false);
        FluidType.registerFluidType("Iron", Blocks.field_150339_S, 0, 600, moltenIronFluid, true);
        FluidType.registerFluidType("Gold", Blocks.field_150340_R, 0, 400, moltenGoldFluid, false);
        FluidType.registerFluidType("Tin", TinkerWorld.metalBlock, 5, 400, moltenTinFluid, false);
        FluidType.registerFluidType("Copper", TinkerWorld.metalBlock, 3, 550, moltenCopperFluid, true);
        FluidType.registerFluidType("Aluminum", TinkerWorld.metalBlock, 6, 350, moltenAluminumFluid, false);
        FluidType.registerFluidType("NaturalAluminum", TinkerWorld.oreSlag, 6, 350, moltenAluminumFluid, false);
        FluidType.registerFluidType("Cobalt", TinkerWorld.metalBlock, 0, 650, moltenCobaltFluid, true);
        FluidType.registerFluidType("Ardite", TinkerWorld.metalBlock, 1, 650, moltenArditeFluid, true);
        FluidType.registerFluidType("AluminumBrass", TinkerWorld.metalBlock, 7, 350, moltenAlubrassFluid, false);
        FluidType.registerFluidType("Alumite", TinkerWorld.metalBlock, 8, 800, moltenAlumiteFluid, true);
        FluidType.registerFluidType("Manyullyn", TinkerWorld.metalBlock, 2, 750, moltenManyullynFluid, true);
        FluidType.registerFluidType("Bronze", TinkerWorld.metalBlock, 4, 500, moltenBronzeFluid, true);
        FluidType.registerFluidType("Steel", TinkerWorld.metalBlock, 9, 700, moltenSteelFluid, true);
        FluidType.registerFluidType("Obsidian", Blocks.field_150343_Z, 0, 750, moltenObsidianFluid, true);
        FluidType.registerFluidType("Ender", TinkerWorld.metalBlock, 10, 500, moltenEnderFluid, false);
        FluidType.registerFluidType("Glass", (Block)Blocks.field_150354_m, 0, 625, moltenGlassFluid, false);
        FluidType.registerFluidType("Stone", Blocks.field_150348_b, 0, 800, moltenStoneFluid, true);
        FluidType.registerFluidType("Emerald", Blocks.field_150475_bE, 0, 575, moltenEmeraldFluid, false);
        FluidType.registerFluidType("Quartz", Blocks.field_150371_ca, 0, 575, moltenQuartzFluid, false);
        FluidType.registerFluidType("PigIron", TinkerWorld.meatBlock, 0, 610, pigIronFluid, true);
        FluidType.registerFluidType("Glue", glueBlock, 0, 125, glueFluid, false);
        speedBlock = new SpeedBlock().func_149663_c("SpeedBlock");
        clearGlass = new GlassBlockConnected("clear", false).func_149663_c("GlassBlock");
        TinkerSmeltery.clearGlass.field_149762_H = Block.field_149778_k;
        glassPane = new GlassPaneConnected("clear", false);
        stainedGlassClear = new GlassBlockConnectedMeta("stained", true, "white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black").func_149663_c("GlassBlock.StainedClear");
        TinkerSmeltery.stainedGlassClear.field_149762_H = Block.field_149778_k;
        stainedGlassClearPane = new GlassPaneStained();
        GameRegistry.registerBlock((Block)searedSlab, SearedSlabItem.class, (String)"SearedSlab");
        GameRegistry.registerBlock((Block)speedSlab, SpeedSlabItem.class, (String)"SpeedSlab");
        GameRegistry.registerBlock((Block)glueBlock, (String)"GlueBlock");
        OreDictionary.registerOre((String)"blockRubber", (ItemStack)new ItemStack(glueBlock));
        GameRegistry.registerBlock((Block)smeltery, SmelteryItemBlock.class, (String)"Smeltery");
        GameRegistry.registerBlock((Block)smelteryNether, SmelteryItemBlock.class, (String)"SmelteryNether");
        GameRegistry.registerTileEntity(SmelteryLogic.class, (String)"TConstruct.Smeltery");
        GameRegistry.registerTileEntity(SmelteryDrainLogic.class, (String)"TConstruct.SmelteryDrain");
        GameRegistry.registerTileEntity(MultiServantLogic.class, (String)"TConstruct.Servants");
        GameRegistry.registerBlock((Block)lavaTank, LavaTankItemBlock.class, (String)"LavaTank");
        GameRegistry.registerBlock((Block)lavaTankNether, LavaTankItemBlock.class, (String)"LavaTankNether");
        GameRegistry.registerTileEntity(LavaTankLogic.class, (String)"TConstruct.LavaTank");
        GameRegistry.registerBlock((Block)searedBlock, SearedTableItemBlock.class, (String)"SearedBlock");
        GameRegistry.registerBlock((Block)searedBlockNether, SearedTableItemBlock.class, (String)"SearedBlockNether");
        GameRegistry.registerTileEntity(CastingTableLogic.class, (String)"CastingTable");
        GameRegistry.registerTileEntity(FaucetLogic.class, (String)"Faucet");
        GameRegistry.registerTileEntity(CastingBasinLogic.class, (String)"CastingBasin");
        GameRegistry.registerBlock((Block)castingChannel, CastingChannelItem.class, (String)"CastingChannel");
        GameRegistry.registerTileEntity(CastingChannelLogic.class, (String)"CastingChannel");
        GameRegistry.registerBlock((Block)speedBlock, SpeedBlockItem.class, (String)"SpeedBlock");
        GameRegistry.registerBlock((Block)clearGlass, GlassBlockItem.class, (String)"GlassBlock");
        GameRegistry.registerBlock((Block)glassPane, GlassPaneItem.class, (String)"GlassPane");
        GameRegistry.registerBlock((Block)stainedGlassClear, StainedGlassClearItem.class, (String)"GlassBlock.StainedClear");
        GameRegistry.registerBlock((Block)stainedGlassClearPane, StainedGlassClearPaneItem.class, (String)"GlassPaneClearStained");
        metalPattern = new MetalPattern("cast_", "materials/").func_77655_b("tconstruct.MetalPattern");
        GameRegistry.registerItem((Item)metalPattern, (String)"metalPattern");
        TConstructRegistry.addItemToDirectory("metalPattern", metalPattern);
        String[] patternTypes = new String[]{"ingot", "toolRod", "pickaxeHead", "shovelHead", "hatchetHead", "swordBlade", "wideGuard", "handGuard", "crossbar", "binding", "frypanHead", "signHead", "knifeBlade", "chiselHead", "toughRod", "toughBinding", "largePlate", "broadAxeHead", "scytheHead", "excavatorHead", "largeBlade", "hammerHead", "fullGuard"};
        for (int i = 0; i < patternTypes.length; ++i) {
            TConstructRegistry.addItemStackToDirectory(patternTypes[i] + "Cast", new ItemStack(metalPattern, 1, i));
        }
        clayPattern = new ClayPattern("clay_cast_", "materials/").func_77655_b("tconstruct.ClayPattern");
        GameRegistry.registerItem((Item)clayPattern, (String)"clayPattern");
        TConstructRegistry.addItemToDirectory("clayPattern", clayPattern);
        String[] clayPatternTypes = new String[]{"ingot", "toolRod", "pickaxeHead", "shovelHead", "hatchetHead", "swordBlade", "wideGuard", "handGuard", "crossbar", "binding", "frypanHead", "signHead", "knifeBlade", "chiselHead"};
        for (int i = 0; i < clayPatternTypes.length; ++i) {
            TConstructRegistry.addItemStackToDirectory(clayPatternTypes[i] + "clayCast", new ItemStack(clayPattern, 1, i));
        }
        this.oreRegistry();
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        proxy.initialize();
        this.craftingTableRecipes();
        TinkerSmeltery.addRecipesForSmeltery();
        this.addRecipesForTableCasting();
        this.addRecipesForBasinCasting();
        this.addRecipesForFurnace();
    }

    @Handler
    public void postInit(FMLPostInitializationEvent evt) {
        this.addOreDictionarySmelteryRecipes();
        this.modIntegration();
    }

    private void craftingTableRecipes() {
        String[] patSurround = new String[]{"###", "#m#", "###"};
        String[] dyeTypes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            String color = dyeTypes[15 - i];
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stainedGlassClear, 8, i), new Object[]{patSurround, Character.valueOf('m'), color, Character.valueOf('#'), clearGlass}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stainedGlassClear, 1, i), new Object[]{color, clearGlass}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stainedGlassClear, 8, i), new Object[]{patSurround, Character.valueOf('m'), color, Character.valueOf('#'), new ItemStack(stainedGlassClear, 1, Short.MAX_VALUE)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stainedGlassClear, 1, i), new Object[]{color, new ItemStack(stainedGlassClear, 1, Short.MAX_VALUE)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stainedGlassClearPane, 8, i), new Object[]{patSurround, Character.valueOf('m'), color, Character.valueOf('#'), glassPane}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stainedGlassClearPane, 1, i), new Object[]{color, glassPane}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stainedGlassClearPane, 8, i), new Object[]{patSurround, Character.valueOf('m'), color, Character.valueOf('#'), new ItemStack(stainedGlassClearPane, 1, Short.MAX_VALUE)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stainedGlassClearPane, 1, i), new Object[]{color, new ItemStack(stainedGlassClearPane, 1, Short.MAX_VALUE)}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151069_bo, 3), (Object[])new Object[]{"# #", " # ", Character.valueOf('#'), clearGlass});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Blocks.field_150453_bW), new Object[]{"GGG", "QQQ", "WWW", Character.valueOf('G'), "blockGlass", Character.valueOf('Q'), "gemQuartz", Character.valueOf('W'), "slabWood"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)Blocks.field_150461_bJ, 1), (Object[])new Object[]{"GGG", "GSG", "OOO", Character.valueOf('G'), clearGlass, Character.valueOf('S'), Items.field_151156_bN, Character.valueOf('O'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(glassPane, 16, 0), new Object[]{"GGG", "GGG", Character.valueOf('G'), clearGlass}));
        ItemStack searedBrick = new ItemStack(TinkerTools.materials, 1, 2);
        GameRegistry.addRecipe((ItemStack)new ItemStack(smeltery, 1, 0), (Object[])new Object[]{"bbb", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(smeltery, 1, 1), (Object[])new Object[]{"b b", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(smeltery, 1, 2), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTank, 1, 0), new Object[]{patSurround, Character.valueOf('#'), searedBrick, Character.valueOf('m'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTank, 1, 1), new Object[]{"bgb", "ggg", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTank, 1, 2), new Object[]{"bgb", "bgb", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlock, 1, 0), (Object[])new Object[]{"bbb", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlock, 1, 1), (Object[])new Object[]{"b b", " b ", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlock, 1, 2), (Object[])new Object[]{"b b", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(castingChannel, 4, 0), (Object[])new Object[]{"b b", "bbb", Character.valueOf('b'), searedBrick});
        searedBrick = new ItemStack(TinkerTools.materials, 1, 37);
        GameRegistry.addRecipe((ItemStack)new ItemStack(smelteryNether, 1, 0), (Object[])new Object[]{"bbb", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(smelteryNether, 1, 1), (Object[])new Object[]{"b b", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(smelteryNether, 1, 2), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTankNether, 1, 0), new Object[]{patSurround, Character.valueOf('#'), searedBrick, Character.valueOf('m'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTankNether, 1, 1), new Object[]{"bgb", "ggg", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(lavaTankNether, 1, 2), new Object[]{"bgb", "bgb", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlockNether, 1, 0), (Object[])new Object[]{"bbb", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlockNether, 1, 1), (Object[])new Object[]{"b b", " b ", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedBlockNether, 1, 2), (Object[])new Object[]{"b b", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack(castingChannel, 4, 1), (Object[])new Object[]{"b b", "bbb", Character.valueOf('b'), searedBrick});
        for (int i = 0; i < 7; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(speedSlab, 6, i), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(speedBlock, 1, i)});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 0), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 1), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 2), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 3), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 4), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 5), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 9)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 6), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 10)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(searedSlab, 6, 7), (Object[])new Object[]{"bbb", Character.valueOf('b'), new ItemStack(smeltery, 1, 11)});
    }

    public void addOreDictionarySmelteryRecipes() {
        List<FluidType> exceptions = Arrays.asList(FluidType.getFluidType("Water"), FluidType.getFluidType("Stone"), FluidType.getFluidType("Emerald"), FluidType.getFluidType("Quartz"), FluidType.getFluidType("Ender"), FluidType.getFluidType("Glass"), FluidType.getFluidType("Slime"), FluidType.getFluidType("Obsidian"));
        for (Map.Entry<String, FluidType> stringFluidTypeEntry : FluidType.fluidTypes.entrySet()) {
            FluidType ft = stringFluidTypeEntry.getValue();
            if (exceptions.contains(ft)) continue;
            String fluidTypeName = stringFluidTypeEntry.getKey();
            Smeltery.addDictionaryMelting("nugget" + fluidTypeName, ft, -100, 16);
            this.registerNuggetCasting(ft, "nugget" + fluidTypeName);
            this.registerIngotCasting(ft, "ingot" + fluidTypeName);
            Smeltery.addDictionaryMelting("ingot" + fluidTypeName, ft, -50, 144);
            Smeltery.addDictionaryMelting("dust" + fluidTypeName, ft, -75, 144);
            Smeltery.addDictionaryMelting("crystalline" + fluidTypeName, ft, -50, 144);
            Smeltery.addDictionaryMelting("ore" + fluidTypeName, ft, 0, (int)(144.0 * PHConstruct.ingotsPerOre));
            Smeltery.addDictionaryMelting("oreNether" + fluidTypeName, ft, 75, (int)(144.0 * PHConstruct.ingotsPerOre * 2.0));
            Smeltery.addDictionaryMelting("denseore" + fluidTypeName, ft, 75, (int)(144.0 * PHConstruct.ingotsPerOre * 3.0));
            Smeltery.addDictionaryMelting("orePoor" + fluidTypeName, ft, 75, (int)(16.0 * PHConstruct.ingotsPerOre));
            this.registerBlockCasting(ft, "block" + fluidTypeName);
            Smeltery.addDictionaryMelting("block" + fluidTypeName, ft, 100, 1296);
            if (!ft.isToolpart) continue;
            TinkerTools.registerPatternMaterial("ingot" + fluidTypeName, 2, fluidTypeName);
            TinkerTools.registerPatternMaterial("block" + fluidTypeName, 18, fluidTypeName);
        }
        FluidType ft = FluidType.getFluidType("Obsidian");
        String fluidTypeName = "Obsidian";
        Smeltery.addDictionaryMelting("nugget" + fluidTypeName, ft, -100, 16);
        this.registerNuggetCasting(ft, "nugget" + fluidTypeName);
        this.registerIngotCasting(ft, "ingot" + fluidTypeName);
        Smeltery.addDictionaryMelting("ingot" + fluidTypeName, ft, -50, 144);
        Smeltery.addDictionaryMelting("dust" + fluidTypeName, ft, -75, 36);
        Smeltery.addDictionaryMelting("crystalline" + fluidTypeName, ft, -50, 144);
        Smeltery.addDictionaryMelting("ore" + fluidTypeName, ft, 0, 144 * (int)PHConstruct.ingotsPerOre);
        Smeltery.addDictionaryMelting("orePoor" + fluidTypeName, ft, 0, (int)(16.0 * PHConstruct.ingotsPerOre * 1.5));
        Smeltery.addDictionaryMelting("oreNether" + fluidTypeName, ft, 75, 144 * (int)PHConstruct.ingotsPerOre * 2);
        Smeltery.addDictionaryMelting("block" + fluidTypeName, ft, 100, 288);
        if (ft.isToolpart) {
            TinkerTools.registerPatternMaterial("ingot" + fluidTypeName, 2, fluidTypeName);
            TinkerTools.registerPatternMaterial("block" + fluidTypeName, 18, fluidTypeName);
        }
        for (int i = 1; i <= 4; ++i) {
            Smeltery.addDictionaryMelting("compressedCobblestone" + i + "x", FluidType.getFluidType("Stone"), 0, 18 * (int)Math.pow(9.0, i));
        }
        Smeltery.addDictionaryMelting("compressedSand1x", FluidType.getFluidType("Glass"), 175, 9000);
        Smeltery.addDictionaryMelting("compressedSand2x", FluidType.getFluidType("Glass"), 175, 81000);
    }

    private void addRecipesForTableCasting() {
        ItemStack[] ingotShapes;
        ItemStack ingotcast = new ItemStack(metalPattern, 1, 0);
        ItemStack gemcast = new ItemStack(metalPattern, 1, 26);
        ItemStack ingotcast_clay = new ItemStack(clayPattern, 1, 0);
        ItemStack gemcast_clay = new ItemStack(clayPattern, 1, 26);
        LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
        tableCasting.addCastingRecipe(new ItemStack(TinkerTools.blankPattern, 1, 1), new FluidStack(moltenAlubrassFluid, 144), 80);
        tableCasting.addCastingRecipe(gemcast, new FluidStack(moltenAlubrassFluid, 144), new ItemStack(Items.field_151166_bC), 80);
        if (!PHConstruct.removeGoldCastRecipes) {
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.blankPattern, 1, 2), new FluidStack(moltenGoldFluid, 288), 80);
            tableCasting.addCastingRecipe(gemcast, new FluidStack(moltenGoldFluid, 288), new ItemStack(Items.field_151166_bC), 80);
        }
        tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 2), new FluidStack(moltenStoneFluid, 36), ingotcast, 80);
        tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 2), new FluidStack(moltenStoneFluid, 36), ingotcast_clay, true, 80);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151166_bC), new FluidStack(moltenEmeraldFluid, 640), gemcast, 80);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151128_bU), new FluidStack(moltenQuartzFluid, 250), gemcast, 50);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151166_bC), new FluidStack(moltenEmeraldFluid, 640), gemcast_clay, true, 80);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151128_bU), new FluidStack(moltenQuartzFluid, 250), gemcast_clay, true, 50);
        tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 36), new FluidStack(glueFluid, 144), null, 50);
        tableCasting.addCastingRecipe(new ItemStack(TinkerWorld.strangeFood, 1, 1), new FluidStack(bloodFluid, 160), null, 50);
        tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 43), new FluidStack(moltenSteelFluid, 288), new ItemStack(TinkerTools.largePlate, 1, 6), true, 80);
        ItemStack bucket = new ItemStack(Items.field_151133_ar);
        Item thermalBucket = GameRegistry.findItem((String)"ThermalFoundation", (String)"bucket");
        for (int sc = 0; sc < 26; ++sc) {
            if (fluids[sc] == null) continue;
            if (fluids[sc] == moltenEnderFluid && thermalBucket != null) {
                tableCasting.addCastingRecipe(new ItemStack(thermalBucket, 1, 2), new FluidStack(fluids[sc], 1000), bucket, true, 10);
                continue;
            }
            tableCasting.addCastingRecipe(new ItemStack(buckets, 1, sc), new FluidStack(fluids[sc], 1000), bucket, true, 10);
        }
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151131_as), new FluidStack(FluidRegistry.WATER, 1000), bucket, true, 10);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151129_at), new FluidStack(FluidRegistry.LAVA, 1000), bucket, true, 10);
        tableCasting.addCastingRecipe(new ItemStack(glassPane), new FluidStack(moltenGlassFluid, 250), null, 80);
        liquids = new FluidStack[]{new FluidStack(moltenIronFluid, 1), new FluidStack(moltenCopperFluid, 1), new FluidStack(moltenCobaltFluid, 1), new FluidStack(moltenArditeFluid, 1), new FluidStack(moltenManyullynFluid, 1), new FluidStack(moltenBronzeFluid, 1), new FluidStack(moltenAlumiteFluid, 1), new FluidStack(moltenObsidianFluid, 1), new FluidStack(moltenSteelFluid, 1), new FluidStack(pigIronFluid, 1)};
        int[] liquidDamage = new int[]{2, 13, 10, 11, 12, 14, 15, 6, 16, 18};
        for (int iter = 0; iter < TinkerTools.patternOutputs.length; ++iter) {
            if (TinkerTools.patternOutputs[iter] == null) continue;
            ItemStack[] cast = new ItemStack(metalPattern, 1, iter + 1);
            ItemStack clay_cast = new ItemStack(clayPattern, 1, iter + 1);
            tableCasting.addCastingRecipe((ItemStack)cast, new FluidStack(moltenAlubrassFluid, 144), new ItemStack(TinkerTools.patternOutputs[iter], 1, Short.MAX_VALUE), false, 50);
            if (!PHConstruct.removeGoldCastRecipes) {
                tableCasting.addCastingRecipe((ItemStack)cast, new FluidStack(moltenGoldFluid, 288), new ItemStack(TinkerTools.patternOutputs[iter], 1, Short.MAX_VALUE), false, 50);
            }
            for (int iterTwo = 0; iterTwo < liquids.length; ++iterTwo) {
                Fluid fs = liquids[iterTwo].getFluid();
                int fluidAmount = ((IPattern)metalPattern).getPatternCost((ItemStack)cast) * 144 / 2;
                ItemStack metalCast = new ItemStack(TinkerTools.patternOutputs[iter], 1, liquidDamage[iterTwo]);
                tableCasting.addCastingRecipe(metalCast, new FluidStack(fs, fluidAmount), (ItemStack)cast, 50);
                if (this.isValidClayCast(iter)) {
                    tableCasting.addCastingRecipe(metalCast, new FluidStack(fs, fluidAmount), clay_cast, true, 50);
                }
                Smeltery.addMelting(FluidType.getFluidType(fs), metalCast, 0, fluidAmount);
            }
        }
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151079_bi), new FluidStack(moltenEnderFluid, 250), new ItemStack(metalPattern, 1, 10), 50);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151079_bi), new FluidStack(moltenEnderFluid, 250), new ItemStack(metalPattern, 1, 26), 50);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151079_bi), new FluidStack(moltenEnderFluid, 250), new ItemStack(clayPattern, 1, 10), true, 50);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151079_bi), new FluidStack(moltenEnderFluid, 250), new ItemStack(clayPattern, 1, 18), true, 50);
        for (ItemStack ingotShape : ingotShapes = new ItemStack[]{new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151130_bT), new ItemStack(TinkerTools.materials, 1, 2), new ItemStack(TinkerTools.materials, 1, 37)}) {
            tableCasting.addCastingRecipe(ingotcast, new FluidStack(moltenAlubrassFluid, 144), ingotShape, false, 50);
            if (PHConstruct.removeGoldCastRecipes) continue;
            tableCasting.addCastingRecipe(ingotcast, new FluidStack(moltenGoldFluid, 288), ingotShape, false, 50);
        }
        ItemStack fullguardCast = new ItemStack(metalPattern, 1, 22);
        tableCasting.addCastingRecipe(fullguardCast, new FluidStack(moltenAlubrassFluid, 144), new ItemStack(TinkerTools.fullGuard, 1, Short.MAX_VALUE), false, 50);
        if (!PHConstruct.removeGoldCastRecipes) {
            tableCasting.addCastingRecipe(fullguardCast, new FluidStack(moltenGoldFluid, 288), new ItemStack(TinkerTools.fullGuard, 1, Short.MAX_VALUE), false, 50);
        }
        FluidStack goldAmount = new FluidStack(moltenGoldFluid, 128);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151150_bK, 1), goldAmount, new ItemStack(Items.field_151172_bF), true, 50);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151060_bw, 1), goldAmount, new ItemStack(Items.field_151127_ba), true, 50);
        goldAmount = new FluidStack(moltenGoldFluid, 1152);
        tableCasting.addCastingRecipe(new ItemStack(Items.field_151153_ao, 1), goldAmount, new ItemStack(Items.field_151034_e), true, 50);
        if (TinkerWorld.goldHead != null) {
            tableCasting.addCustomCastingRecipe(new CastingRecipe(new ItemStack(TinkerWorld.goldHead), goldAmount, new ItemStack(Items.field_151144_bL, 1, 3), true, 50, null, true));
        }
        if (PHConstruct.tconComesFirst && TinkerTools.materials != null) {
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 9), new FluidStack(moltenCopperFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 10), new FluidStack(moltenTinFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 11), new FluidStack(moltenAluminumFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 3), new FluidStack(moltenCobaltFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 4), new FluidStack(moltenArditeFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 5), new FluidStack(moltenManyullynFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 13), new FluidStack(moltenBronzeFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 14), new FluidStack(moltenAlubrassFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 15), new FluidStack(moltenAlumiteFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 16), new FluidStack(moltenSteelFluid, 144), ingotcast, false, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 9), new FluidStack(moltenCopperFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 10), new FluidStack(moltenTinFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 11), new FluidStack(moltenAluminumFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 3), new FluidStack(moltenCobaltFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 4), new FluidStack(moltenArditeFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 5), new FluidStack(moltenManyullynFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 13), new FluidStack(moltenBronzeFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 14), new FluidStack(moltenAlubrassFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 15), new FluidStack(moltenAlumiteFluid, 144), ingotcast_clay, true, 50);
            tableCasting.addCastingRecipe(new ItemStack(TinkerTools.materials, 1, 16), new FluidStack(moltenSteelFluid, 144), ingotcast_clay, true, 50);
        }
    }

    protected void addRecipesForBasinCasting() {
        LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150339_S), new FluidStack(moltenIronFluid, 1296), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150340_R), new FluidStack(moltenGoldFluid, 1296), null, true, 100);
        if (PHConstruct.tconComesFirst) {
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 3), new FluidStack(moltenCopperFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 5), new FluidStack(moltenTinFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 6), new FluidStack(moltenAluminumFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 0), new FluidStack(moltenCobaltFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 1), new FluidStack(moltenArditeFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 4), new FluidStack(moltenBronzeFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 7), new FluidStack(moltenAlubrassFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 2), new FluidStack(moltenManyullynFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 8), new FluidStack(moltenAlumiteFluid, 1296), null, true, 100);
            basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 9), new FluidStack(moltenSteelFluid, 1296), null, true, 100);
        }
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150343_Z), new FluidStack(moltenObsidianFluid, 288), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(clearGlass, 1, 0), new FluidStack(moltenGlassFluid, 1000), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(smeltery, 1, 4), new FluidStack(moltenStoneFluid, 144), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(smeltery, 1, 5), new FluidStack(moltenStoneFluid, 72), new ItemStack(Blocks.field_150347_e), true, 100);
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150475_bE), new FluidStack(moltenEmeraldFluid, 5760), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150371_ca), new FluidStack(moltenQuartzFluid, 1000), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(speedBlock, 1, 0), new FluidStack(moltenTinFluid, 16), new ItemStack(Blocks.field_150351_n), true, 100);
        if (PHConstruct.craftEndstone) {
            basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150377_bs), new FluidStack(moltenEnderFluid, 50), new ItemStack(Blocks.field_150343_Z), true, 100);
            basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150377_bs), new FluidStack(moltenEnderFluid, 250), new ItemStack(Blocks.field_150322_A), true, 100);
        }
        basinCasting.addCastingRecipe(new ItemStack(TinkerWorld.metalBlock, 1, 10), new FluidStack(moltenEnderFluid, 1000), null, true, 100);
        basinCasting.addCastingRecipe(new ItemStack(glueBlock), new FluidStack(glueFluid, 1296), null, true, 100);
    }

    protected static void addRecipesForSmeltery() {
        Smeltery.addSmelteryFuel(FluidRegistry.LAVA, 1300, 80);
        if (TinkerWorld.meatBlock != null) {
            Smeltery.addMelting(new ItemStack(Items.field_151078_bh), TinkerWorld.meatBlock, 0, 200, new FluidStack(bloodFluid, 5));
            Smeltery.addMelting(new ItemStack(TinkerWorld.strangeFood, 1, 1), TinkerWorld.meatBlock, 0, 80, new FluidStack(bloodFluid, 160));
        }
        Smeltery.addAlloyMixing(new FluidStack(moltenBronzeFluid, (int)(16.0 * PHConstruct.ingotsBronzeAlloy)), new FluidStack(moltenCopperFluid, 48), new FluidStack(moltenTinFluid, 16));
        Smeltery.addAlloyMixing(new FluidStack(moltenAlubrassFluid, (int)(16.0 * PHConstruct.ingotsAluminumBrassAlloy)), new FluidStack(moltenAluminumFluid, 48), new FluidStack(moltenCopperFluid, 16));
        Smeltery.addAlloyMixing(new FluidStack(moltenAlumiteFluid, (int)(16.0 * PHConstruct.ingotsAlumiteAlloy)), new FluidStack(moltenAluminumFluid, 80), new FluidStack(moltenIronFluid, 32), new FluidStack(moltenObsidianFluid, 32));
        Smeltery.addAlloyMixing(new FluidStack(moltenManyullynFluid, (int)(16.0 * PHConstruct.ingotsManyullynAlloy)), new FluidStack(moltenCobaltFluid, 16), new FluidStack(moltenArditeFluid, 16));
        Smeltery.addAlloyMixing(new FluidStack(pigIronFluid, (int)(144.0 * PHConstruct.ingotsPigironAlloy)), new FluidStack(moltenIronFluid, 144), new FluidStack(moltenEmeraldFluid, 640), new FluidStack(bloodFluid, 80));
        Smeltery.addAlloyMixing(new FluidStack(moltenObsidianFluid, 288), new FluidStack(FluidRegistry.LAVA, 1000), new FluidStack(FluidRegistry.WATER, 1000));
        FluidType stone = FluidType.getFluidType("Stone");
        for (int sc = 0; sc < TinkerTools.patternOutputs.length; ++sc) {
            if (TinkerTools.patternOutputs[sc] == null) continue;
            Smeltery.addMelting(stone, new ItemStack(TinkerTools.patternOutputs[sc], 1, 1), 1, 8 * ((IPattern)TinkerTools.woodPattern).getPatternCost(new ItemStack(TinkerTools.woodPattern, 1, sc + 1)) / 2);
        }
        FluidType iron = FluidType.getFluidType("Iron");
        FluidType gold = FluidType.getFluidType("Gold");
        FluidType steel = FluidType.getFluidType("Steel");
        Smeltery.addMelting(FluidType.getFluidType("Stone"), new ItemStack(TinkerTools.toolShard, 1, 1), 0, 4);
        Smeltery.addMelting(iron, new ItemStack(TinkerTools.toolShard, 1, 2), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Obsidian"), new ItemStack(TinkerTools.toolShard, 1, 6), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Cobalt"), new ItemStack(TinkerTools.toolShard, 1, 10), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Ardite"), new ItemStack(TinkerTools.toolShard, 1, 11), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Manyullyn"), new ItemStack(TinkerTools.toolShard, 1, 12), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Copper"), new ItemStack(TinkerTools.toolShard, 1, 13), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Bronze"), new ItemStack(TinkerTools.toolShard, 1, 14), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("Alumite"), new ItemStack(TinkerTools.toolShard, 1, 15), 0, 72);
        Smeltery.addMelting(steel, new ItemStack(TinkerTools.toolShard, 1, 16), 0, 72);
        Smeltery.addMelting(FluidType.getFluidType("AluminumBrass"), new ItemStack(TinkerTools.blankPattern, 4, 1), -50, 144);
        Smeltery.addMelting(gold, new ItemStack(TinkerTools.blankPattern, 4, 2), -50, 288);
        Smeltery.addMelting(FluidType.getFluidType("Glue"), new ItemStack(TinkerTools.materials, 1, 36), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("Ender"), new ItemStack(Items.field_151079_bi, 4), 0, 250);
        Smeltery.addMelting(TinkerWorld.metalBlock, 10, 50, new FluidStack(moltenEnderFluid, 1000));
        Smeltery.addMelting(FluidType.getFluidType("Water"), new ItemStack(Items.field_151126_ay, 1, 0), 0, 125);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151033_d, 1, 0), 0, 144);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151111_aL, 1, 0), 0, 576);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151133_ar), 0, 432);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151143_au), 0, 720);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151108_aI), 0, 720);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151109_aJ), 0, 720);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151140_bW), 50, 1440);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151139_aw), 0, 864);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151066_bu), 0, 1008);
        Smeltery.addMelting(iron, new ItemStack((Item)Items.field_151097_aZ), 0, 288);
        Smeltery.addMelting(FluidType.getFluidType("Emerald"), new ItemStack(Items.field_151166_bC), -50, 640);
        Smeltery.addMelting(FluidType.getFluidType("Quartz"), new ItemStack(Items.field_151128_bU), 0, 250);
        Smeltery.addMelting(FluidType.getFluidType("Ardite"), new ItemStack(TinkerTools.materials, 1, 38), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("Cobalt"), new ItemStack(TinkerTools.materials, 1, 39), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("Aluminum"), new ItemStack(TinkerTools.materials, 1, 40), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("Manyullyn"), new ItemStack(TinkerTools.materials, 1, 41), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("AluminumBrass"), new ItemStack(TinkerTools.materials, 1, 42), 0, 144);
        Smeltery.addMelting(Blocks.field_150366_p, 0, 600, new FluidStack(moltenIronFluid, 288));
        Smeltery.addMelting(Blocks.field_150352_o, 0, 400, new FluidStack(moltenGoldFluid, 288));
        Smeltery.addMelting(TinkerWorld.oreGravel, 0, 600, new FluidStack(moltenIronFluid, 288));
        Smeltery.addMelting(TinkerWorld.oreGravel, 1, 400, new FluidStack(moltenGoldFluid, 288));
        Smeltery.addMelting(Blocks.field_150339_S, 0, 600, new FluidStack(moltenIronFluid, 1296));
        Smeltery.addMelting(Blocks.field_150340_R, 0, 400, new FluidStack(moltenGoldFluid, 1296));
        Smeltery.addMelting(Blocks.field_150343_Z, 0, 800, new FluidStack(moltenObsidianFluid, 288));
        Smeltery.addMelting(Blocks.field_150432_aD, 0, 75, new FluidStack(FluidRegistry.getFluid((String)"water"), 1000));
        Smeltery.addMelting(Blocks.field_150433_aE, 0, 75, new FluidStack(FluidRegistry.getFluid((String)"water"), 500));
        Smeltery.addMelting(Blocks.field_150431_aC, 0, 75, new FluidStack(FluidRegistry.getFluid((String)"water"), 250));
        Smeltery.addMelting((Block)Blocks.field_150354_m, 0, 625, new FluidStack(moltenGlassFluid, 1000));
        Smeltery.addMelting(Blocks.field_150359_w, 0, 625, new FluidStack(moltenGlassFluid, 1000));
        Smeltery.addMelting(Blocks.field_150410_aZ, 0, 625, new FluidStack(moltenGlassFluid, 250));
        Smeltery.addMelting(Blocks.field_150348_b, 0, 800, new FluidStack(moltenStoneFluid, 18));
        Smeltery.addMelting(Blocks.field_150347_e, 0, 800, new FluidStack(moltenStoneFluid, 18));
        Smeltery.addMelting(Blocks.field_150475_bE, 0, 800, new FluidStack(moltenEmeraldFluid, 5760));
        Smeltery.addMelting(Blocks.field_150412_bA, 0, 800, new FluidStack(moltenEmeraldFluid, 1280));
        Smeltery.addMelting(Blocks.field_150371_ca, 0, 800, new FluidStack(moltenQuartzFluid, 1000));
        Smeltery.addMelting(Blocks.field_150449_bY, 0, 800, new FluidStack(moltenQuartzFluid, 500));
        Smeltery.addMelting(glueBlock, 0, 250, new FluidStack(glueFluid, 1296));
        Smeltery.addMelting(TinkerTools.craftedSoil, 1, 600, new FluidStack(moltenStoneFluid, 36));
        Smeltery.addMelting(clearGlass, 0, 500, new FluidStack(moltenGlassFluid, 1000));
        Smeltery.addMelting(glassPane, 0, 350, new FluidStack(moltenGlassFluid, 250));
        for (int i = 0; i < 16; ++i) {
            Smeltery.addMelting(stainedGlassClear, i, 500, new FluidStack(moltenGlassFluid, 1000));
            Smeltery.addMelting(stainedGlassClearPane, i, 350, new FluidStack(moltenGlassFluid, 250));
        }
        Smeltery.addMelting(TinkerTools.multiBrick, 4, 600, new FluidStack(moltenIronFluid, 144));
        Smeltery.addMelting(TinkerTools.multiBrickFancy, 4, 600, new FluidStack(moltenIronFluid, 144));
        Smeltery.addMelting(TinkerTools.multiBrick, 5, 400, new FluidStack(moltenGoldFluid, 144));
        Smeltery.addMelting(TinkerTools.multiBrickFancy, 5, 400, new FluidStack(moltenGoldFluid, 144));
        Smeltery.addMelting(TinkerTools.multiBrick, 0, 800, new FluidStack(moltenObsidianFluid, 288));
        Smeltery.addMelting(TinkerTools.multiBrickFancy, 0, 800, new FluidStack(moltenObsidianFluid, 288));
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150411_aY), 0, 54);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150443_bT), 0, 288);
        Smeltery.addMelting(gold, new ItemStack(Blocks.field_150445_bS, 4), 0, 288);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150448_aq), 0, 54);
        Smeltery.addMelting(gold, new ItemStack(Blocks.field_150318_D), 0, 144);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150319_E), 0, 144);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150408_cc), 0, 144);
        Smeltery.addMelting(FluidType.getFluidType("Obsidian"), new ItemStack(Blocks.field_150381_bn), 0, 576);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150467_bQ, 1, 0), 200, 4464);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150467_bQ, 1, 1), 200, 4464);
        Smeltery.addMelting(iron, new ItemStack(Blocks.field_150467_bQ, 1, 2), 200, 4464);
        Smeltery.addMelting(iron, new ItemStack((Block)Blocks.field_150438_bZ), 0, 720);
        Smeltery.addMelting(iron, new ItemStack((Item)Items.field_151028_Y, 1, 0), 50, 720);
        Smeltery.addMelting(iron, new ItemStack((Item)Items.field_151030_Z, 1, 0), 50, 1152);
        Smeltery.addMelting(iron, new ItemStack((Item)Items.field_151165_aa, 1, 0), 50, 1008);
        Smeltery.addMelting(iron, new ItemStack((Item)Items.field_151167_ab, 1, 0), 50, 576);
        Smeltery.addMelting(gold, new ItemStack((Item)Items.field_151169_ag, 1, 0), 50, 720);
        Smeltery.addMelting(gold, new ItemStack((Item)Items.field_151171_ah, 1, 0), 50, 1152);
        Smeltery.addMelting(gold, new ItemStack((Item)Items.field_151149_ai, 1, 0), 50, 1008);
        Smeltery.addMelting(gold, new ItemStack((Item)Items.field_151151_aj, 1, 0), 50, 576);
        Smeltery.addMelting(steel, new ItemStack((Item)Items.field_151020_U, 1, 0), 25, 144);
        Smeltery.addMelting(steel, new ItemStack((Item)Items.field_151023_V, 1, 0), 50, 288);
        Smeltery.addMelting(steel, new ItemStack((Item)Items.field_151022_W, 1, 0), 50, 288);
        Smeltery.addMelting(steel, new ItemStack((Item)Items.field_151029_X, 1, 0), 25, 144);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151138_bX, 1), 100, 1152);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151136_bY, 1), 100, 1152);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151019_K, 1, 0), 0, 288);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151040_l, 1, 0), 0, 288);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151037_a, 1, 0), 0, 144);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151035_b, 1, 0), 0, 432);
        Smeltery.addMelting(iron, new ItemStack(Items.field_151036_c, 1, 0), 0, 432);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151013_M, 1, 0), 0, 288);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151010_B, 1, 0), 0, 288);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151011_C, 1, 0), 0, 144);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151005_D, 1, 0), 0, 432);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151006_E, 1, 0), 0, 432);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151153_ao, 1, 0), 250, 1152);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151153_ao, 1, 1), 600, 10368);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151060_bw, 1, 0), -20, 128);
        Smeltery.addMelting(gold, new ItemStack(Items.field_151150_bK, 1, 0), -20, 128);
    }

    private void registerIngotCasting(FluidType ft, String name) {
        ItemStack pattern = new ItemStack(metalPattern, 1, 0);
        LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
        for (ItemStack ore : OreDictionary.getOres((String)name)) {
            tableCasting.addCastingRecipe(pattern, new FluidStack(moltenAlubrassFluid, 144), new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), false, 50);
            if (!PHConstruct.removeGoldCastRecipes) {
                tableCasting.addCastingRecipe(pattern, new FluidStack(moltenGoldFluid, 288), new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), false, 50);
            }
            tableCasting.addCastingRecipe(new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), new FluidStack(ft.fluid, 144), pattern, 80);
        }
    }

    private void registerNuggetCasting(FluidType ft, String name) {
        ItemStack pattern = new ItemStack(metalPattern, 1, 27);
        LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
        for (ItemStack ore : OreDictionary.getOres((String)name)) {
            if (ore.func_77973_b() != null && ore.func_77973_b() instanceof OreBerries) {
                boolean isOreberry = false;
                for (int id : OreDictionary.getOreIDs((ItemStack)ore)) {
                    if (!OreDictionary.getOreName((int)id).startsWith("oreberry")) continue;
                    isOreberry = true;
                }
                if (isOreberry) continue;
            }
            tableCasting.addCastingRecipe(pattern, new FluidStack(moltenAlubrassFluid, 144), new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), false, 50);
            if (!PHConstruct.removeGoldCastRecipes) {
                tableCasting.addCastingRecipe(pattern, new FluidStack(moltenGoldFluid, 288), new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), false, 50);
            }
            tableCasting.addCastingRecipe(new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), new FluidStack(ft.fluid, 16), pattern, 40);
        }
    }

    private void registerBlockCasting(FluidType ft, String name) {
        for (ItemStack ore : OreDictionary.getOres((String)name)) {
            TConstructRegistry.getBasinCasting().addCastingRecipe(new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j()), new FluidStack(ft.fluid, 1296), 100);
        }
    }

    public void addRecipesForFurnace() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(speedBlock, 1, 0), new ItemStack(speedBlock, 1, 2), 0.2f);
    }

    public void oreRegistry() {
        String[] glassTypes = new String[]{"glassBlack", "glassRed", "glassGreen", "glassBrown", "glassBlue", "glassPurple", "glassCyan", "glassLightGray", "glassGray", "glassPink", "glassLime", "glassYellow", "glassLightBlue", "glassMagenta", "glassOrange", "glassWhite"};
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)glassTypes[15 - i], (ItemStack)new ItemStack(stainedGlassClear, 1, i));
        }
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(clearGlass));
    }

    public void modIntegration() {
        Block taintedSoil = GameRegistry.findBlock((String)"Natura", (String)"soil.tainted");
        Block heatSand = GameRegistry.findBlock((String)"Natura", (String)"heatsand");
        if (taintedSoil != null && heatSand != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(TinkerTools.craftedSoil, 2, 6), (Object[])new Object[]{Items.field_151075_bm, taintedSoil, heatSand});
        }
        LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
        ArrayList ores = OreDictionary.getOres((String)"compressedGravel1x");
        if (ores.size() > 0) {
            basinCasting.addCastingRecipe(new ItemStack(speedBlock, 9), new FluidStack(moltenTinFluid, 144), (ItemStack)ores.get(0), true, 100);
            basinCasting.addCastingRecipe(new ItemStack(speedBlock, 9), new FluidStack(moltenElectrumFluid, 48), (ItemStack)ores.get(0), true, 100);
        }
        if ((ores = OreDictionary.getOres((String)"compressedGravel2x")).size() > 0) {
            basinCasting.addCastingRecipe(new ItemStack(speedBlock, 81), new FluidStack(moltenTinFluid, 1296), (ItemStack)ores.get(0), true, 100);
            basinCasting.addCastingRecipe(new ItemStack(speedBlock, 81), new FluidStack(moltenElectrumFluid, 432), (ItemStack)ores.get(0), true, 100);
        }
        if ((ores = OreDictionary.getOres((String)"itemRubber")).size() > 0) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 36), (ItemStack)ores.get(0), 0.2f);
        }
    }

    public static Fluid registerFluid(String name) {
        return TinkerSmeltery.registerFluid(name, "liquid_" + name);
    }

    public static Fluid registerFluid(String name, String texture) {
        return TinkerSmeltery.registerFluid(name, name + ".molten", "fluid.molten." + name, texture, 3000, 6000, 1300, Material.field_151587_i);
    }

    public static Fluid registerFluid(String name, String fluidName, String blockName, String texture, int density, int viscosity, int temperature, Material material) {
        Fluid fluid = new Fluid(fluidName).setDensity(density).setViscosity(viscosity).setTemperature(temperature);
        if (material == Material.field_151587_i) {
            fluid.setLuminosity(12);
        }
        boolean isFluidPreRegistered = !FluidRegistry.registerFluid((Fluid)fluid);
        TConstructFluid block = new TConstructFluid(fluid, material, texture);
        block.func_149663_c(blockName);
        GameRegistry.registerBlock((Block)block, (String)blockName);
        fluid.setBlock((Block)block);
        block.setFluid(fluid);
        if (isFluidPreRegistered) {
            fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid.getBlock() != null) {
                block.suppressOverwritingFluidIcons();
            } else {
                fluid.setBlock((Block)block);
            }
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            if (name.equals("aluminiumbrass")) {
                name = "alubrass";
            }
            if (name.equals("platinum")) {
                name = "shiny";
            }
            boolean reg = false;
            for (int i = 0; i < FilledBucket.textureNames.length; ++i) {
                if (!FilledBucket.textureNames[i].equals(name)) continue;
                FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluid, 1000), new ItemStack(buckets, 1, i), new ItemStack(Items.field_151133_ar)));
                reg = true;
            }
            if (!reg) {
                TConstruct.logger.error("Couldn't register fluid container for " + name);
            }
        }
        return fluid;
    }

    public boolean isValidClayCast(int meta) {
        return meta < 14 || meta == 22 || meta == 25;
    }

    static {
        fluids = new Fluid[26];
        fluidBlocks = new Block[25];
    }
}

