/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.gadgets.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import tconstruct.library.SlimeBounceHandler;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorPart;
import tconstruct.tools.entity.FancyEntityItem;

public class ItemSlimeBoots
extends ItemArmor
implements ISpecialArmor {
    public static ItemArmor.ArmorMaterial SLIME_MATERIAL = EnumHelper.addArmorMaterial((String)"SLIME", (int)100, (int[])new int[]{0, 0, 0, 0}, (int)0);
    public final ArmorPart armorPart;
    protected final String textureFolder;
    protected final String textureName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] modifiers;

    public ItemSlimeBoots() {
        super(SLIME_MATERIAL, 0, 3);
        this.func_77637_a(TConstructRegistry.gadgetsTab);
        this.func_77625_d(1);
        this.func_77656_e(100);
        ItemSlimeBoots.SLIME_MATERIAL.customCraftingMaterial = Items.field_151123_aH;
        this.armorPart = ArmorPart.Feet;
        this.textureFolder = "armor";
        this.textureName = "slime";
        SlimeBounceHandler.registerEvent((Object)this);
    }

    public boolean isValidArmor(ItemStack stack, int armorType1, Entity entity) {
        return armorType1 == 3;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        int slot = 1;
        ItemStack itemstack = playerIn.func_71124_b(slot);
        if (itemstack == null) {
            playerIn.func_70062_b(slot, itemStackIn.func_77946_l());
        } else {
            itemstack = itemstack.func_77946_l();
            playerIn.func_70062_b(1, itemStackIn.func_77946_l());
            playerIn.func_70099_a(itemstack, 0.0f);
        }
        --itemStackIn.field_77994_a;
        return itemStackIn;
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityLivingBase living = event.entityLiving;
        if (living == null || living.field_70143_R <= 2.0f) {
            return;
        }
        if (!SlimeBounceHandler.hasSlimeBoots(living)) {
            return;
        }
        if (living.func_70093_af()) {
            event.distance = 1.0f;
            return;
        }
        event.setCanceled(true);
        if (living.field_70170_p.field_72995_K) {
            living.func_85030_a("mob.slime.small", 1.0f, 1.0f);
            SlimeBounceHandler.addBounceHandler(living);
            return;
        }
        Vec3 motion = SlimeBounceHandler.getMotion(living);
        if (living instanceof EntityPlayerMP) {
            double gravity = 0.2353455252;
            double time = Math.sqrt((double)living.field_70143_R / gravity);
            double velocity = gravity * time;
            living.field_70159_w = motion.field_72450_a / (double)0.95f;
            living.field_70181_x = velocity;
            living.field_70179_y = motion.field_72449_c / (double)0.95f;
            living.field_70133_I = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            living.field_70159_w = motion.field_72450_a / (double)0.95f;
            living.field_70181_x = motion.field_72448_b * -0.9;
            living.field_70179_y = motion.field_72449_c / (double)0.95f;
            SlimeBounceHandler.addBounceHandler(living, SlimeBounceHandler.getMotion((EntityLivingBase)living).field_72448_b);
        }
        living.field_70160_al = true;
        living.field_70122_E = false;
        event.distance = 0.0f;
        living.func_85030_a("mob.slime.small", 1.0f, 1.0f);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "tinker:textures/armor/" + this.textureName + "_" + 1 + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("tinker:" + this.textureFolder + "/" + this.textureName + "_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)(armor.func_77960_j() / 100), 100);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1));
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Boooounce!");
        list.add("Hold " + I18n.func_135052_a((String)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151464_g(), (Object[])new Object[0]) + " to stop bouncing.");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new FancyEntityItem(world, location, itemstack);
    }
}

