/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.util.Reference;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.entity.BoltEntity;

public class Crossbow
extends ProjectileWeapon {
    public Crossbow() {
        super(0, "Crossbow");
        this.func_77656_e(100);
    }

    public boolean isLoaded(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return this.isLoaded(itemStack.func_77978_p().func_74775_l("InfiTool"));
        }
        return false;
    }

    public boolean isLoaded(NBTTagCompound tags) {
        return tags.func_74767_n("Loaded");
    }

    public ItemStack getLoadedAmmo(ItemStack itemStack) {
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (!this.isLoaded(tags)) {
            return null;
        }
        ItemStack ammo = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("LoadedItem"));
        if (ammo != null && ammo.func_77973_b() != null && ammo.func_77973_b() != TinkerWeaponry.boltAmmo) {
            tags.func_82580_o("LoadedItem");
            ammo = null;
        }
        return ammo;
    }

    @Override
    public float getMinWindupProgress(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (player.func_70093_af() && this.unload(stack, player, tags)) {
            return stack;
        }
        if (tags.func_74767_n("Loaded")) {
            this.fire(stack, world, player);
        }
        this.initiateReload(stack, player, tags);
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(stack, world, entity, par4, par5);
        if (!stack.func_77942_o()) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71071_by.func_70448_g() != stack) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b("Reloading")) {
            int timeLeft = tags.func_74762_e("Reloading");
            if (--timeLeft > 0) {
                tags.func_74768_a("Reloading", timeLeft);
            } else {
                tags.func_82580_o("Reloading");
                this.reload(stack, player, world, tags);
            }
        }
    }

    @Override
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Loaded")) {
            return 1.0f;
        }
        if (tags.func_74764_b("Reloading")) {
            return 1.0f - (float)tags.func_74762_e("Reloading") / (float)this.getWindupTime(itemStack);
        }
        return 0.0f;
    }

    public void initiateReload(ItemStack stack, EntityPlayer player, NBTTagCompound tags) {
        if (tags.func_74767_n("Broken")) {
            return;
        }
        if (this.searchForAmmo(player, stack) != null && !tags.func_74764_b("Reloading")) {
            tags.func_74768_a("Reloading", this.getWindupTime(stack));
        }
    }

    public boolean reload(ItemStack weapon, EntityPlayer player, World world, NBTTagCompound tags) {
        ItemStack ammo = this.searchForAmmo(player, weapon);
        if (ammo == null) {
            return false;
        }
        if (tags.func_74767_n("Loaded")) {
            return false;
        }
        ItemStack copy = ammo.func_77946_l();
        copy.func_77978_p().func_74775_l("InfiTool").func_74768_a("Ammo", 1);
        NBTTagCompound ammotag = new NBTTagCompound();
        copy.func_77955_b(ammotag);
        tags.func_74782_a("LoadedItem", (NBTBase)ammotag);
        tags.func_74757_a("Loaded", true);
        if (ammo.func_77973_b() instanceof IAmmo) {
            ((IAmmo)ammo.func_77973_b()).consumeAmmo(1, ammo);
        } else if (Loader.isModLoaded((String)"battlegear2")) {
            ((InventoryPlayerBattle)player.field_71071_by).func_146026_a(ammo.func_77973_b());
        } else {
            player.field_71071_by.func_146026_a(ammo.func_77973_b());
        }
        this.playReloadSound(world, player, weapon, ammo);
        return true;
    }

    public boolean unload(ItemStack weapon, EntityPlayer player, NBTTagCompound tags) {
        if (tags.func_74764_b("Reloading")) {
            tags.func_82580_o("Reloading");
            return true;
        }
        if (tags.func_74767_n("Loaded")) {
            ItemStack loadedItem = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("LoadedItem"));
            AmmoItem ammo = (AmmoItem)loadedItem.func_77973_b();
            ammo.pickupAmmo(loadedItem, this.searchForAmmo(player, weapon), player);
            tags.func_74757_a("Loaded", false);
            tags.func_82580_o("LoadedItem");
            return true;
        }
        return false;
    }

    public void fire(ItemStack weapon, World world, EntityPlayer player) {
        NBTTagCompound tags = weapon.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74767_n("Loaded")) {
            return;
        }
        ItemStack ammo = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("LoadedItem"));
        tags.func_74757_a("Loaded", false);
        tags.func_82580_o("LoadedItem");
        if (ammo == null) {
            return;
        }
        float projectileSpeed = this.getProjectileSpeed(weapon);
        float windup = this.getWindupTime(weapon);
        float accuracy = this.getAccuracy(weapon, (int)windup);
        Entity projectile = this.createProjectile(ammo, world, player, projectileSpeed, accuracy, 1.0f);
        int reinforced = 0;
        if (tags.func_74764_b("Unbreaking")) {
            reinforced = tags.func_74762_e("Unbreaking");
        }
        if (this.random.nextInt(10) < 10 - reinforced) {
            AbilityHelper.damageTool(weapon, 1, (EntityLivingBase)player, false);
        }
        this.playFiringSound(world, player, weapon, ammo, projectileSpeed, accuracy);
        if (!world.field_72995_K) {
            world.func_72838_d(projectile);
        }
    }

    @Override
    public ItemStack searchForAmmo(EntityPlayer player, ItemStack weapon) {
        ItemStack offhand;
        if (Loader.isModLoaded((String)"battlegear2") && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null && offhand.func_77973_b() instanceof BoltAmmo && ((IAmmo)offhand.func_77973_b()).getAmmoCount(offhand) > 0) {
            return offhand;
        }
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack stack = inventory[i];
            if (stack == null || !(stack.func_77973_b() instanceof BoltAmmo) || ((IAmmo)stack.func_77973_b()).getAmmoCount(stack) <= 0) continue;
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d && TinkerWeaponry.creativeBolt != null) {
            return TinkerWeaponry.creativeBolt.func_77946_l();
        }
        return null;
    }

    @Override
    protected Entity createProjectile(ItemStack ammo, World world, EntityPlayer player, float speed, float accuracy, float windup) {
        ItemStack reference = ammo.func_77946_l();
        reference.field_77994_a = 1;
        reference.func_77978_p().func_74775_l("InfiTool").func_74768_a("Ammo", 1);
        BoltEntity arrow = new BoltEntity(world, player, speed, accuracy, reference);
        if (player.field_71075_bZ.field_75098_d) {
            arrow.field_70251_a = 2;
        }
        return arrow;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 0.0f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 0.0f;
    }

    public void playReloadSound(World world, EntityPlayer player, ItemStack weapon, ItemStack ammo) {
        world.func_72956_a((Entity)player, Reference.resource("crossbowReload"), 1.0f, 1.0f);
    }

    @Override
    public void playFiringSound(World world, EntityPlayer player, ItemStack weapon, ItemStack ammo, float speed, float accuracy) {
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 0.5f);
    }

    @Override
    public IIcon getIcon(ItemStack stack, int renderPass) {
        float progress;
        if (!this.animateLayer(renderPass) && renderPass < this.getPartAmount()) {
            return super.getIcon(stack, renderPass);
        }
        if (!stack.func_77942_o()) {
            return super.getIcon(stack, renderPass);
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags == null || renderPass > 10) {
            return super.getIcon(stack, renderPass);
        }
        if (tags.func_74767_n("Loaded")) {
            progress = 1.0f;
        } else {
            if (!tags.func_74764_b("Reloading")) {
                return super.getIcon(stack, renderPass);
            }
            progress = this.getWindupProgress(stack, this.getWindupTime(stack) - tags.func_74762_e("Reloading"));
        }
        if (renderPass >= this.getPartAmount()) {
            String effect = "Effect" + (1 + renderPass - this.getPartAmount());
            if (tags.func_74764_b(effect)) {
                int index = tags.func_74762_e(effect);
                if (this.animationEffectIcons.get(index) != null) {
                    return this.getCorrectAnimationIcon(this.animationEffectIcons, index, progress);
                }
                return (IIcon)this.effectIcons.get(index);
            }
            return super.getIcon(stack, renderPass);
        }
        switch (renderPass) {
            case 0: {
                return this.getCorrectAnimationIcon(this.animationHandleIcons, tags.func_74762_e("RenderHandle"), progress);
            }
            case 1: {
                return this.getCorrectAnimationIcon(this.animationHeadIcons, tags.func_74762_e("RenderHead"), progress);
            }
            case 2: {
                return this.getCorrectAnimationIcon(this.animationAccessoryIcons, tags.func_74762_e("RenderAccessory"), progress);
            }
            case 3: {
                return this.getCorrectAnimationIcon(this.animationExtraIcons, tags.func_74762_e("RenderExtra"), progress);
            }
        }
        return emptyIcon;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_crossbow_bow";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_crossbow_body";
            }
            case 3: {
                return "_crossbow_string";
            }
            case 4: {
                return "_crossbow_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_crossbow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "crossbow";
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    protected boolean animateLayer(int renderPass) {
        return renderPass == 1 || renderPass == 2;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partCrossbowLimb;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partCrossbowBody;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.bowstring;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "bow", "windup"};
    }

    @Override
    public void buildTool(int id, String name, List list) {
        ItemStack extraStack;
        ItemStack accessoryStack;
        ItemStack handleStack;
        if (TConstructRegistry.getBowMaterial(id) == null) {
            return;
        }
        ItemStack headStack = new ItemStack(this.getHeadItem(), 1, id);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(this.getHandleItem(), 1, id), accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0), extraStack = this.getPartAmount() > 3 ? new ItemStack(this.getExtraItem(), 1, id) : null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass != 2 || !stack.func_77942_o()) {
            return super.func_82790_a(stack, renderPass);
        }
        int mat = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Accessory");
        switch (mat) {
            case 0: {
                return -1;
            }
            case 1: {
                return -3355393;
            }
            case 2: {
                return -13108;
            }
        }
        return super.func_82790_a(stack, renderPass);
    }
}

