/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public abstract class RecipeHandlerBase
extends TemplateRecipeHandler {
    public abstract String getRecipeID();

    public void loadCraftingRecipes(FluidStack result) {
    }

    public void loadUsageRecipes(FluidStack ingredient) {
    }

    public void drawForeground(int recipe) {
        super.drawForeground(recipe);
        this.drawFluidTanks(recipe);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        try {
            if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof FluidStack) {
                this.loadCraftingRecipes((FluidStack)results[0]);
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack fluid = RecipeHandlerBase.getFluidStack(result);
        if (fluid != null) {
            this.loadCraftingRecipes(fluid);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        try {
            if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
                this.loadUsageRecipes((FluidStack)ingredients[0]);
            } else {
                super.loadUsageRecipes(inputId, ingredients);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        FluidStack fluid = RecipeHandlerBase.getFluidStack(ingred);
        if (fluid != null) {
            this.loadUsageRecipes(fluid);
        }
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - guiRecipe.field_147003_i - offset.x, mouse.y - guiRecipe.field_147009_r - offset.y);
            if (crecipe.getFluidTanks() != null) {
                for (FluidTankElement tank : crecipe.getFluidTanks()) {
                    if (!tank.position.contains(relMouse)) continue;
                    tank.handleTooltip(currenttip);
                }
            }
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferFluidTank(gui, recipe, false) : button == 1 && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    protected boolean transferFluidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        Point mouse = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - guiRecipe.field_147003_i - offset.x, mouse.y - guiRecipe.field_147009_r - offset.y);
        if (crecipe.getFluidTanks() != null) {
            for (FluidTankElement tank : crecipe.getFluidTanks()) {
                if (!tank.position.contains(relMouse) || tank.fluid == null || tank.fluid.amount <= 0) continue;
                return !(usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.fluid}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.fluid}));
            }
        }
        return false;
    }

    public void drawFluidTanks(int recipe) {
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        if (crecipe.getFluidTanks() != null) {
            for (FluidTankElement fluidTank : crecipe.getFluidTanks()) {
                fluidTank.draw();
            }
        }
    }

    public static List getSingleList(Object o) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        return list;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        Fluid fluid;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        FluidStack fluidStack = null;
        if (item instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)item).getFluid(stack);
        }
        if (fluidStack == null) {
            fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        }
        if (fluidStack == null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
            return new FluidStack(fluid, 1000);
        }
        return fluidStack;
    }

    public static boolean areFluidsEqual(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null || fluidStack2 == null) {
            return false;
        }
        return fluidStack1.isFluidEqual(fluidStack2);
    }

    public static class FluidTankElement {
        public Rectangle position;
        public FluidStack fluid;
        public int capacity;
        public boolean flowingTexture = false;

        public FluidTankElement(Rectangle position, int capacity, FluidStack fluid) {
            this.position = position;
            this.capacity = capacity;
            this.fluid = fluid;
        }

        public List<String> handleTooltip(List<String> currenttip) {
            if (this.fluid == null || this.fluid.getFluid() == null || this.fluid.amount <= 0) {
                return currenttip;
            }
            currenttip.add(this.fluid.getLocalizedName());
            currenttip.add(EnumChatFormatting.GRAY.toString() + this.fluid.amount + " mB");
            return currenttip;
        }

        public void draw() {
            if (this.fluid == null || this.fluid.getFluid() == null || this.fluid.amount <= 0) {
                return;
            }
            IIcon fluidIcon = null;
            if (this.flowingTexture && this.fluid.getFluid().getFlowingIcon() != null) {
                fluidIcon = this.fluid.getFluid().getFlowingIcon();
            } else if (this.fluid.getFluid().getStillIcon() != null) {
                fluidIcon = this.fluid.getFluid().getStillIcon();
            } else {
                return;
            }
            GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
            int color = this.fluid.getFluid().getColor(this.fluid);
            GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            GL11.glDisable((int)3042);
            int amount = Math.max(Math.min(this.position.height, this.fluid.amount * this.position.height / this.capacity), 1);
            int posY = this.position.y + this.position.height - amount;
            for (int i = 0; i < this.position.width; i += 16) {
                for (int j = 0; j < amount; j += 16) {
                    int drawWidth = Math.min(this.position.width - i, 16);
                    int drawHeight = Math.min(amount - j, 16);
                    int drawX = this.position.x + i;
                    int drawY = posY + j;
                    double minU = fluidIcon.func_94209_e();
                    double maxU = fluidIcon.func_94212_f();
                    double minV = fluidIcon.func_94206_g();
                    double maxV = fluidIcon.func_94210_h();
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                    tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                    tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                    tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                    tessellator.func_78381_a();
                }
            }
            GL11.glEnable((int)3042);
        }
    }

    public abstract class CachedBaseRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public CachedBaseRecipe() {
            super((TemplateRecipeHandler)RecipeHandlerBase.this);
        }

        public List<FluidTankElement> getFluidTanks() {
            return null;
        }
    }
}

