/*
 * Decompiled with CFR 0.152.
 */
package tconstruct;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mantle.pulsar.config.ForgeCFG;
import mantle.pulsar.config.IConfiguration;
import mantle.pulsar.control.PulseManager;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tconstruct.achievements.AchievementEvents;
import tconstruct.achievements.TAchievements;
import tconstruct.api.TConstructAPI;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.player.TPlayerHandler;
import tconstruct.common.TProxyCommon;
import tconstruct.gadgets.TinkerGadgets;
import tconstruct.library.SlimeBounceHandler;
import tconstruct.library.TConstructCreativeTab;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.mechworks.TinkerMechworks;
import tconstruct.mechworks.landmine.behavior.Behavior;
import tconstruct.mechworks.landmine.behavior.stackCombo.SpecialStackHandler;
import tconstruct.plugins.TinkerThaumcraft;
import tconstruct.plugins.fmp.TinkerFMP;
import tconstruct.plugins.gears.TinkerGears;
import tconstruct.plugins.ic2.TinkerIC2;
import tconstruct.plugins.imc.TinkerAE2;
import tconstruct.plugins.imc.TinkerBuildCraft;
import tconstruct.plugins.imc.TinkerMystcraft;
import tconstruct.plugins.imc.TinkerRfTools;
import tconstruct.plugins.mfr.TinkerMFR;
import tconstruct.plugins.te4.TinkerTE4;
import tconstruct.plugins.te4.TinkersThermalFoundation;
import tconstruct.plugins.ubc.TinkerUBC;
import tconstruct.plugins.waila.TinkerWaila;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.util.EnvironmentChecks;
import tconstruct.util.IMCHandler;
import tconstruct.util.config.DimensionBlacklist;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.network.PacketPipeline;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.world.TinkerWorld;
import tconstruct.world.gen.SlimeIslandGen;
import tconstruct.world.village.ComponentSmeltery;
import tconstruct.world.village.ComponentToolWorkshop;
import tconstruct.world.village.TVillageTrades;
import tconstruct.world.village.VillageSmelteryHandler;
import tconstruct.world.village.VillageToolStationHandler;

@Mod(modid="TConstruct", name="TConstruct", version="1.7.10-1.9.0.14-GTNH", dependencies="required-after:Forge@[10.13.3.1384,11.14);required-after:Mantle@[0.3.2,1.7.10),[1.7.10-0.3.2,);after:MineFactoryReloaded@[1.7.10R2.8.0RC7,);after:ThermalExpansion@[1.7.10R4.0.0RC2,);after:ThermalFoundation@[1.7.10R1.0.0RC3,);after:armourersWorkshop@[1.7.10-0.28.0,);after:CoFHAPI|energy;after:CoFHCore;after:battlegear2;after:ZeldaItemAPI;after:DynamicSkillsAPI;after:NotEnoughItems;after:Waila;before:GalacticraftCore;before:UndergroundBiomes")
public class TConstruct {
    public static final String modVersion = "1.7.10-1.9.0.14-GTNH";
    public static final int ingotLiquidValue = 144;
    public static final int oreLiquidValue = 288;
    public static final int blockLiquidValue = 1296;
    public static final int chunkLiquidValue = 72;
    public static final int nuggetLiquidValue = 16;
    public static final int stoneLiquidValue = 18;
    public static final int liquidUpdateAmount = 6;
    public static final String modID = "TConstruct";
    public static final Logger logger = LogManager.getLogger((String)"TConstruct");
    public static final PacketPipeline packetPipeline = new PacketPipeline();
    public static Random random = new Random();
    @Mod.Instance(value="TConstruct")
    public static TConstruct instance;
    @SidedProxy(clientSide="tconstruct.client.TProxyClient", serverSide="tconstruct.common.TProxyCommon")
    public static TProxyCommon proxy;
    public static PulseManager pulsar;
    public static TPlayerHandler playerTracker;
    public static LiquidCasting tableCasting;
    public static LiquidCasting basinCasting;
    public static Detailing chiselDetailing;

    public TConstruct() {
        if (Loader.isModLoaded((String)"Natura")) {
            logger.info("Natura, what are we going to do tomorrow night?");
            LogManager.getLogger((String)"Natura").info("TConstruct, we're going to take over the world!");
        } else {
            logger.info("Preparing to take over the world");
        }
        EnvironmentChecks.verifyEnvironmentSanity();
    }

    @NetworkCheckHandler
    public boolean matchModVersions(Map<String, String> remoteVersions, Side side) {
        return remoteVersions.containsKey(modID) && modVersion.equals(remoteVersions.get(modID));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PHConstruct.initProps(event.getModConfigurationDirectory());
        pulsar.registerPulse((Object)new TinkerWorld());
        pulsar.registerPulse((Object)new TinkerTools());
        pulsar.registerPulse((Object)new TinkerSmeltery());
        pulsar.registerPulse((Object)new TinkerMechworks());
        pulsar.registerPulse((Object)new TinkerArmor());
        pulsar.registerPulse((Object)new TinkerWeaponry());
        pulsar.registerPulse((Object)new TinkerGadgets());
        pulsar.registerPulse((Object)new TinkerThaumcraft());
        pulsar.registerPulse((Object)new TinkerWaila());
        pulsar.registerPulse((Object)new TinkerBuildCraft());
        pulsar.registerPulse((Object)new TinkerAE2());
        pulsar.registerPulse((Object)new TinkerIC2());
        pulsar.registerPulse((Object)new TinkerMystcraft());
        pulsar.registerPulse((Object)new TinkerMFR());
        pulsar.registerPulse((Object)new TinkerTE4());
        pulsar.registerPulse((Object)new TinkersThermalFoundation());
        pulsar.registerPulse((Object)new TinkerFMP());
        pulsar.registerPulse((Object)new TinkerUBC());
        pulsar.registerPulse((Object)new TinkerGears());
        pulsar.registerPulse((Object)new TinkerRfTools());
        TConstructRegistry.materialTab = new TConstructCreativeTab("TConstructMaterials");
        TConstructRegistry.toolTab = new TConstructCreativeTab("TConstructTools");
        TConstructRegistry.partTab = new TConstructCreativeTab("TConstructParts");
        TConstructRegistry.blockTab = new TConstructCreativeTab("TConstructBlocks");
        TConstructRegistry.equipableTab = new TConstructCreativeTab("TConstructEquipables");
        TConstructRegistry.weaponryTab = new TConstructCreativeTab("TConstructWeaponry");
        TConstructRegistry.gadgetsTab = new TConstructCreativeTab("TConstructGadgets");
        tableCasting = new LiquidCasting();
        basinCasting = new LiquidCasting();
        chiselDetailing = new Detailing();
        playerTracker = new TPlayerHandler();
        FMLCommonHandler.instance().bus().register((Object)playerTracker);
        MinecraftForge.EVENT_BUS.register((Object)playerTracker);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        pulsar.preInit(event);
        if (PHConstruct.achievementsEnabled) {
            TAchievements.addDefaultAchievements();
        }
        if (PHConstruct.addToVillages) {
            VillagerRegistry.instance().registerVillagerId(78943);
            if (PHConstruct.allowVillagerTrading) {
                VillagerRegistry.instance().registerVillageTradeHandler(78943, (VillagerRegistry.IVillageTradeHandler)new TVillageTrades());
            }
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageToolStationHandler());
            MapGenStructureIO.func_143031_a(ComponentToolWorkshop.class, (String)"TConstruct:ToolWorkshopStructure");
            if (pulsar.isPulseLoaded("Tinkers' Smeltery")) {
                VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageSmelteryHandler());
                MapGenStructureIO.func_143031_a(ComponentSmeltery.class, (String)"TConstruct:SmelteryStructure");
            }
        }
        TConstructAPI.PROP_NAME = modID;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initalise();
        if (event.getSide() == Side.CLIENT) {
            // empty if block
        }
        DimensionBlacklist.getBadBimensions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new SlimeIslandGen(TinkerWorld.slimePool, 2), (int)2);
        pulsar.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
        Behavior.registerBuiltInBehaviors();
        SpecialStackHandler.registerBuiltInStackHandlers();
        proxy.initialize();
        pulsar.postInit(event);
        if (PHConstruct.achievementsEnabled) {
            TAchievements.registerAchievementPane();
            MinecraftForge.EVENT_BUS.register((Object)new AchievementEvents());
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        TinkerGadgets.log.info("Cleaning up SlimeBounceHandler data.");
        SlimeBounceHandler.BOUNCING_ENTITIES.clear();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent e) {
        IMCHandler.processIMC((List<FMLInterModComms.IMCMessage>)e.getMessages());
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent evt) {
        IMCHandler.processIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
    }

    public static LiquidCasting getTableCasting() {
        return tableCasting;
    }

    public static LiquidCasting getBasinCasting() {
        return basinCasting;
    }

    public static Detailing getChiselDetailing() {
        return chiselDetailing;
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.equals("TConstruct:TankAir")) continue;
            mapping.ignore();
        }
    }

    static {
        pulsar = new PulseManager(modID, (IConfiguration)new ForgeCFG("TinkersModules", "Modules: Disabling these will disable a chunk of the mod"));
    }
}

