/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import java.lang.ref.WeakReference;
import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import tconstruct.tools.inventory.CraftingStationContainer;
import tconstruct.tools.logic.FurnaceLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.ToolStationLogic;

public class CraftingStationLogic
extends InventoryLogic
implements ISidedInventory {
    public WeakReference<IInventory> chest;
    public WeakReference<IInventory> doubleChest;
    public WeakReference<IInventory> patternChest;
    public WeakReference<IInventory> furnace;
    public boolean tinkerTable;
    public boolean stencilTable;
    public boolean doubleFirst;

    public CraftingStationLogic() {
        super(10);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        this.chest = null;
        this.doubleChest = null;
        this.patternChest = null;
        this.furnace = null;
        this.tinkerTable = false;
        int[] ys = new int[]{y, y - 1, y + 1};
        for (int iy = 0; iy < 3; iy = (int)((byte)(iy + 1))) {
            int yPos = ys[iy];
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    TileEntity tile = world.func_147438_o(xPos, yPos, zPos);
                    if (this.chest == null && tile instanceof TileEntityChest) {
                        this.chest = new WeakReference<TileEntity>(tile);
                        this.checkForChest(world, xPos, yPos, zPos, 1, 0);
                        this.checkForChest(world, xPos, yPos, zPos, -1, 0);
                        this.checkForChest(world, xPos, yPos, zPos, 0, 1);
                        this.checkForChest(world, xPos, yPos, zPos, 0, -1);
                        continue;
                    }
                    if (this.patternChest == null && tile instanceof PatternChestLogic) {
                        this.patternChest = new WeakReference<TileEntity>(tile);
                        continue;
                    }
                    if (this.furnace == null && (tile instanceof TileEntityFurnace || tile instanceof FurnaceLogic)) {
                        this.furnace = new WeakReference<TileEntity>(tile);
                        continue;
                    }
                    if (this.tinkerTable || !(tile instanceof ToolStationLogic)) continue;
                    this.tinkerTable = true;
                }
            }
        }
        return new CraftingStationContainer(inventoryplayer, this, x, y, z);
    }

    void checkForChest(World world, int x, int y, int z, int dx, int dz) {
        TileEntity tile = world.func_147438_o(x + dx, y, z + dz);
        if (tile instanceof TileEntityChest) {
            this.doubleChest = new WeakReference<TileEntity>(tile);
            this.doubleFirst = dx + dz < 0;
        }
    }

    protected String getDefaultName() {
        return "crafters.CraftingStation";
    }

    public boolean canDropInventorySlot(int slot) {
        return slot != 0;
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_70300_a(EntityPlayer player) {
        return CraftingStationLogic.isUseableByPlayer(player, this.getInventories()) && super.func_70300_a(player);
    }

    public static boolean isUseableByPlayer(EntityPlayer player, WeakReference[] inventories) {
        for (WeakReference ref : inventories) {
            IInventory inv;
            if (ref == null || (inv = (IInventory)ref.get()) == null || inv.func_70300_a(player)) continue;
            return false;
        }
        return true;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (slot == 0) {
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                this.func_70298_a(i, 1);
            }
        }
        return super.func_70298_a(slot, quantity);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public String func_145825_b() {
        return this.getDefaultName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public WeakReference[] getInventories() {
        return new WeakReference[]{this.chest, this.doubleChest, this.patternChest, this.furnace};
    }

    public boolean canUpdate() {
        return false;
    }
}

