/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.client.ToolGuiElement;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.tools.gui.GuiButtonTool;
import tconstruct.tools.gui.ToolStationGuiHelper;
import tconstruct.tools.inventory.ToolStationContainer;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.util.network.ToolStationPacket;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class ToolStationGui
extends GuiContainer
implements INEIGuiHandler {
    public ToolStationLogic logic;
    public ToolStationContainer toolSlots;
    public GuiTextField text;
    public String toolName;
    public int guiType;
    public int[] slotX;
    public int[] slotY;
    public int[] iconX;
    public int[] iconY;
    public boolean active;
    public String title;
    public String body = "";
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/toolstation.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");

    public ToolStationGui(InventoryPlayer inventoryplayer, ToolStationLogic stationlogic, World world, int x, int y, int z) {
        super((Container)((ActiveContainer)stationlogic.getGuiContainer(inventoryplayer, world, x, y, z)));
        this.logic = stationlogic;
        this.toolSlots = (ToolStationContainer)this.field_147002_h;
        this.text = new GuiTextField(this.field_146289_q, 83, 8, 30, 12);
        this.text.func_146203_f(40);
        this.text.func_146185_a(false);
        this.text.func_146189_e(true);
        this.text.func_146205_d(false);
        this.text.func_146195_b(true);
        this.text.func_146193_g(0xFFFFFF);
        this.toolName = "";
        this.resetGui();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int gLeft = this.field_147003_i + 68 + 110;
            int gTop = this.field_147009_r + 6;
            int gwidth = 102;
            int gheight = 12;
            this.active = mouseX > gLeft && mouseX < gLeft + gwidth && mouseY > gTop && mouseY < gTop + gheight;
        }
    }

    void resetGui() {
        this.text.func_146180_a("");
        this.guiType = 0;
        this.setSlotType(0);
        this.iconX = new int[]{0, 1, 2};
        this.iconY = new int[]{13, 13, 13};
        this.title = "\u00a7n" + StatCollector.func_74838_a((String)"gui.toolforge1");
        this.body = StatCollector.func_74838_a((String)"gui.toolforge2");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 286;
        this.field_147003_i = (this.field_146294_l - 176) / 2 - 110;
        this.field_146292_n.clear();
        ToolGuiElement repair = TConstructClientRegistry.toolButtons.get(0);
        GuiButtonTool repairButton = new GuiButtonTool(0, this.field_147003_i, this.field_147009_r, repair.buttonIconX, repair.buttonIconY, repair.domain, repair.texture, repair);
        repairButton.field_146124_l = false;
        this.field_146292_n.add(repairButton);
        for (int iter = 1; iter < TConstructClientRegistry.toolButtons.size(); ++iter) {
            ToolGuiElement element = TConstructClientRegistry.toolButtons.get(iter);
            GuiButtonTool button = new GuiButtonTool(iter, this.field_147003_i + 22 * (iter % 5), this.field_147009_r + 22 * (iter / 5), element.buttonIconX, element.buttonIconY, repair.domain, element.texture, element);
            this.field_146292_n.add(button);
        }
    }

    protected void func_146284_a(GuiButton button) {
        ((GuiButton)this.field_146292_n.get((int)this.guiType)).field_146124_l = true;
        this.guiType = button.field_146127_k;
        button.field_146124_l = false;
        ToolGuiElement element = TConstructClientRegistry.toolButtons.get(this.guiType);
        this.setSlotType(element.slotType);
        this.iconX = element.iconsX;
        this.iconY = element.iconsY;
        this.title = "\u00a7n" + element.title;
        this.body = StatCollector.func_74838_a((String)element.body);
        if (this.body != null) {
            int i;
            while ((i = this.body.indexOf("\\n")) >= 0) {
                this.body = this.body.substring(0, i) + '\n' + this.body.substring(i + 2);
            }
        }
    }

    void setSlotType(int type) {
        switch (type) {
            case 0: {
                this.slotX = new int[]{56, 38, 38};
                this.slotY = new int[]{37, 28, 46};
                break;
            }
            case 1: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 55, 37};
                break;
            }
            case 2: {
                this.slotX = new int[]{56, 56, 14};
                this.slotY = new int[]{28, 46, 37};
                break;
            }
            case 3: {
                this.slotX = new int[]{38, 47, 56};
                this.slotY = new int[]{28, 46, 28};
                break;
            }
            case 7: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 37, 55};
            }
        }
        this.toolSlots.resetSlots(this.slotX, this.slotY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.text.func_146178_a();
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.logic.getInvName()), 116, 8, 0);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 118, this.field_147000_g - 96 + 2, 0);
        this.field_146289_q.func_78276_b(this.toolName + "_", 180, 8, 0xFFFFFF);
        if (this.logic.isStackInSlot(0)) {
            ToolStationGuiHelper.drawToolStats(this.logic.func_70301_a(0), 294, 0);
        } else {
            this.drawToolInformation();
        }
    }

    protected void drawToolInformation() {
        this.func_73732_a(this.field_146289_q, this.title, 349, 8, 0xFFFFFF);
        this.field_146289_q.func_78279_b(this.body, 294, 24, 115, 0xFFFFFF);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int cornerX = this.field_147003_i + 110;
        this.func_73729_b(cornerX, this.field_147009_r, 0, 0, 176, this.field_147000_g);
        if (this.active) {
            this.func_73729_b(cornerX + 62, this.field_147009_r, 0, this.field_147000_g, 112, 22);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        for (int i = 0; i < this.slotX.length; ++i) {
            this.func_73729_b(cornerX + this.slotX[i], this.field_147009_r + this.slotY[i], 144, 216, 18, 18);
            if (this.logic.isStackInSlot(i + 1)) continue;
            this.func_73729_b(cornerX + this.slotX[i], this.field_147009_r + this.slotY[i], 18 * this.iconX[i], 18 * this.iconY[i], 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(description);
        this.func_73729_b(cornerX + 176, this.field_147009_r, 0, 0, 126, this.field_147000_g + 30);
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1 || !this.active && keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.logic.setToolname("");
            this.updateServer("");
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.active) {
            this.text.func_146201_a(par1, keyCode);
            this.toolName = this.text.func_146179_b().trim();
            this.logic.setToolname(this.toolName);
            this.updateServer(this.toolName);
        }
    }

    void updateServer(String name) {
        TConstruct.packetPipeline.sendToServer(new ToolStationPacket(this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e, name));
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.field_146294_l - this.field_146999_f >= 107;
        if (this.field_147003_i < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (y + h - 4 < this.field_147009_r || y + 4 > this.field_147009_r + this.field_147000_g) {
            return false;
        }
        return x - w - 4 >= this.field_147003_i - 40 && x + 4 <= this.field_147003_i + this.field_146999_f + 126;
    }
}

