/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import java.lang.ref.WeakReference;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.InventoryCraftingStation;
import tconstruct.tools.inventory.InventoryCraftingStationResult;
import tconstruct.tools.inventory.SlotCraftingStation;
import tconstruct.tools.logic.CraftingStationLogic;

public class CraftingStationContainer
extends Container {
    public InventoryCrafting craftMatrix;
    public IInventory craftResult;
    public CraftingStationLogic logic;
    private World worldObj;
    EntityPlayer player;
    private int posX;
    private int posY;
    private int posZ;
    private WeakReference[] inventories;

    public CraftingStationContainer(InventoryPlayer inventorplayer, CraftingStationLogic logic, int x, int y, int z) {
        int column;
        int row;
        this.worldObj = logic.func_145831_w();
        this.player = inventorplayer.field_70458_d;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.logic = logic;
        this.craftMatrix = new InventoryCraftingStation(this, 3, 3, logic);
        this.craftResult = new InventoryCraftingStationResult(logic);
        this.inventories = logic.getInventories();
        int craftingOffsetX = 30;
        int inventoryOffsetX = 8;
        if (logic.chest != null) {
            craftingOffsetX += 116;
            inventoryOffsetX += 116;
        }
        this.func_75146_a((Slot)new SlotCraftingStation(inventorplayer.field_70458_d, (IInventory)this.craftMatrix, this.craftResult, 0, craftingOffsetX + 94, 35));
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, column + row * 3, craftingOffsetX + column * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)inventorplayer, column + row * 9 + 9, inventoryOffsetX + column * 18, 84 + row * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)inventorplayer, column, inventoryOffsetX + column * 18, 142));
        }
        if (logic.chest != null) {
            IInventory secondChest;
            IInventory firstChest = (IInventory)logic.chest.get();
            IInventory iInventory = secondChest = logic.doubleChest == null ? null : (IInventory)logic.doubleChest.get();
            if (logic.doubleFirst && logic.doubleChest != null) {
                secondChest = (IInventory)logic.chest.get();
                firstChest = (IInventory)logic.doubleChest.get();
            }
            int count = 0;
            for (column = 0; column < 9; ++column) {
                for (row = 0; row < 6; ++row) {
                    int value = count < 27 ? count : count - 27;
                    this.func_75146_a(new Slot(count < 27 ? firstChest : secondChest, value, 8 + row * 18, 19 + column * 18));
                    if (++count >= 27 && secondChest == null) break;
                }
                if (count >= 27 && secondChest == null) break;
            }
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void func_75130_a(IInventory par1IInventory) {
        ItemStack tool = this.modifyItem();
        if (tool != null) {
            this.craftResult.func_70299_a(0, tool);
        } else {
            this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.worldObj));
        }
    }

    public ItemStack modifyItem() {
        Item item;
        ItemStack input = this.craftMatrix.func_70301_a(4);
        if (input != null && (item = input.func_77973_b()) instanceof IModifyable) {
            ItemStack[] slots = new ItemStack[8];
            for (int i = 0; i < 4; ++i) {
                slots[i] = this.craftMatrix.func_70301_a(i);
                slots[i + 4] = this.craftMatrix.func_70301_a(i + 5);
            }
            ItemStack output = ModifyBuilder.instance.modifyItem(input, slots);
            if (output != null) {
                return output;
            }
        }
        return null;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (!this.worldObj.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                par1EntityPlayer.func_71019_a(itemstack, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        Block block = this.worldObj.func_147439_a(this.posX, this.posY, this.posZ);
        if (block != TinkerTools.craftingStationWood && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        if (!this.logic.func_70300_a(player) || !CraftingStationLogic.isUseableByPlayer(player, this.inventories)) {
            return false;
        }
        return player.func_70092_e((double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5) <= 64.0;
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (par2 == 0) {
                if (itemstack.func_77973_b() instanceof IModifyable ? !this.mergeCraftedStack(itemstack1, this.logic.func_70302_i_(), this.field_75151_b.size(), true, par1EntityPlayer) : !this.func_75135_a(itemstack1, 10, 46, true)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (par2 >= 10 && par2 < 37 ? !this.func_75135_a(itemstack1, 37, 46, false) : (par2 >= 37 && par2 < 46 ? !this.func_75135_a(itemstack1, 10, 37, false) : !this.func_75135_a(itemstack1, 10, 46, false))) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(par1EntityPlayer, itemstack1);
        }
        return itemstack;
    }

    protected boolean mergeCraftedStack(ItemStack stack, int slotsStart, int slotsTotal, boolean playerInventory, EntityPlayer player) {
        boolean failedToMerge = false;
        int slotIndex = slotsStart;
        if (playerInventory) {
            slotIndex = slotsTotal - 1;
        }
        ItemStack copyStack = null;
        if (stack.field_77994_a > 0) {
            slotIndex = playerInventory ? slotsTotal - 1 : slotsStart;
            while (!playerInventory && slotIndex < slotsTotal || playerInventory && slotIndex >= slotsStart) {
                Slot otherInventorySlot = (Slot)this.field_75151_b.get(slotIndex);
                copyStack = otherInventorySlot.func_75211_c();
                if (copyStack == null) {
                    otherInventorySlot.func_75215_d(stack.func_77946_l());
                    otherInventorySlot.func_75218_e();
                    stack.field_77994_a = 0;
                    failedToMerge = true;
                    break;
                }
                if (playerInventory) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return failedToMerge;
    }

    public boolean func_94530_a(ItemStack par1ItemStack, Slot par2Slot) {
        return par2Slot.field_75224_c != this.craftResult && super.func_94530_a(par1ItemStack, par2Slot);
    }
}

