/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.client.CrosshairType;
import tconstruct.weaponry.entity.JavelinEntity;

public class Javelin
extends AmmoWeapon {
    public Javelin() {
        super(3, "Javelin");
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, entity, this);
    }

    @Override
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        float threshold;
        if (!itemStack.func_77942_o()) {
            return super.getWindupProgress(itemStack, player);
        }
        if (!itemStack.func_77978_p().func_74775_l("InfiTool").func_74764_b("Throwing")) {
            return 0.5f;
        }
        float timeleft = itemStack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Throwing");
        if (timeleft < (threshold = (float)(this.getWindupTime(itemStack) / 5))) {
            return (threshold - timeleft) / threshold;
        }
        return 0.5f - 0.25f * ((float)this.getWindupTime(itemStack) - timeleft) / threshold;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b("Throwing")) {
            return stack;
        }
        if (this.getAmmoCount(stack) <= 0) {
            return stack;
        }
        tags.func_74768_a("Throwing", this.getWindupTime(stack));
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(stack, world, entity, par4, par5);
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b("Throwing")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71071_by.func_70448_g() != stack) {
            return;
        }
        int timeLeft = tags.func_74762_e("Throwing");
        if (--timeLeft > 0) {
            tags.func_74768_a("Throwing", timeLeft);
        } else {
            this.func_77615_a(stack, world, player, 0);
            tags.func_82580_o("Throwing");
        }
    }

    @Override
    public boolean zoomOnWindup(ItemStack itemStack) {
        return true;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.5f;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 2.5f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 0.5f;
    }

    @Override
    public int getWindupTime(ItemStack itemStack) {
        return 17;
    }

    @Override
    public int getPartAmount() {
        return 3;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_javelin_head";
            }
            case 1: {
                return "_javelin_head_broken";
            }
            case 2: {
                return "_javelin_handle";
            }
            case 3: {
                return "_javelin_accessory";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_javelin_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "javelin";
    }

    @Override
    public float getAmmoModifier() {
        return 0.2f;
    }

    @Override
    public float getDurabilityModifier() {
        return 0.1f;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.arrowhead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "thrown", "ammo", "windup"};
    }

    @Override
    protected Entity createProjectile(ItemStack reference, World world, EntityPlayer player, float accuracy, int time) {
        reference.func_77978_p().func_74775_l("InfiTool").func_82580_o("Throwing");
        return new JavelinEntity(world, player, this.getProjectileSpeed(), accuracy, reference);
    }

    @Override
    public float getProjectileSpeed() {
        return 2.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrosshairType getCrosshairType() {
        return CrosshairType.WEIRD;
    }
}

