/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.imc;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.List;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import tconstruct.TConstruct;

@GameRegistry.ObjectHolder(value="TConstruct")
@Pulse(id="Tinkers AE2 Compatibility", description="Tinkers Construct compatibility for Applied Energistics 2", modsRequired="appliedenergistics2", forced=true)
public class TinkerAE2 {
    private static final List<String> spatialIOLogics = Arrays.asList("EssenceExtractorLogic", "GolemPedestalLogic", "MultiServantLogic");
    private static final List<String> spatialIOSmelteryLogics = Arrays.asList("AdaptiveSmelteryLogic", "AqueductLogic", "CastingBasinLogic", "CastingChannelLogic", "CastingTableLogic", "FaucetLogic", "LavaTankLogic", "SmelteryDrainLogic", "SmelteryLogic", "TankAirLogic", "TowerFurnaceLogic");
    private static final List<String> spatialIOToolLogics = Arrays.asList("CraftingStationLogic", "FrypanLogic", "PartBuilderLogic", "PatternChestLogic", "StencilTableLogic", "ToolForgeLogic", "ToolStationLogic");

    @Handler
    public void init(FMLInitializationEvent event) {
        TConstruct.logger.info("AE2 detected. Registering for Spatial IO.");
        this.addtoSpatialWhitelist("tconstruct.blocks.logic.DryingRackLogic");
        this.addtoSpatialWhitelist("tconstruct.mechworks.logic.TileEntityLandmine");
        for (String s : spatialIOSmelteryLogics) {
            this.addtoSpatialWhitelist("tconstruct.smeltery.logic." + s);
        }
        for (String s : spatialIOToolLogics) {
            this.addtoSpatialWhitelist("tconstruct.tools.logic." + s);
        }
    }

    public void addtoSpatialWhitelist(String teClass) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)teClass);
    }
}

