/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import java.lang.ref.WeakReference;
import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.tools.inventory.CraftingStationContainer;
import tconstruct.tools.logic.FurnaceLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.util.config.PHConstruct;

public class CraftingStationLogic
extends InventoryLogic
implements ISidedInventory {
    public ForgeDirection chestDirection = ForgeDirection.UNKNOWN;
    public int chestSize;
    public WeakReference<IInventory> chest;
    public WeakReference<IInventory> doubleChest;
    public WeakReference<IInventory> patternChest;
    public WeakReference<IInventory> furnace;
    public boolean tinkerTable;
    public boolean stencilTable;
    public boolean doubleFirst;
    public int invRows;
    public int invColumns;
    public int slotCount;

    public CraftingStationLogic() {
        super(10);
    }

    public boolean canDropInventorySlot(int slot) {
        return slot != 0;
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (slot == 0) {
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                this.func_70298_a(i, 1);
            }
        }
        return super.func_70298_a(slot, quantity);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return CraftingStationLogic.isUseableByPlayer(player, this.getInventories()) && super.func_70300_a(player);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        this.chest = null;
        this.chestSize = 0;
        this.slotCount = 0;
        this.chestDirection = ForgeDirection.UNKNOWN;
        this.doubleChest = null;
        this.patternChest = null;
        this.furnace = null;
        this.tinkerTable = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int xPos = x + dir.offsetX;
            int yPos = y + dir.offsetY;
            int zPos = z + dir.offsetZ;
            TileEntity tile = world.func_147438_o(xPos, yPos, zPos);
            if (!(tile instanceof IInventory) || tile instanceof CraftingStationLogic || this.isBlacklisted(tile.getClass())) continue;
            IInventory inv = (IInventory)tile;
            if (this.patternChest == null && tile instanceof PatternChestLogic) {
                this.patternChest = new WeakReference<IInventory>(inv);
                continue;
            }
            if (this.furnace == null && (tile instanceof TileEntityFurnace || tile instanceof FurnaceLogic)) {
                this.furnace = new WeakReference<IInventory>(inv);
                continue;
            }
            if (!this.tinkerTable && tile instanceof ToolStationLogic) {
                this.tinkerTable = true;
                continue;
            }
            if (tile instanceof ISidedInventory && ((ISidedInventory)tile).func_94128_d(dir.getOpposite().ordinal()).length == 0 || this.chest != null || !inv.func_70300_a(inventoryplayer.field_70458_d)) continue;
            this.chest = new WeakReference<IInventory>(inv);
            this.chestDirection = dir;
            this.invColumns = 6;
            int n = this.chestSize = tile instanceof ISidedInventory ? ((ISidedInventory)tile).func_94128_d(dir.getOpposite().ordinal()).length : inv.func_70302_i_();
            if (tile instanceof TileEntityChest) {
                this.checkForChest(world, xPos, yPos, zPos, 1, 0);
                this.checkForChest(world, xPos, yPos, zPos, -1, 0);
                this.checkForChest(world, xPos, yPos, zPos, 0, 1);
                this.checkForChest(world, xPos, yPos, zPos, 0, -1);
            }
            this.slotCount = this.chestSize * (this.doubleChest != null ? 2 : 1);
            this.invRows = (int)Math.ceil((double)this.slotCount / (double)this.invColumns);
        }
        return new CraftingStationContainer(inventoryplayer, this, x, y, z);
    }

    private boolean isBlacklisted(Class<? extends TileEntity> clazz) {
        return PHConstruct.craftingStationBlacklist.contains(clazz.getName());
    }

    void checkForChest(World world, int x, int y, int z, int dx, int dz) {
        TileEntity tile = world.func_147438_o(x + dx, y, z + dz);
        if (tile instanceof TileEntityChest) {
            this.doubleChest = new WeakReference<IInventory>((IInventory)tile);
            this.doubleFirst = dx + dz < 0;
        }
    }

    public boolean isDoubleChest() {
        return this.doubleChest != null;
    }

    public IInventory getFirstInventory() {
        if (this.doubleFirst && this.doubleChest != null) {
            return (IInventory)this.doubleChest.get();
        }
        return this.chest != null ? (IInventory)this.chest.get() : null;
    }

    public IInventory getSecondInventory() {
        if (!this.isDoubleChest()) {
            return null;
        }
        if (this.doubleFirst) {
            return (IInventory)this.chest.get();
        }
        return this.doubleChest == null ? null : (IInventory)this.doubleChest.get();
    }

    protected String getDefaultName() {
        return "crafters.CraftingStation";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public static boolean isUseableByPlayer(EntityPlayer player, WeakReference[] inventories) {
        for (WeakReference ref : inventories) {
            IInventory inv;
            if (ref == null || (inv = (IInventory)ref.get()) == null || inv.func_70300_a(player)) continue;
            return false;
        }
        return true;
    }

    public WeakReference[] getInventories() {
        return new WeakReference[]{this.chest, this.doubleChest, this.patternChest, this.furnace};
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public String func_145825_b() {
        return this.getDefaultName();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean canUpdate() {
        return false;
    }
}

