/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.forestry.core;

import com.jaquadro.minecraft.storagedrawers.api.IStorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.config.IBlockConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IUserConfig;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlockFactory;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.StorageDrawersPack;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.DataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.ModBlocks;
import cpw.mods.fml.common.Loader;
import net.minecraft.block.Block;

public class RefinedRelocation {
    public static Block[] fullDrawers1;
    public static Block[] fullDrawers2;
    public static Block[] fullDrawers4;
    public static Block[] halfDrawers2;
    public static Block[] halfDrawers4;
    public static Block[] trim;

    public static void init() {
        int i;
        IStorageDrawersApi api = StorageDrawersApi.instance();
        if (api == null) {
            return;
        }
        if (!Loader.isModLoaded((String)"RefinedRelocation") || !api.userConfig().integrationConfig().isRefinedRelocationEnabled()) {
            return;
        }
        IPackBlockFactory factory = api.packFactory();
        DataResolver[] resolvers = StorageDrawersPack.instance.resolvers;
        fullDrawers1 = new Block[resolvers.length];
        fullDrawers2 = new Block[resolvers.length];
        fullDrawers4 = new Block[resolvers.length];
        halfDrawers2 = new Block[resolvers.length];
        halfDrawers4 = new Block[resolvers.length];
        trim = new Block[resolvers.length];
        for (int i2 = 0; i2 < resolvers.length; ++i2) {
            DataResolver resolver = resolvers[i2];
            RefinedRelocation.fullDrawers1[i2] = factory.createBlock(BlockConfiguration.SortingFull1, (IPackDataResolver)resolver);
            RefinedRelocation.fullDrawers2[i2] = factory.createBlock(BlockConfiguration.SortingFull2, (IPackDataResolver)resolver);
            RefinedRelocation.fullDrawers4[i2] = factory.createBlock(BlockConfiguration.SortingFull4, (IPackDataResolver)resolver);
            RefinedRelocation.halfDrawers2[i2] = factory.createBlock(BlockConfiguration.SortingHalf2, (IPackDataResolver)resolver);
            RefinedRelocation.halfDrawers4[i2] = factory.createBlock(BlockConfiguration.SortingHalf4, (IPackDataResolver)resolver);
            RefinedRelocation.trim[i2] = factory.createBlock(BlockConfiguration.TrimSorting, (IPackDataResolver)resolver);
            factory.bindSortingBlock(ModBlocks.fullDrawers1[i2], fullDrawers1[i2]);
            factory.bindSortingBlock(ModBlocks.fullDrawers2[i2], fullDrawers2[i2]);
            factory.bindSortingBlock(ModBlocks.fullDrawers4[i2], fullDrawers4[i2]);
            factory.bindSortingBlock(ModBlocks.halfDrawers2[i2], halfDrawers2[i2]);
            factory.bindSortingBlock(ModBlocks.halfDrawers4[i2], halfDrawers4[i2]);
            factory.bindSortingBlock(ModBlocks.trim[i2], trim[i2]);
        }
        IUserConfig config = api.userConfig();
        IBlockConfig blockConfig = config.blockConfig();
        char[] tail = new char[]{'A', 'B'};
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.SortingFull1))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers1[i], "fullDrawersSort1" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.SortingFull2))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers2[i], "fullDrawersSort2" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.SortingFull4))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(fullDrawers4[i], "fullDrawersSort4" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.SortingHalf2))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(halfDrawers2[i], "halfDrawersSort2" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.SortingHalf4))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(halfDrawers4[i], "halfDrawersSort4" + tail[i]);
            }
        }
        if (blockConfig.isBlockEnabled(blockConfig.getBlockConfigName(BlockConfiguration.TrimSorting))) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.registerBlock(trim[i], "trimSort" + tail[i]);
            }
        }
        if (!config.addonConfig().showAddonItemsNEI()) {
            for (i = 0; i < resolvers.length; ++i) {
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers1[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers2[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(fullDrawers4[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(halfDrawers2[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(halfDrawers4[i]));
                factory.hideBlock(ModBlocks.getQualifiedName(trim[i]));
            }
        }
    }
}

