/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.minetweaker;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.storagedrawers.OreDictionaryWhitelist")
public class OreDictionaryWhitelist {
    @ZenMethod
    public static void add(String name) {
        if (name != null && name.length() > 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddNameAction(name));
        } else {
            MineTweakerAPI.logError((String)"Tried to add empty ore dictionary name to drawer conversion whitelist.");
        }
    }

    private static class AddNameAction
    implements IUndoableAction {
        String name;
        boolean added;

        public AddNameAction(String name) {
            this.name = name;
        }

        public void apply() {
            this.added = StorageDrawers.oreDictRegistry.addWhitelist(this.name);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.added) {
                StorageDrawers.oreDictRegistry.removeWhitelist(this.name);
            }
        }

        public String describe() {
            if (this.added) {
                return "Adding ore dictionary key '" + this.name + "' to drawer conversion whitelist.";
            }
            return "Ore dictionary key '" + this.name + "' already registered in drawer conversion whitelist.";
        }

        public String describeUndo() {
            if (this.added) {
                return "Removing previously added ore dictionary key '" + this.name + "' from drawer conversion whitelist.";
            }
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

