/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.pack;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlock;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.api.pack.TextureType;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.integration.RefinedRelocation;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.BlockSortingDrawers;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockSortingDrawersPack
extends BlockSortingDrawers
implements IPackBlock {
    private IPackDataResolver resolver;

    public BlockSortingDrawersPack(IPackDataResolver resolver, int drawerCount, boolean halfDepth) {
        super(resolver.getBlockName(BlockConfiguration.by(BlockType.DrawersSorting, drawerCount, halfDepth)), drawerCount, halfDepth);
        this.resolver = resolver;
        CreativeTabs tabs = resolver.getCreativeTabs(BlockType.DrawersSorting);
        if (StorageDrawers.config.cache.addonSeparateVanilla && tabs != null) {
            this.func_149647_a(tabs);
        } else {
            this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        }
    }

    public String[] getUnlocalizedNames() {
        String[] names = new String[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            names[i] = this.resolver.getUnlocalizedName(i);
        }
        return names;
    }

    @Override
    public IPackDataResolver getDataResolver() {
        return this.resolver;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (!StorageDrawers.config.cache.addonShowVanilla) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().func_149691_a(side, meta);
        }
        return super.func_149691_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.func_72805_g(x, y, z);
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().func_149691_a(side, meta);
        }
        return super.getIcon(blockAccess, x, y, z, side, level);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        int n = meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        if (!this.resolver.isValidMetaValue(meta)) {
            this.getSimilarBlock().getIconTrim(meta);
        }
        return super.getIconTrim(meta);
    }

    private BlockSortingDrawers getSimilarBlock() {
        if (this.drawerCount == 1 && !this.halfDepth) {
            return RefinedRelocation.fullDrawers1;
        }
        if (this.drawerCount == 2 && !this.halfDepth) {
            return RefinedRelocation.fullDrawers2;
        }
        if (this.drawerCount == 4 && !this.halfDepth) {
            return RefinedRelocation.fullDrawers4;
        }
        if (this.drawerCount == 2 && this.halfDepth) {
            return RefinedRelocation.halfDrawers2;
        }
        if (this.drawerCount == 4 && this.halfDepth) {
            return RefinedRelocation.halfDrawers4;
        }
        return RefinedRelocation.fullDrawers1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        this.iconSide = new IIcon[16];
        this.iconSideH = new IIcon[16];
        this.iconSideV = new IIcon[16];
        this.iconFront1 = new IIcon[16];
        this.iconFront2 = new IIcon[16];
        this.iconFront4 = new IIcon[16];
        this.iconTrim = new IIcon[16];
        this.iconSort = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            if (!this.resolver.isValidMetaValue(i)) continue;
            this.iconFront1[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.Front1, i));
            this.iconFront2[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.Front2, i));
            this.iconFront4[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.Front4, i));
            this.iconSide[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.Side, i));
            this.iconSideV[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.SideVSplit, i));
            this.iconSideH[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.SideHSplit, i));
            this.iconTrim[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.TrimBorder, i));
            this.iconSort[i] = register.func_94245_a(this.resolver.getTexturePath(TextureType.SideSort, i));
        }
    }
}

