/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import vswe.stevesfactory.interfaces.GuiManager;

public class TextBoxLogic {
    private String text;
    private int cursor;
    private int cursorPosition;
    private int charLimit;
    private int width;
    private boolean updatedCursor;
    private float mult;

    public TextBoxLogic(int charLimit, int width) {
        this.charLimit = charLimit;
        this.width = width;
        this.mult = 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void addText(GuiManager gui, String str) {
        String newText = this.text.substring(0, this.cursor) + str + this.text.substring(this.cursor);
        if (newText.length() <= this.charLimit && (float)gui.getStringWidth(newText) * this.mult <= (float)this.width) {
            this.text = newText;
            this.moveCursor(gui, str.length());
            this.textChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void deleteText(GuiManager gui, int direction) {
        if (this.cursor + direction >= 0 && this.cursor + direction <= this.text.length()) {
            if (direction > 0) {
                this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
            } else {
                this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                this.moveCursor(gui, direction);
            }
            this.textChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void moveCursor(GuiManager gui, int steps) {
        this.cursor += steps;
        this.updateCursor();
    }

    protected void textChanged() {
    }

    public String getText() {
        return this.text;
    }

    public int getCursorPosition(GuiManager gui) {
        if (this.updatedCursor) {
            this.cursorPosition = (int)((float)gui.getStringWidth(this.text.substring(0, this.cursor)) * this.mult);
            this.updatedCursor = false;
        }
        return this.cursorPosition;
    }

    public void setText(String text) {
        this.text = text;
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyStroke(GuiManager gui, char c, int k) {
        if (k == 203) {
            this.moveCursor(gui, -1);
        } else if (k == 205) {
            this.moveCursor(gui, 1);
        } else if (k == 14) {
            this.deleteText(gui, -1);
        } else if (k == 211) {
            this.deleteText(gui, 1);
        } else if (c == '\u0016' && k == 47) {
            this.addText(gui, GuiScreen.func_146277_j());
        } else if (c != '\u0000' && Character.isDefined(c) && !Character.isISOControl(c)) {
            this.addText(gui, Character.toString(c));
        }
    }

    public void updateCursor() {
        if (this.cursor < 0) {
            this.cursor = 0;
        } else if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        this.updatedCursor = true;
    }

    public void resetCursor() {
        this.cursor = this.text.length();
        this.updatedCursor = true;
    }

    public void setTextAndCursor(String s) {
        this.setText(s);
        this.resetCursor();
    }

    public void setMult(float mult) {
        this.mult = mult;
    }
}

