/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.ComponentTypes;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotExplosion;

public class ModuleDynamite
extends ModuleBase {
    private boolean markerMoving;
    private int fuseStartX = super.guiWidth() + 5;
    private int fuseStartY = 27;
    private final int maxFuseLength = 150;

    public ModuleDynamite(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.EXPLOSIVES.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotExplosion(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.getFuse() == 0) {
            this.prime();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isPlaceholder()) {
            if (this.getFuse() == 0 && this.getSimInfo().getShouldExplode()) {
                this.setFuse(1);
            } else if (this.getFuse() != 0 && !this.getSimInfo().getShouldExplode()) {
                this.setFuse(0);
            }
        }
        if (this.getFuse() > 0) {
            this.setFuse(this.getFuse() + 1);
            if (this.getFuse() == this.getFuseLength()) {
                this.explode();
                if (!this.isPlaceholder()) {
                    this.getCart().func_70106_y();
                }
            }
        }
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 136;
    }

    private int[] getMovableMarker() {
        return new int[]{this.fuseStartX + (int)(105.0f * (1.0f - (float)this.getFuseLength() / 150.0f)), this.fuseStartY, 4, 10};
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/explosions.png");
        this.drawImage(gui, this.fuseStartX, this.fuseStartY + 3, 12, 0, 105, 4);
        this.drawImage(gui, this.fuseStartX + 105, this.fuseStartY - 4, 0, 10, 16, 16);
        this.drawImage(gui, this.fuseStartX + (int)(105.0f * (1.0f - (float)(this.getFuseLength() - this.getFuse()) / 150.0f)), this.fuseStartY, this.isPrimed() ? 8 : 4, 0, 4, 10);
        this.drawImage(gui, this.getMovableMarker(), 0, 0);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.getFuse() == 0 && this.inRect(x, y, this.getMovableMarker())) {
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.getFuse() != 0) {
            this.markerMoving = false;
        } else if (this.markerMoving) {
            int tempfuse = 150 - (int)((float)(x - this.fuseStartX) / 0.7f);
            if (tempfuse < 2) {
                tempfuse = 2;
            } else if (tempfuse > 150) {
                tempfuse = 150;
            }
            this.sendPacket(0, (byte)tempfuse);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private boolean isPrimed() {
        return this.getFuse() / 5 % 2 == 0 && this.getFuse() != 0;
    }

    private void explode() {
        if (this.isPlaceholder()) {
            this.setFuse(1);
        } else {
            float f = this.explosionSize();
            this.setStack(0, null);
            this.getCart().field_70170_p.func_72876_a(null, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, f, true);
        }
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.createExplosives();
    }

    @Override
    public boolean dropOnDeath() {
        return this.getFuse() == 0;
    }

    @Override
    public void onDeath() {
        if (this.getFuse() > 0 && this.getFuse() < this.getFuseLength()) {
            this.explode();
        }
    }

    public float explosionSize() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getExplosionSize() / 2.5f;
        }
        return (float)this.getDw(2) / 2.5f;
    }

    public void createExplosives() {
        if (this.isPlaceholder() || this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        int f = 8;
        if (ComponentTypes.DYNAMITE.isStackOfType(this.getStack(0))) {
            f += this.getStack((int)0).field_77994_a * 2;
        }
        this.updateDw(2, (byte)f);
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
        this.addDw(1, 70);
        this.addDw(2, 8);
    }

    public int getFuse() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().fuse;
        }
        byte val = this.getDw(0);
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    private void setFuse(int val) {
        if (this.isPlaceholder()) {
            this.getSimInfo().fuse = val;
        } else {
            this.updateDw(0, (byte)val);
        }
    }

    public void setFuseLength(int val) {
        if (val > 150) {
            val = 150;
        }
        this.updateDw(1, (byte)val);
    }

    public int getFuseLength() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getFuseLength();
        }
        byte val = this.getDw(1);
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    public void prime() {
        this.setFuse(1);
    }

    protected int getMaxFuse() {
        return 150;
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.setFuseLength(data[0]);
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("FuseLength", id), (short)this.getFuseLength());
        tagCompound.func_74777_a(this.generateNBTName("Fuse", id), (short)this.getFuse());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setFuseLength(tagCompound.func_74765_d(this.generateNBTName("FuseLength", id)));
        this.setFuse(tagCompound.func_74765_d(this.generateNBTName("Fuse", id)));
        this.createExplosives();
    }
}

