/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.Buttons.ButtonBase;
import vswe.stevescarts.Buttons.ButtonControl;
import vswe.stevescarts.Computer.ComputerTask;
import vswe.stevescarts.Modules.Workers.ModuleComputer;

public class ButtonControlInteger
extends ButtonControl {
    private int dif;

    public ButtonControlInteger(ModuleComputer module, ButtonBase.LOCATION loc, int dif) {
        super(module, loc);
        this.dif = dif;
    }

    @Override
    public String toString() {
        if (this.dif < 0) {
            return "Decrease by " + -1 * this.dif;
        }
        return "Increase by " + this.dif;
    }

    @Override
    public int texture() {
        if (this.dif == 1) {
            return 40;
        }
        if (this.dif == -1) {
            return 41;
        }
        if (this.dif == 10) {
            return 42;
        }
        if (this.dif == -10) {
            return 43;
        }
        return super.texture();
    }

    @Override
    public boolean isVisible() {
        if (((ModuleComputer)this.module).getSelectedTasks() != null) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                if (!task.getControlUseVar() && task.getControlUseBigInteger(Math.abs(this.dif))) continue;
                return false;
            }
        }
        return super.isVisible();
    }

    @Override
    public boolean isEnabled() {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            if (task.getControlMinInteger() > task.getControlInteger() + this.dif || task.getControlInteger() + this.dif > task.getControlMaxInteger()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            task.setControlInteger(task.getControlInteger() + this.dif);
        }
    }
}

