/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Renders;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.IconData;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Helpers.Tank;
import vswe.stevescarts.Models.Cart.ModelCartbase;
import vswe.stevescarts.Modules.ModuleBase;

public class RendererMinecart
extends Render {
    public RendererMinecart() {
        this.field_76989_e = 0.5f;
    }

    public void renderCart(MinecartModular cart, double x, double y, double z, float yaw, float partialTickTime) {
        boolean flip;
        if (cart.getModules() != null) {
            for (ModuleBase module : cart.getModules()) {
                if (module.shouldCartRender()) continue;
                return;
            }
        }
        GL11.glPushMatrix();
        double partialPosX = cart.field_70142_S + (cart.field_70165_t - cart.field_70142_S) * (double)partialTickTime;
        double partialPosY = cart.field_70137_T + (cart.field_70163_u - cart.field_70137_T) * (double)partialTickTime;
        double partialPosZ = cart.field_70136_U + (cart.field_70161_v - cart.field_70136_U) * (double)partialTickTime;
        float partialRotPitch = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * partialTickTime;
        Vec3 posFromRail = cart.func_70489_a(partialPosX, partialPosY, partialPosZ);
        if (posFromRail != null && cart.canUseRail()) {
            double predictionLength = 0.3f;
            Vec3 lastPos = cart.func_70495_a(partialPosX, partialPosY, partialPosZ, predictionLength);
            Vec3 nextPos = cart.func_70495_a(partialPosX, partialPosY, partialPosZ, -predictionLength);
            if (lastPos == null) {
                lastPos = posFromRail;
            }
            if (nextPos == null) {
                nextPos = posFromRail;
            }
            x += posFromRail.field_72450_a - partialPosX;
            y += (lastPos.field_72448_b + nextPos.field_72448_b) / 2.0 - partialPosY;
            z += posFromRail.field_72449_c - partialPosZ;
            Vec3 difference = nextPos.func_72441_c(-lastPos.field_72450_a, -lastPos.field_72448_b, -lastPos.field_72449_c);
            if (difference.func_72433_c() != 0.0) {
                difference = difference.func_72432_b();
                yaw = (float)(Math.atan2(difference.field_72449_c, difference.field_72450_a) * 180.0 / Math.PI);
                partialRotPitch = (float)(Math.atan(difference.field_72448_b) * 73.0);
            }
        }
        yaw = 180.0f - yaw;
        partialRotPitch *= -1.0f;
        float damageRot = (float)cart.func_70496_j() - partialTickTime;
        float damageTime = cart.func_70491_i() - partialTickTime;
        float damageDir = cart.func_70493_k();
        if (damageTime < 0.0f) {
            damageTime = 0.0f;
        }
        boolean bl = flip = cart.field_70159_w > 0.0 != cart.field_70179_y > 0.0;
        if (cart.cornerFlip) {
            flip = !flip;
        }
        if (cart.getRenderFlippedYaw(yaw + (flip ? 0.0f : 180.0f))) {
            flip = !flip;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)partialRotPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        if (damageRot > 0.0f) {
            damageRot = MathHelper.func_76126_a((float)damageRot) * damageRot * damageTime / 10.0f * damageDir;
            GL11.glRotatef((float)damageRot, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float f = flip ? 0.0f : 180.0f;
        GL11.glRotatef((float)(flip ? 0.0f : 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.renderModels(cart, (float)(Math.PI * (double)(yaw += f) / 180.0), partialRotPitch, damageRot, 0.0625f, partialTickTime);
        GL11.glPopMatrix();
        this.renderLabel(cart, x, y, z);
    }

    public void renderModels(MinecartModular cart, float yaw, float pitch, float roll, float mult, float partialtime) {
        if (cart.getModules() != null) {
            for (ModuleBase module : cart.getModules()) {
                if (!module.haveModels()) continue;
                for (ModelCartbase model : module.getModels()) {
                    model.render(this, module, yaw, pitch, roll, mult, partialtime);
                }
            }
        }
    }

    public void renderLiquidCuboid(FluidStack liquid, int tankSize, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float mult) {
        IconData data = Tank.getIconAndTexture(liquid);
        if (data == null || data.getIcon() == null) {
            return;
        }
        if (liquid.amount > 0) {
            float filled = (float)liquid.amount / (float)tankSize;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x * mult), (float)((y + sizeY * (1.0f - filled) / 2.0f) * mult), (float)(z * mult));
            ResourceHelper.bindResource(data.getResource());
            Tank.applyColorFilter(liquid);
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glDisable((int)2896);
            this.renderCuboid(data.getIcon(), sizeX * (mult /= scale), sizeY * mult * filled, sizeZ * mult);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderCuboid(IIcon icon, double sizeX, double sizeY, double sizeZ) {
        this.renderFace(icon, sizeX, sizeZ, 0.0f, 90.0f, 0.0f, -((float)(sizeY / 2.0)), 0.0f);
        this.renderFace(icon, sizeX, sizeZ, 0.0f, -90.0f, 0.0f, (float)(sizeY / 2.0), 0.0f);
        this.renderFace(icon, sizeX, sizeY, 0.0f, 0.0f, 0.0f, 0.0f, (float)(sizeZ / 2.0));
        this.renderFace(icon, sizeX, sizeY, 180.0f, 0.0f, 0.0f, 0.0f, -((float)(sizeZ / 2.0)));
        this.renderFace(icon, sizeZ, sizeY, 90.0f, 0.0f, (float)(sizeX / 2.0), 0.0f, 0.0f);
        this.renderFace(icon, sizeZ, sizeY, -90.0f, 0.0f, -((float)(sizeX / 2.0)), 0.0f, 0.0f);
    }

    private void renderFace(IIcon icon, double totalTargetW, double totalTargetH, float yaw, float roll, float offX, float offY, float offZ) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)offX, (float)offY, (float)offZ);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)roll, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        double srcX = icon.func_94209_e();
        double srcY = icon.func_94206_g();
        double srcW = (double)icon.func_94212_f() - srcX;
        double srcH = (double)icon.func_94210_h() - srcY;
        double d = 0.001;
        double currentTargetX = 0.0;
        while (totalTargetW - currentTargetX > d * 2.0) {
            double currentTargetW = Math.min(totalTargetW - currentTargetX, 1.0);
            double currentTargetY = 0.0;
            while (totalTargetH - currentTargetY > d * 2.0) {
                double currentTargetH = Math.min(totalTargetH - currentTargetY, 1.0);
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a(currentTargetX - totalTargetW / 2.0, currentTargetY - totalTargetH / 2.0, 0.0, srcX, srcY);
                tessellator.func_78374_a(currentTargetX + currentTargetW - totalTargetW / 2.0, currentTargetY - totalTargetH / 2.0, 0.0, srcX + srcW * currentTargetW, srcY);
                tessellator.func_78374_a(currentTargetX + currentTargetW - totalTargetW / 2.0, currentTargetY + currentTargetH - totalTargetH / 2.0, 0.0, srcX + srcW * currentTargetW, srcY + srcH * currentTargetH);
                tessellator.func_78374_a(currentTargetX - totalTargetW / 2.0, currentTargetY + currentTargetH - totalTargetH / 2.0, 0.0, srcX, srcY + srcH * currentTargetH);
                tessellator.func_78381_a();
                currentTargetY += currentTargetH - d;
            }
            currentTargetX += currentTargetW - d;
        }
        GL11.glPopMatrix();
    }

    protected void renderLabel(MinecartModular cart, double x, double y, double z) {
        float distance;
        ArrayList<String> labels = cart.getLabel();
        if (labels != null && labels.size() > 0 && (distance = cart.func_70032_d((Entity)this.field_76990_c.field_78734_h)) <= 64.0f) {
            FontRenderer frend = this.func_76983_a();
            float var12 = 1.6f;
            float var13 = 0.016666668f * var12;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 1.0f + (float)(labels.size() - 1) * 0.12f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-var13), (float)(-var13), (float)var13);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int boxwidth = 0;
            int boxheight = 0;
            for (String label : labels) {
                boxwidth = Math.max(boxwidth, frend.func_78256_a(label));
                boxheight += frend.field_78288_b;
            }
            int halfW = boxwidth / 2;
            int halfH = boxheight / 2;
            Tessellator tes = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tes.func_78382_b();
            tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
            tes.func_78377_a((double)(-halfW - 1), (double)(-halfH - 1), 0.0);
            tes.func_78377_a((double)(-halfW - 1), (double)(halfH + 1), 0.0);
            tes.func_78377_a((double)(halfW + 1), (double)(halfH + 1), 0.0);
            tes.func_78377_a((double)(halfW + 1), (double)(-halfH - 1), 0.0);
            tes.func_78381_a();
            GL11.glEnable((int)3553);
            int yPos = -halfH;
            for (String label : labels) {
                frend.func_78276_b(label, -frend.func_78256_a(label) / 2, yPos, 0x20FFFFFF);
                yPos += frend.field_78288_b;
            }
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            yPos = -halfH;
            for (String label : labels) {
                frend.func_78276_b(label, -frend.func_78256_a(label) / 2, yPos, -1);
                yPos += frend.field_78288_b;
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return null;
    }

    public void func_76986_a(Entity par1Entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderCart((MinecartModular)par1Entity, x, y, z, yaw, partialTickTime);
    }
}

