/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Fancy;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import vswe.stevescarts.Fancy.FancyPancy;
import vswe.stevescarts.Fancy.FancyPancyHandler;
import vswe.stevescarts.Fancy.FancyPancyLoader;
import vswe.stevescarts.Fancy.ServerFancy;

@SideOnly(value=Side.CLIENT)
public class UserFancy {
    private FancyPancyHandler fancyPancyHandler;
    private FancyPancy activeFancyPancy;
    private int activeCheck = 100;
    private List<FancyPancy> fancies = new ArrayList<FancyPancy>();
    private boolean hasMojangFancy;
    private boolean doneMojangFancyCheck;

    public UserFancy(FancyPancyHandler fancyPancyHandler) {
        this.fancyPancyHandler = fancyPancyHandler;
    }

    public void update(AbstractClientPlayer player) {
        this.updateMojangFancyState(player);
        if (this.activeFancyPancy != null) {
            this.activeFancyPancy.update();
        }
        if (++this.activeCheck >= 100 || this.activeCheck >= 20 && player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            this.activeCheck = 0;
            this.updateActive(player);
        }
    }

    private void updateMojangFancyState(AbstractClientPlayer player) {
        if (!this.doneMojangFancyCheck) {
            ThreadDownloadImageData fancyData = this.fancyPancyHandler.getCurrentTexture(player);
            if (fancyData != null) {
                Thread thread = (Thread)ReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)fancyData, (int)5);
                if (thread != null && !thread.isAlive()) {
                    this.hasMojangFancy = FancyPancyLoader.isImageReady(fancyData);
                    this.doneMojangFancyCheck = true;
                    this.updateActive(player);
                }
            } else {
                this.doneMojangFancyCheck = true;
                this.updateActive(player);
            }
        }
    }

    private void updateActive(AbstractClientPlayer player) {
        this.activeFancyPancy = null;
        if (!this.doneMojangFancyCheck) {
            return;
        }
        int highest = Integer.MIN_VALUE;
        for (FancyPancy fancyPancy : this.fancies) {
            highest = this.findHighPriorityFancy(player, fancyPancy, highest);
        }
        ServerFancy serverFancy = this.fancyPancyHandler.getServerFancies().get(this.fancyPancyHandler.getServerHash());
        if (serverFancy != null) {
            for (FancyPancy fancyPancy : serverFancy.getFancies()) {
                highest = this.findHighPriorityFancy(player, fancyPancy, highest);
            }
        }
    }

    private int findHighPriorityFancy(AbstractClientPlayer player, FancyPancy fancyPancy, int highest) {
        if (fancyPancy.isValid(player, this.hasMojangFancy, this.isUsingMojangFancy(player)) && fancyPancy.priority > highest) {
            highest = fancyPancy.priority;
            this.activeFancyPancy = fancyPancy;
        }
        return highest;
    }

    private boolean isUsingMojangFancy(AbstractClientPlayer player) {
        return this.hasMojangFancy && this.fancyPancyHandler.getDefaultResource(player).equals((Object)this.fancyPancyHandler.getCurrentResource(player));
    }

    public void add(FancyPancy fancyPancy) {
        this.fancies.add(fancyPancy);
    }

    public String getImage(AbstractClientPlayer player) {
        if (this.activeFancyPancy != null) {
            return this.activeFancyPancy.getImage();
        }
        return this.fancyPancyHandler.getDefaultUrl(player);
    }
}

