/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Upgrades;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Helpers.ComponentTypes;
import vswe.stevescarts.Helpers.RecipeHelper;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityUpgrade;
import vswe.stevescarts.Upgrades.BaseEffect;
import vswe.stevescarts.Upgrades.Blueprint;
import vswe.stevescarts.Upgrades.CombustionFuel;
import vswe.stevescarts.Upgrades.Deployer;
import vswe.stevescarts.Upgrades.Disassemble;
import vswe.stevescarts.Upgrades.FuelCapacity;
import vswe.stevescarts.Upgrades.FuelCost;
import vswe.stevescarts.Upgrades.InputChest;
import vswe.stevescarts.Upgrades.InterfaceEffect;
import vswe.stevescarts.Upgrades.InventoryEffect;
import vswe.stevescarts.Upgrades.Manager;
import vswe.stevescarts.Upgrades.Recharger;
import vswe.stevescarts.Upgrades.Redstone;
import vswe.stevescarts.Upgrades.Solar;
import vswe.stevescarts.Upgrades.TankEffect;
import vswe.stevescarts.Upgrades.ThermalFuel;
import vswe.stevescarts.Upgrades.TimeFlat;
import vswe.stevescarts.Upgrades.TimeFlatCart;
import vswe.stevescarts.Upgrades.TimeFlatRemoved;
import vswe.stevescarts.Upgrades.Transposer;
import vswe.stevescarts.Upgrades.WorkEfficiency;

public class AssemblerUpgrade {
    private static HashMap<Byte, AssemblerUpgrade> upgrades = new HashMap();
    private static HashMap<Byte, IIcon> sides = new HashMap();
    private byte id;
    private int sideTexture;
    private String name;
    private ArrayList<BaseEffect> effects;
    private IIcon icon;

    public static HashMap<Byte, AssemblerUpgrade> getUpgrades() {
        return upgrades;
    }

    public static Collection<AssemblerUpgrade> getUpgradesList() {
        return upgrades.values();
    }

    public static AssemblerUpgrade getUpgrade(int id) {
        return upgrades.get((byte)id);
    }

    public static void init() {
        AssemblerUpgrade batteries = new AssemblerUpgrade(0, "Batteries").addEffect(new FuelCapacity(5000)).addEffect(new Recharger(40)).addRecipe(new Object[][]{{Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax}, {Items.field_151137_ax, Items.field_151045_i, Items.field_151137_ax}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
        new AssemblerUpgrade(1, "Power Crystal").addEffect(new FuelCapacity(15000)).addEffect(new Recharger(150)).addRecipe(new Object[][]{{Items.field_151045_i, Items.field_151114_aO, Items.field_151045_i}, {Items.field_151114_aO, Blocks.field_150475_bE, Items.field_151114_aO}, {Items.field_151045_i, batteries.getItemStack(), Items.field_151045_i}});
        AssemblerUpgrade knowledge = new AssemblerUpgrade(2, "Module knowledge").addEffect(new TimeFlat(-750)).addEffect(new TimeFlatCart(-5000)).addEffect(new WorkEfficiency(-0.01f)).addRecipe(new Object[][]{{Items.field_151122_aG, Blocks.field_150342_X, Items.field_151122_aG}, {Blocks.field_150342_X, Blocks.field_150381_bn, Blocks.field_150342_X}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        new AssemblerUpgrade(3, "Industrial espionage").addEffect(new TimeFlat(-2500)).addEffect(new TimeFlatCart(-14000)).addEffect(new WorkEfficiency(-0.01f)).addRecipe(new Object[][]{{Blocks.field_150342_X, ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150342_X}, {ComponentTypes.EYE_OF_GALGADOR.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.EYE_OF_GALGADOR.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), knowledge.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        ItemStack[] books = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            books[i] = Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.field_77349_p, i + 1));
        }
        AssemblerUpgrade experienced = new AssemblerUpgrade(4, "Experienced assembler").addEffect(new WorkEfficiency(0.1f)).addEffect(new FuelCost(0.3f)).addRecipe(new Object[][]{{ComponentTypes.SIMPLE_PCB.getItemStack(), books[0], ComponentTypes.SIMPLE_PCB.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{Items.field_151137_ax, books[1], Items.field_151137_ax}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{Items.field_151137_ax, books[2], Items.field_151137_ax}, {Items.field_151042_j, ComponentTypes.ADVANCED_PCB.getItemStack(), Items.field_151042_j}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{null, books[3], null}, {Items.field_151042_j, ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151042_j}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{null, books[4], null}, {null, Items.field_151137_ax, null}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(5, "New Era").addEffect(new WorkEfficiency(1.0f)).addEffect(new FuelCost(30.0f)).addRecipe(new Object[][]{{ComponentTypes.GALGADORIAN_METAL.getItemStack(), books[4], ComponentTypes.GALGADORIAN_METAL.getItemStack()}, {ComponentTypes.GALGADORIAN_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB, ComponentTypes.GALGADORIAN_METAL.getItemStack()}, {ComponentTypes.GALGADORIAN_METAL.getItemStack(), experienced.getItemStack(), ComponentTypes.GALGADORIAN_METAL.getItemStack()}});
        new AssemblerUpgrade(6, "CO2 friendly").addEffect(new FuelCost(-0.15f)).addRecipe(new Object[][]{{null, Blocks.field_150331_J, null}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150422_aJ, ComponentTypes.SIMPLE_PCB.getItemStack()}, {ComponentTypes.CLEANING_FAN, ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.CLEANING_FAN}});
        new AssemblerUpgrade(7, "Generic engine").addEffect(new CombustionFuel()).addEffect(new FuelCost(0.05f)).addRecipe(new Object[][]{{null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}, {Blocks.field_150331_J, Blocks.field_150460_al, Blocks.field_150331_J}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(8, "Module input", 1).addEffect(new InputChest(7, 3)).addRecipe(new Object[][]{{null, ComponentTypes.ADVANCED_PCB.getItemStack(), null}, {Blocks.field_150331_J, Blocks.field_150486_ae, Blocks.field_150331_J}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(9, "Production line").addEffect(new Blueprint()).addRecipe(new Object[][]{{null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}, {ComponentTypes.ADVANCED_PCB.getItemStack(), Items.field_151137_ax, ComponentTypes.ADVANCED_PCB.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        new AssemblerUpgrade(10, "Cart Deployer").addEffect(new Deployer()).addRecipe(new Object[][]{{Items.field_151042_j, Blocks.field_150448_aq, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150331_J, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(11, "Cart Modifier").addEffect(new Disassemble()).addRecipe(new Object[][]{{Items.field_151042_j, null, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150467_bQ, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(12, "Cart Crane").addEffect(new Transposer()).addRecipe(new Object[][]{{Blocks.field_150331_J, Blocks.field_150448_aq, Blocks.field_150331_J}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151042_j, ComponentTypes.SIMPLE_PCB.getItemStack()}, {null, ComponentTypes.BLANK_UPGRADE.getItemStack(), null}});
        new AssemblerUpgrade(13, "Redstone Control").addEffect(new Redstone()).addRecipe(new Object[][]{{ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151107_aW, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Blocks.field_150429_aA, ComponentTypes.ADVANCED_PCB.getItemStack(), Blocks.field_150429_aA}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
        new AssemblerUpgrade(14, "Creative Mode").addEffect(new WorkEfficiency(10000.0f)).addEffect(new FuelCost(-1.0f));
        AssemblerUpgrade demolisher = new AssemblerUpgrade(15, "Quick Demolisher").addEffect(new TimeFlatRemoved(-8000)).addRecipe(new Object[][]{{Blocks.field_150343_Z, ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150343_Z}, {ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150339_S, ComponentTypes.REINFORCED_METAL.getItemStack()}, {Blocks.field_150343_Z, ComponentTypes.BLANK_UPGRADE.getItemStack(), Blocks.field_150343_Z}});
        new AssemblerUpgrade(16, "Entropy").addEffect(new TimeFlatRemoved(-32000)).addEffect(new TimeFlat(3000)).addRecipe(new Object[][]{{ComponentTypes.EYE_OF_GALGADOR.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack(), null}, {Items.field_151045_i, Blocks.field_150368_y, Items.field_151045_i}, {null, demolisher.getItemStack(), ComponentTypes.EYE_OF_GALGADOR.getItemStack()}});
        new AssemblerUpgrade(17, "Manager Bridge").addEffect(new Manager()).addEffect(new TimeFlatCart(200)).addRecipe(new Object[][]{{Items.field_151042_j, Items.field_151079_bi, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), ModBlocks.EXTERNAL_DISTRIBUTOR.getBlock(), ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(18, "Thermal Engine Upgrade").addEffect(new ThermalFuel()).addEffect(new FuelCost(0.05f)).addRecipe(new Object[][]{{Blocks.field_150385_bj, ComponentTypes.ADVANCED_PCB.getItemStack(), Blocks.field_150385_bj}, {Blocks.field_150331_J, Blocks.field_150460_al, Blocks.field_150331_J}, {Blocks.field_150343_Z, ComponentTypes.BLANK_UPGRADE.getItemStack(), Blocks.field_150343_Z}});
        new AssemblerUpgrade(19, "Solar Panel").addEffect(new Solar()).addRecipe(new Object[][]{{ComponentTypes.SOLAR_PANEL.getItemStack(), ComponentTypes.SOLAR_PANEL.getItemStack(), ComponentTypes.SOLAR_PANEL.getItemStack()}, {Items.field_151045_i, Items.field_151137_ax, Items.field_151045_i}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
    }

    public static IIcon getStandardIcon() {
        return sides.get((byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initSides(IIconRegister register) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        for (AssemblerUpgrade upgrade : AssemblerUpgrade.getUpgradesList()) {
            if (used.contains(upgrade.sideTexture)) continue;
            sides.put((byte)upgrade.sideTexture, register.func_94245_a(StevesCarts.instance.textureHeader + ":upgrade_side_" + upgrade.sideTexture + "_icon"));
            used.add(upgrade.sideTexture);
        }
    }

    public AssemblerUpgrade(int id, String name) {
        this(id, name, 0);
    }

    public AssemblerUpgrade(int id, String name, int sideTexture) {
        this.id = (byte)id;
        this.sideTexture = sideTexture;
        this.name = name;
        this.effects = new ArrayList();
        upgrades.put(this.id, this);
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("item.SC2:" + this.getRawName() + ".name"));
    }

    public AssemblerUpgrade addEffect(BaseEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public AssemblerUpgrade addRecipe(int resultCount, Object[][] recipe) {
        RecipeHelper.addRecipe(this.getItemStack(resultCount), recipe);
        return this;
    }

    public AssemblerUpgrade addRecipe(Object[][] recipe) {
        return this.addRecipe(1, recipe);
    }

    protected ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    protected ItemStack getItemStack(int count) {
        return new ItemStack((Item)ModItems.upgrades, count, (int)this.id);
    }

    public ArrayList<BaseEffect> getEffects() {
        return this.effects;
    }

    public boolean useStandardInterface() {
        return this.getInterfaceEffect() == null;
    }

    public int getInventorySize() {
        InventoryEffect inv = this.getInventoryEffect();
        if (inv != null) {
            return inv.getInventorySize();
        }
        return 0;
    }

    public InterfaceEffect getInterfaceEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof InterfaceEffect)) continue;
            return (InterfaceEffect)effect;
        }
        return null;
    }

    public InventoryEffect getInventoryEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof InventoryEffect)) continue;
            return (InventoryEffect)effect;
        }
        return null;
    }

    public TankEffect getTankEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof TankEffect)) continue;
            return (TankEffect)effect;
        }
        return null;
    }

    public void init(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.init(upgrade);
        }
    }

    public void load(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        for (BaseEffect effect : this.effects) {
            effect.load(upgrade, compound);
        }
    }

    public void save(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        for (BaseEffect effect : this.effects) {
            effect.save(upgrade, compound);
        }
    }

    public void update(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.update(upgrade);
        }
    }

    public void removed(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.removed(upgrade);
        }
    }

    public String getRawName() {
        return this.name.replace(":", "").replace(" ", "_").toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void createIcon(IIconRegister register) {
        this.icon = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + this.getRawName().replace("_upgrade", "") + "_icon");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getMainTexture() {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSideTexture() {
        return sides.get((byte)this.sideTexture);
    }
}

