/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.tileentities;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import stevesaddons.api.IHiddenInventory;
import stevesaddons.api.IHiddenTank;
import stevesaddons.components.AEFluidBufferElement;
import stevesaddons.components.AEItemBufferElement;
import stevesaddons.helpers.AEHelper;
import stevesaddons.registry.BlockRegistry;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.components.CommandExecutorRF;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.ConditionSettingChecker;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.LiquidBufferElement;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotStackInventoryHolder;
import vswe.stevesfactory.components.StackTankHolder;

@Optional.Interface(iface="stevesaddons.api.IHiddenTank", modid="extracells")
public class TileEntityAENode
extends TileEntityClusterElement
implements IGridHost,
IActionHost,
IHiddenInventory,
IHiddenTank {
    private GridBlock gridBlock = new GridBlock();
    private IGridNode gridNode;
    private IFluidHandler tank = new AEFakeTank();
    private boolean isReady;

    public void func_145845_h() {
        super.func_145845_h();
        this.isReady = true;
        this.getNode();
    }

    public boolean canUpdate() {
        return !this.isReady;
    }

    public IGridNode getNode() {
        if (this.gridNode == null && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.isReady) {
            this.gridNode = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
            this.gridNode.updateState();
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getNode();
    }

    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return null;
    }

    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        return this.getNode();
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.gridNode != null) {
            this.gridNode.destroy();
            this.gridNode = null;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.gridNode != null) {
            this.gridNode.destroy();
            this.gridNode = null;
        }
    }

    @Override
    public int getInsertable(ItemStack stack) {
        ItemStack insertable = AEHelper.getInsertable(this.getNode(), stack, this);
        return insertable == null ? 0 : insertable.field_77994_a;
    }

    @Override
    public void insertItemStack(ItemStack stack) {
        AEHelper.insert(this.getNode(), stack, (IActionHost)this, false);
    }

    @Override
    public void addItemsToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventory, List<ItemBufferElement> itemBuffer, CommandExecutorRF commandExecutorRF) {
        Iterator<IAEItemStack> itr = AEHelper.getItrItems(this.getNode());
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            IAEItemStack stack = itr.next();
            if (stack == null) continue;
            Setting setting = commandExecutorRF.isItemValid(menuItem.getSettings(), stack.getItemStack());
            this.addAEItemToBuffer(menuItem, inventory, setting, stack, itemBuffer);
        }
    }

    @Override
    public void isItemValid(Collection<Setting> settings, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        for (Setting setting : settings) {
            ItemStack stack = AEHelper.find(this.getNode(), ((ItemSetting)setting).getItem());
            if (stack == null) continue;
            ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
            if (conditionSettingChecker == null) {
                conditionSettingChecker = new ConditionSettingChecker(setting);
                conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
            }
            conditionSettingChecker.addCount(stack.field_77994_a);
        }
    }

    @Override
    public int getExistingStackSize(ItemSetting setting) {
        int amount = 0;
        Iterator<IAEItemStack> itr = AEHelper.getItrItems(this.getNode());
        if (itr != null) {
            while (itr.hasNext()) {
                IAEItemStack stack = itr.next();
                if (!setting.isEqualForCommandExecutor(stack.getItemStack())) continue;
                amount = (int)((long)amount + stack.getStackSize());
            }
        }
        return amount;
    }

    private void addAEItemToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventory, Setting setting, IAEItemStack stack, List<ItemBufferElement> itemBuffer) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            AEItemBufferElement target = new AEItemBufferElement(stack, this);
            boolean added = false;
            for (ItemBufferElement itemBufferElement : itemBuffer) {
                if (!itemBufferElement.addTarget(owner, setting, inventory, (SlotStackInventoryHolder)target)) continue;
                added = true;
                break;
            }
            if (!added) {
                itemBuffer.add(new ItemBufferElement(owner, setting, inventory, menuItem.useWhiteList(), (SlotStackInventoryHolder)target));
            }
        }
    }

    @Override
    public void addFluidsToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder tank, List<LiquidBufferElement> liquidBuffer, CommandExecutorRF commandExecutorRF) {
        Iterator<IAEFluidStack> itr = AEHelper.getItrFluids(this.getNode());
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            IAEFluidStack stack = itr.next();
            if (stack == null) continue;
            Setting setting = commandExecutorRF.isLiquidValid((ComponentMenu)menuItem, stack.getFluidStack());
            this.addAEFluidToBuffer(menuItem, tank, setting, stack, liquidBuffer);
        }
    }

    private void addAEFluidToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder tank, Setting setting, IAEFluidStack stack, List<LiquidBufferElement> liquidBuffer) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            AEFluidBufferElement target = new AEFluidBufferElement(stack, (TileEntityAENode)tank.getTile());
            boolean added = false;
            for (LiquidBufferElement liquidBufferElement : liquidBuffer) {
                if (!liquidBufferElement.addTarget(owner, setting, tank, (StackTankHolder)target)) continue;
                added = true;
                break;
            }
            if (!added) {
                liquidBuffer.add(new LiquidBufferElement(owner, setting, tank, menuItem.useWhiteList(), (StackTankHolder)target));
            }
        }
    }

    @Override
    public IFluidHandler getTank() {
        return this.tank;
    }

    private class AEFakeTank
    implements IFluidHandler {
        private AEFakeTank() {
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            IAEFluidStack toAdd = AEHelper.insert(TileEntityAENode.this.getNode(), resource, (IActionHost)TileEntityAENode.this, doFill);
            return toAdd == null ? resource.amount : resource.amount - (int)toAdd.getStackSize();
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            IAEFluidStack drain = AEHelper.extract(TileEntityAENode.this.getNode(), resource, TileEntityAENode.this, doDrain);
            return drain == null ? null : drain.getFluidStack();
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            Iterator<IAEFluidStack> itr = AEHelper.getItrFluids(TileEntityAENode.this.getNode());
            if (itr != null && itr.hasNext()) {
                FluidStack stack = itr.next().getFluidStack();
                stack.amount = Math.min(maxDrain, stack.amount);
                return this.drain(from, stack, doDrain);
            }
            return null;
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            return AEHelper.insert(TileEntityAENode.this.getNode(), new FluidStack(fluid, 1), (IActionHost)TileEntityAENode.this, true) != null;
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            return AEHelper.find(TileEntityAENode.this.getNode(), new FluidStack(fluid, 1)) != null;
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            ArrayList<FluidTankInfo> tankInfo = new ArrayList<FluidTankInfo>();
            Iterator<IAEFluidStack> itr = AEHelper.getItrFluids(TileEntityAENode.this.getNode());
            if (itr == null) {
                return new FluidTankInfo[0];
            }
            while (itr.hasNext()) {
                FluidStack stack = itr.next().getFluidStack();
                tankInfo.add(new FluidTankInfo(stack, stack.amount));
            }
            return tankInfo.toArray(new FluidTankInfo[tankInfo.size()]);
        }
    }

    private class GridBlock
    implements IGridBlock {
        private GridBlock() {
        }

        public double getIdlePowerUsage() {
            return 10.0;
        }

        public EnumSet<GridFlags> getFlags() {
            return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
        }

        public boolean isWorldAccessible() {
            return true;
        }

        public DimensionalCoord getLocation() {
            return new DimensionalCoord((TileEntity)TileEntityAENode.this);
        }

        public AEColor getGridColor() {
            return AEColor.Transparent;
        }

        public void onGridNotification(GridNotification gridNotification) {
        }

        public void setNetworkStatus(IGrid iGrid, int i) {
        }

        public EnumSet<ForgeDirection> getConnectableSides() {
            return EnumSet.allOf(ForgeDirection.class);
        }

        public IGridHost getMachine() {
            return TileEntityAENode.this;
        }

        public void gridChanged() {
        }

        public ItemStack getMachineRepresentation() {
            return new ItemStack((Block)BlockRegistry.cableAENode);
        }
    }
}

