/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskFluid;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskInventory;
import bq_standard.tasks.factory.FactoryTaskFluid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.logging.log4j.Level;

public class TaskFluid
implements ITaskInventory,
IFluidTask,
IItemTask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final List<FluidStack> requiredFluids = new ArrayList<FluidStack>();
    public final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public boolean ignoreNbt = true;
    public boolean consume = true;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskFluid.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.fluid";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Object> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
            } else {
                for (int i = 0; i < this.requiredFluids.size(); ++i) {
                    int r = this.requiredFluids.get((int)i).amount;
                    for (Tuple2<UUID, int[]> value2 : progress) {
                        int n = ((int[])value2.func_76340_b())[i];
                        if (n == 0 || n >= r) continue;
                        ((int[])value2.func_76340_b())[i] = 0;
                        updated = true;
                    }
                }
            }
        }
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList();
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer inventoryPlayer : invoList) {
            for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                ItemStack stack = inventoryPlayer.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof IFluidContainerItem) && !FluidContainerRegistry.isFilledContainer((ItemStack)stack)) continue;
                for (int j = 0; j < this.requiredFluids.size(); ++j) {
                    FluidStack sample;
                    FluidStack rStack = this.requiredFluids.get(j);
                    FluidStack drainOG = rStack.copy();
                    if (this.ignoreNbt) {
                        drainOG.tag = null;
                    }
                    if (!drainOG.isFluidEqual(sample = this.getFluid(inventoryPlayer, i, false, drainOG.amount))) continue;
                    for (Tuple2<UUID, int[]> value3 : progress) {
                        FluidStack fluid;
                        if (((int[])value3.func_76340_b())[j] >= rStack.amount) continue;
                        int remaining = rStack.amount - ((int[])value3.func_76340_b())[j];
                        FluidStack drain = rStack.copy();
                        drain.amount = remaining;
                        if (this.ignoreNbt) {
                            drain.tag = null;
                        }
                        if (drain.amount <= 0 || (fluid = this.getFluid(inventoryPlayer, i, this.consume, drain.amount)) == null || fluid.amount <= 0) continue;
                        int[] nArray = (int[])value3.func_76340_b();
                        int n = j;
                        nArray[n] = nArray[n] + fluid.amount * stack.field_77994_a;
                        updated = true;
                    }
                }
            }
        }
        if (updated) {
            this.setBulkProgress(progress);
        }
        this.checkAndComplete(pInfo, quest, updated);
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync) {
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = resync;
        block0: for (Tuple2<UUID, int[]> value : progress) {
            for (int j = 0; j < this.requiredFluids.size(); ++j) {
                if (((int[])value.func_76340_b())[j] < this.requiredFluids.get((int)j).amount) continue block0;
            }
            updated = true;
            if (this.consume) {
                this.setComplete((UUID)value.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume) {
                pInfo.markDirty(Collections.singletonList(quest.getID()));
            } else {
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            }
        }
    }

    private FluidStack getFluid(InventoryPlayer invo, int slot, boolean drain, int amount) {
        ItemStack stack = invo.func_70301_a(slot);
        if (stack == null || amount <= 0) {
            return null;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).drain(stack, amount, drain);
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        int tmp1 = fluid.amount;
        int tmp2 = 1;
        while (fluid.amount < amount && tmp2 < stack.field_77994_a) {
            ++tmp2;
            fluid.amount += tmp1;
        }
        if (drain) {
            while (tmp2 > 0) {
                ItemStack empty = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
                invo.func_70298_a(slot, 1);
                if (!invo.func_70441_a(empty)) {
                    invo.field_70458_d.func_71019_a(empty, false);
                }
                --tmp2;
            }
        }
        return fluid;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("ignoreNBT", this.ignoreNbt);
        nbt.func_74757_a("consume", this.consume);
        nbt.func_74757_a("groupDetect", this.groupDetect);
        nbt.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (FluidStack stack : this.requiredFluids) {
            itemArray.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredFluids", (NBTBase)itemArray);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.ignoreNbt = nbt.func_74767_n("ignoreNBT");
        this.consume = nbt.func_74767_n("consume");
        this.groupDetect = nbt.func_74767_n("groupDetect");
        this.autoConsume = nbt.func_74767_n("autoConsume");
        this.requiredFluids.clear();
        NBTTagList fList = nbt.func_150295_c("requiredFluids", 10);
        for (int i = 0; i < fList.func_74745_c(); ++i) {
            this.requiredFluids.add(JsonHelper.JsonToFluidStack((NBTTagCompound)fList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.requiredFluids.size()];
                List dNbt = NBTConverter.getTagList((NBTTagList)pTag.func_150295_c("data", 3));
                for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                    data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskFluid(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    public boolean canAcceptFluid(UUID owner, DBEntry<IQuest> quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.getFluid() == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j).copy();
            if (this.ignoreNbt) {
                rStack.tag = null;
            }
            if (progress[j] >= rStack.amount || !rStack.equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canAcceptItem(UUID owner, DBEntry<IQuest> quest, ItemStack item) {
        if (owner == null || item == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            return this.canAcceptFluid(owner, quest, ((IFluidContainerItem)item.func_77973_b()).getFluid(item));
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
            return this.canAcceptFluid(owner, quest, FluidContainerRegistry.getFluidForFilledItem((ItemStack)item));
        }
        return false;
    }

    public FluidStack submitFluid(UUID owner, DBEntry<IQuest> quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.amount <= 0 || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return fluid;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j);
            if (progress[j] >= rStack.amount) continue;
            int remaining = rStack.amount - progress[j];
            if (!rStack.isFluidEqual(fluid)) continue;
            int removed = Math.min(fluid.amount, remaining);
            int n = j;
            progress[n] = progress[n] + removed;
            fluid.amount -= removed;
            if (fluid.amount > 0) continue;
            fluid = null;
            break;
        }
        if (this.consume) {
            this.setUserProgress(owner, progress);
        }
        return fluid;
    }

    public ItemStack submitItem(UUID owner, DBEntry<IQuest> quest, ItemStack input) {
        if (owner == null || input == null || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ItemStack item = input.func_77979_a(1);
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)item.func_77973_b();
            FluidStack fluid = container.drain(item, container.getCapacity(item), false);
            int amount = fluid.amount;
            container.drain(item, (fluid = this.submitFluid(owner, quest, fluid.copy())) == null ? amount : amount - fluid.amount, true);
            return item;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            this.submitFluid(owner, quest, fluid);
            return FluidContainerRegistry.drainFluidContainer((ItemStack)item);
        }
        return item;
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredFluids.size() ? new int[this.requiredFluids.size()] : progress;
    }

    private List<Tuple2<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2<UUID, int[]>> list = new ArrayList<Tuple2<UUID, int[]>>();
        uuids.forEach(key -> list.add(new Tuple2(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple2<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }
}

