/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.client.gui.GuiContainerFake;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.TaskCrafting;
import codechicken.nei.recipe.GuiCraftingRecipe;
import cpw.mods.fml.common.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class PanelTaskCrafting
extends CanvasMinimum {
    private final TaskCrafting task;
    private final IGuiRect initialRect;

    public PanelTaskCrafting(IGuiRect rect, TaskCrafting task) {
        super(rect);
        this.task = task;
        this.initialRect = rect;
    }

    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        GuiTextureColored txTick = new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936));
        GuiTextureColored txCross = new GuiTextureColored(PresetIcon.ICON_CROSS.getTexture(), (IGuiColor)new GuiColorStatic(-65536));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, 0, 16, 16, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150462_ai))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(10, 10, 6, 6, 0), (IGuiTexture)(this.task.allowCraft ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(24, 0, 16, 16, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150460_al))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(34, 10, 6, 6, 0), (IGuiTexture)(this.task.allowSmelt ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(48, 0, 16, 16, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150467_bQ))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(58, 10, 6, 6, 0), (IGuiTexture)(this.task.allowAnvil ? txTick : txCross)));
        int listW = this.initialRect.getWidth();
        for (int i = 0; i < this.task.requiredItems.size(); ++i) {
            BigItemStack stack = this.task.requiredItems.get(i);
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 28 + 24, 28, 28, 0), -1, stack, false, true);
            if (BQ_Standard.hasNEI) {
                slot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
            }
            this.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (isComplete || progress[i] >= stack.stackSize) {
                sb.append(EnumChatFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(EnumChatFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(36, i * 28 + 24, listW - 36, 28, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            this.addPanel((IGuiPanel)text);
        }
        this.recalcSizes();
    }

    @Optional.Method(modid="NotEnoughItems")
    private void lookupRecipe(ItemStack stack) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        GuiContainerFake guiContainerFake = new GuiContainerFake();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)guiContainerFake);
        GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
        guiContainerFake.setOnInitCallback(o -> Minecraft.func_71410_x().func_147108_a(currentScreen));
    }
}

