/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers.ftbq;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import bq_standard.core.BQ_Standard;
import bq_standard.importers.ftbq.FTBEntry;
import bq_standard.importers.ftbq.FTBQUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FTBQQuestImporter
implements IImporter {
    public static final FTBQQuestImporter INSTANCE;
    private static final FileFilter FILTER;
    private static final HashMap<String, Function<NBTTagCompound, ITask[]>> taskConverters;
    private static final HashMap<String, Function<NBTTagCompound, IReward[]>> rewardConverters;
    private final HashMap<String, FTBEntry> ID_MAP = new HashMap();
    private static IQuest iconQuest;

    public String getUnlocalisedName() {
        return "bq_standard.importer.ftbq_quest.name";
    }

    public String getUnlocalisedDescription() {
        return "bq_standard.importer.ftbq_quest.desc";
    }

    public FileFilter getFileFilter() {
        return FILTER;
    }

    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        for (File f : files) {
            if (f == null || f.getParent() == null) continue;
            try (FileInputStream fis = new FileInputStream(f);){
                this.startImport(questDB, lineDB, CompressedStreamTools.func_74796_a((InputStream)fis), f.getParentFile());
            }
            catch (Exception e) {
                BQ_Standard.logger.error("Failed to import FTB Quests NBT file:\n" + f.getAbsolutePath() + "\nReason:", (Throwable)e);
            }
        }
    }

    private void startImport(IQuestDatabase questDB, IQuestLineDatabase lineDB, NBTTagCompound tagIndex, File folder) {
        int[] indexIDs = tagIndex.func_74759_k("index");
        this.ID_MAP.clear();
        FTBQQuestImporter.requestIcon(null);
        HashMap<IQuest, String[]> parentMap = new HashMap<IQuest, String[]>();
        BQ_Standard.logger.info("Found " + indexIDs.length + " quest chapter(s) to import");
        for (int id : indexIDs) {
            File[] contents;
            String hexName = String.format("%1$08x", id);
            File qlFolder = new File(folder, hexName);
            if (!qlFolder.exists() || !qlFolder.isDirectory() || (contents = qlFolder.listFiles()) == null) continue;
            int lineID = lineDB.nextID();
            IQuestLine questLine = lineDB.createNew(lineID);
            this.ID_MAP.put(hexName, new FTBEntry(lineID, questLine, FTBEntry.FTBEntryType.LINE));
            for (File questFile : contents) {
                NBTTagCompound qTag;
                if (!questFile.getName().toLowerCase().endsWith(".nbt")) continue;
                try (FileInputStream chFis = new FileInputStream(questFile);){
                    qTag = CompressedStreamTools.func_74796_a((InputStream)chFis);
                }
                catch (Exception e) {
                    BQ_Standard.logger.error("Failed to import chapter file entry: " + questFile, (Throwable)e);
                    continue;
                }
                if (questFile.getName().equalsIgnoreCase("chapter.nbt")) {
                    questLine.setProperty(NativeProps.NAME, (Object)qTag.func_74779_i("title"));
                    NBTTagList desc = qTag.func_150295_c("description", 8);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < desc.func_74745_c(); ++i) {
                        sb.append(desc.func_150307_f(i));
                        if (i + 1 >= desc.func_74745_c()) continue;
                        sb.append("\n");
                    }
                    questLine.setProperty(NativeProps.DESC, (Object)sb.toString());
                    continue;
                }
                String hexID = questFile.getName().substring(0, questFile.getName().length() - 4);
                int questID = questDB.nextID();
                IQuest quest = questDB.createNew(questID);
                IQuestLineEntry qle = questLine.createNew(questID);
                this.ID_MAP.put(hexID, new FTBEntry(questID, quest, FTBEntry.FTBEntryType.QUEST));
                quest.setProperty(NativeProps.NAME, (Object)(qTag.func_150297_b("title", 8) ? qTag.func_74779_i("title") : hexID));
                NBTTagList desc = qTag.func_150295_c("text", 8);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < desc.func_74745_c(); ++i) {
                    sb.append(desc.func_150307_f(i));
                    if (i + 1 >= desc.func_74745_c()) continue;
                    sb.append("\n");
                }
                quest.setProperty(NativeProps.DESC, (Object)sb.toString());
                quest.setProperty(NativeProps.VISIBILITY, (Object)EnumQuestVisibility.ALWAYS);
                if (qTag.func_74764_b("icon")) {
                    BigItemStack icoStack = FTBQUtils.convertItem(qTag.func_74781_a("icon"));
                    if (icoStack.getBaseStack() != null) {
                        quest.setProperty(NativeProps.ICON, (Object)icoStack);
                    }
                    FTBQQuestImporter.requestIcon(null);
                } else {
                    FTBQQuestImporter.requestIcon(quest);
                }
                qle.setPosition(qTag.func_74762_e("x") * 24, qTag.func_74762_e("y") * 24);
                int[] depend = null;
                if (qTag.func_150297_b("dependencies", 11)) {
                    depend = qTag.func_74759_k("dependencies");
                }
                if (qTag.func_150297_b("dependency", 3)) {
                    depend = new int[]{qTag.func_74762_e("dependency")};
                }
                if (depend != null && depend.length > 0) {
                    String[] depKeys = new String[depend.length];
                    for (int d = 0; d < depend.length; ++d) {
                        depKeys[d] = String.format("%1$08x", depend[d]);
                    }
                    parentMap.put(quest, depKeys);
                }
                NBTTagList taskList = qTag.func_150295_c("tasks", 10);
                for (int i = 0; i < taskList.func_74745_c(); ++i) {
                    NBTTagCompound taskTag = taskList.func_150305_b(i);
                    String tType = taskTag.func_74779_i("type");
                    if (!taskConverters.containsKey(tType)) {
                        BQ_Standard.logger.warn("Unsupported FTBQ task \"" + tType + "\"! Skipping...");
                        continue;
                    }
                    ITask[] tsks = taskConverters.get(tType).apply(taskTag);
                    if (tsks == null || tsks.length <= 0) continue;
                    IDatabaseNBT taskReg = quest.getTasks();
                    for (ITask t : tsks) {
                        taskReg.add(taskReg.nextID(), (Object)t);
                    }
                }
                NBTTagList rewardList = qTag.func_150295_c("rewards", 10);
                for (int i = 0; i < rewardList.func_74745_c(); ++i) {
                    NBTTagCompound rewTag = rewardList.func_150305_b(i);
                    String rType = rewTag.func_74779_i("type");
                    if (!rewardConverters.containsKey(rType)) {
                        BQ_Standard.logger.warn("Unsupported FTBQ reward \"" + rType + "\"! Skipping...");
                        continue;
                    }
                    IReward[] tsks = rewardConverters.get(rType).apply(rewTag);
                    if (tsks == null || tsks.length <= 0) continue;
                    IDatabaseNBT rewardReg = quest.getRewards();
                    for (IReward t : tsks) {
                        rewardReg.add(rewardReg.nextID(), (Object)t);
                    }
                }
            }
        }
        Object object = parentMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ArrayList<Integer> qIDs = new ArrayList<Integer>();
            for (String key : (String[])entry.getValue()) {
                FTBEntry type = this.ID_MAP.get(key);
                if (type == null) {
                    BQ_Standard.logger.warn("Unable to find quest dependency '" + key + "'");
                    continue;
                }
                if (type.type == FTBEntry.FTBEntryType.VAR) continue;
                if (type.type == FTBEntry.FTBEntryType.QUEST) {
                    qIDs.add(questDB.getID((Object)((IQuest)type.obj)));
                    continue;
                }
                if (type.type != FTBEntry.FTBEntryType.LINE) continue;
                for (DBEntry qle : ((IQuestLine)type.obj).getEntries()) {
                    qIDs.add(qle.getID());
                }
            }
            int[] preReq = new int[qIDs.size()];
            for (int i = 0; i < qIDs.size(); ++i) {
                preReq[i] = (Integer)qIDs.get(i);
            }
            ((IQuest)entry.getKey()).setRequirements(preReq);
        }
    }

    private static void requestIcon(IQuest quest) {
        iconQuest = quest;
    }

    public static void provideIcon(BigItemStack stack) {
        if (iconQuest != null && stack != null) {
            iconQuest.setProperty(NativeProps.ICON, (Object)stack);
            iconQuest = null;
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

