/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.tasks.ITaskInventory;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;

public class PlayerContainerListener
implements ICrafting {
    private static final HashMap<UUID, PlayerContainerListener> LISTEN_MAP = new HashMap();
    private EntityPlayer player;

    static void refreshListener(@Nonnull EntityPlayer player) {
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        PlayerContainerListener listener = LISTEN_MAP.get(uuid);
        if (listener != null) {
            listener.player = player;
        } else {
            listener = new PlayerContainerListener(player);
            LISTEN_MAP.put(uuid, listener);
        }
        try {
            player.field_71069_bz.func_75132_a((ICrafting)listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PlayerContainerListener(@Nonnull EntityPlayer player) {
        this.player = player;
    }

    public void func_71110_a(Container container, List nonNullList) {
        this.updateTasks();
    }

    public void func_71111_a(Container container, int i, ItemStack itemStack) {
        this.updateTasks();
    }

    public void func_71112_a(Container container, int i, int i1) {
    }

    private void updateTasks() {
        ParticipantInfo pInfo = new ParticipantInfo(this.player);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof ITaskInventory)) continue;
                ((ITaskInventory)task.getValue()).onInventoryChange((DBEntry<IQuest>)entry, pInfo);
            }
        }
    }
}

