/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks.base;

import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.utils.DirtyPlayerMarker;
import bq_standard.core.BQ_Standard;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.apache.logging.log4j.Level;

public abstract class TaskBase
implements ITask {
    protected final Set<UUID> completeUsers = new TreeSet<UUID>();

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
            DirtyPlayerMarker.markDirty((UUID)uuid);
        }
    }

    public void resetUser(@Nullable UUID uuid) {
        HashSet<UUID> dirtyPlayers = new HashSet<UUID>();
        if (uuid == null) {
            dirtyPlayers.addAll(this.completeUsers);
            this.completeUsers.clear();
        } else if (this.completeUsers.remove(uuid)) {
            dirtyPlayers.add(uuid);
        }
        DirtyPlayerMarker.markDirty(dirtyPlayers);
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList completeUsersNBTList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < completeUsersNBTList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(completeUsersNBTList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList completeUsersNBTList = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                completeUsersNBTList.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)completeUsersNBTList);
        return nbt;
    }
}

