/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.OreIngredient;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.NbtBlockType;
import bq_standard.client.gui.tasks.PanelTaskInteractItem;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskInteractItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class TaskInteractItem
extends TaskProgressableBase<Integer> {
    @Nullable
    public BigItemStack targetItem = null;
    public final NbtBlockType targetBlock = new NbtBlockType(null);
    public boolean partialMatch = true;
    public boolean ignoreNBT = true;
    public boolean onInteract = true;
    public boolean onHit = false;
    public int required = 1;

    public void readFromNBT(NBTTagCompound nbt) {
        this.targetItem = BigItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.func_74775_l("item"));
        this.targetBlock.readFromNBT(nbt.func_74775_l("block"));
        this.ignoreNBT = nbt.func_74767_n("ignoreNbt");
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.required = nbt.func_74762_e("requiredUses");
        this.onInteract = nbt.func_74767_n("onInteract");
        this.onHit = nbt.func_74767_n("onHit");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)(this.targetItem != null ? this.targetItem.writeToNBT(new NBTTagCompound()) : new NBTTagCompound()));
        nbt.func_74782_a("block", (NBTBase)this.targetBlock.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("ignoreNbt", this.ignoreNBT);
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74768_a("requiredUses", this.required);
        nbt.func_74757_a("onInteract", this.onInteract);
        nbt.func_74757_a("onHit", this.onHit);
        return nbt;
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.interact_item";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskInteractItem.INSTANCE.getRegistryName();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskInteractItem(rect, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public Integer getUsersProgress(UUID uuid) {
        Integer n = (Integer)this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    @Override
    public Integer readUserProgressFromNBT(NBTTagCompound nbt) {
        return nbt.func_74762_e("value");
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, Integer progress) {
        nbt.func_74768_a("value", progress.intValue());
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public void onInteract(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack item, Block block, int meta, int x, int y, int z, boolean isHit) {
        if (!this.onHit && isHit || !this.onInteract && !isHit) {
            return;
        }
        if (this.targetBlock.b != Blocks.field_150350_a && this.targetBlock.b != null) {
            boolean oreMatch;
            if (block == Blocks.field_150350_a || block == null) {
                return;
            }
            TileEntity tile = block.hasTileEntity(meta) ? pInfo.PLAYER.field_70170_p.func_147438_o(x, y, z) : null;
            NBTTagCompound tags = null;
            if (tile != null) {
                tags = new NBTTagCompound();
                tile.func_145841_b(tags);
            }
            int tmpMeta = this.targetBlock.m < 0 || this.targetBlock.m == Short.MAX_VALUE ? Short.MAX_VALUE : meta;
            boolean bl = oreMatch = this.targetBlock.oreDict.length() > 0 && OreDictionary.getOres((String)this.targetBlock.oreDict).contains(new ItemStack(block, 1, tmpMeta));
            if (!oreMatch && (block != this.targetBlock.b || this.targetBlock.m >= 0 && meta != this.targetBlock.m) || !ItemComparison.CompareNBTTag((NBTBase)this.targetBlock.tags, (NBTBase)tags, (boolean)true)) {
                return;
            }
        }
        if (this.targetItem != null) {
            if (this.targetItem.hasOreDict() && !ItemComparison.OreDictionaryMatch((OreIngredient)this.targetItem.getOreIngredient(), (NBTTagCompound)this.targetItem.GetTagCompound(), (ItemStack)item, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) {
                return;
            }
            if (!ItemComparison.StackMatch((ItemStack)this.targetItem.getBaseStack(), (ItemStack)item, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) {
                return;
            }
        }
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if (this.isComplete((UUID)value.func_76341_a())) {
                return;
            }
            int np = Math.min(this.required, (Integer)value.func_76340_b() + 1);
            this.setUserProgress((UUID)value.func_76341_a(), np);
            if (np >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        if (this.targetBlock.getItemStack() != null) {
            texts.add(this.targetBlock.getItemStack().getBaseStack().func_82833_r());
        }
        if (this.targetItem != null) {
            texts.add(this.targetItem.getBaseStack().func_82833_r());
        }
        return texts;
    }
}

