/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.tasks.TaskBlockBreak;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class PanelTaskBlockBreak
extends CanvasMinimum {
    private final TaskBlockBreak task;
    private final IGuiRect initialRect;

    public PanelTaskBlockBreak(IGuiRect rect, TaskBlockBreak task) {
        super(rect);
        this.task = task;
        this.initialRect = rect;
    }

    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        int listW = this.initialRect.getWidth();
        for (int i = 0; i < this.task.blockTypes.size(); ++i) {
            BigItemStack stack = this.task.blockTypes.get(i).getItemStack();
            if (stack == null) continue;
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 36, 36, 36, 0), -1, stack, true, true);
            this.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (progress[i] >= stack.stackSize || isComplete) {
                sb.append(EnumChatFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(EnumChatFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(40, i * 36, listW - 40, 36, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            this.addPanel((IGuiPanel)text);
        }
        this.recalcSizes();
    }
}

