/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.gui.widget.WidgetButtonNextPage;
import squeek.spiceoflife.gui.widget.WidgetFoodEaten;

@SideOnly(value=Side.CLIENT)
public class GuiScreenFoodJournal
extends GuiContainer {
    public static final DecimalFormat dfOne = new DecimalFormat("#.#");
    protected static final int numPerPage = 5;
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    public ItemStack hoveredStack = null;
    protected List<WidgetFoodEaten> foodEatenWidgets = new ArrayList<WidgetFoodEaten>();
    protected int pageNum = 0;
    protected int numPages;
    protected GuiButton buttonNextPage;
    protected GuiButton buttonPrevPage;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;

    public GuiScreenFoodJournal() {
        super(Minecraft.func_71410_x().field_71439_g.field_71069_bz);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonPrevPage = new WidgetButtonNextPage(1, (this.field_146294_l - this.bookImageWidth) / 2 + 38, 156, false);
        this.field_146292_n.add(this.buttonPrevPage);
        this.buttonNextPage = new WidgetButtonNextPage(2, (this.field_146294_l - this.bookImageWidth) / 2 + 120, 156, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.foodEatenWidgets.clear();
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g);
        HashSet<FoodEaten> recent = new HashSet<FoodEaten>(foodHistory.getRecentHistory());
        foodHistory.getFullHistory().stream().sorted(Comparator.comparing(i -> i.itemStack.func_82833_r())).forEach(f -> this.foodEatenWidgets.add(new WidgetFoodEaten((FoodEaten)f, recent.contains(f))));
        this.numPages = (int)Math.max(1.0, Math.ceil((float)this.foodEatenWidgets.size() / 5.0f));
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.pageNum < this.numPages - 1;
        this.buttonPrevPage.field_146125_m = this.pageNum > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int x = (this.field_146294_l - this.bookImageWidth) / 2;
        int y = 2;
        this.func_73729_b(x, y, 0, 0, this.bookImageWidth, this.bookImageHeight);
        int startIndex = Math.max(0, this.pageNum * 5);
        int endIndex = startIndex + 5;
        int totalNum = this.foodEatenWidgets.size();
        if (totalNum > 0) {
            int firstItemNum = startIndex + 1;
            int lastItemNum = Math.min(totalNum, endIndex);
            String pageIndicator = StatCollector.func_74837_a((String)"spiceoflife.gui.items.on.page", (Object[])new Object[]{firstItemNum, lastItemNum, totalNum});
            this.field_146289_q.func_78276_b(pageIndicator, x + this.bookImageWidth - this.field_146289_q.func_78256_a(pageIndicator) - 44, y + 16, 0);
        }
        String numFoodsEatenAllTime = Integer.toString(FoodHistory.get((EntityPlayer)this.field_146297_k.field_71439_g).totalFoodsEatenAllTime);
        int allTimeW = this.field_146289_q.func_78256_a(numFoodsEatenAllTime);
        int allTimeX = this.field_146294_l / 2 - allTimeW / 2 - 5;
        int allTimeY = y + 158;
        this.field_146289_q.func_78276_b(numFoodsEatenAllTime, allTimeX, allTimeY, 0xA0A0A0);
        GL11.glDisable((int)2896);
        for (Object objButton : this.field_146292_n) {
            ((GuiButton)objButton).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        if (this.foodEatenWidgets.size() > 0) {
            int localY;
            int localX;
            WidgetFoodEaten foodEatenWidget;
            int foodEatenIndex;
            GL11.glPushMatrix();
            for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                localX = x + 36;
                localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                foodEatenWidget.draw(localX, localY);
                if (foodEatenWidget.foodEaten.itemStack == null) continue;
                this.drawItemStack(foodEatenWidget.foodEaten.itemStack, localX, localY);
            }
            GL11.glPopMatrix();
            this.hoveredStack = null;
            for (foodEatenIndex = startIndex; foodEatenIndex < this.foodEatenWidgets.size() && foodEatenIndex < endIndex; ++foodEatenIndex) {
                foodEatenWidget = this.foodEatenWidgets.get(foodEatenIndex);
                localX = x + 36;
                localY = y + 32 + (int)((float)((foodEatenIndex - startIndex) * this.field_146289_q.field_78288_b) * 2.5f);
                if (GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, localX, localY, 16, 16)) {
                    this.hoveredStack = foodEatenWidget.foodEaten.itemStack;
                    if (this.hoveredStack == null) continue;
                    this.func_146285_a(this.hoveredStack, mouseX, mouseY);
                    continue;
                }
                if (!GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, localX + 18, localY, foodEatenWidget.width(), 16)) continue;
                ArrayList<String> toolTipStrings = new ArrayList<String>();
                if (foodEatenWidget.eatenRecently) {
                    toolTipStrings.add(EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC + "Eaten Recently");
                } else {
                    toolTipStrings.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + "Not Eaten Recently!");
                }
                this.drawHoveringText(toolTipStrings, mouseX, mouseY, this.field_146289_q);
            }
        } else {
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"spiceoflife.gui.no.recent.food.eaten"), x + 36, y + 16 + 16, 116, 0x404040);
        }
        if (GuiScreenFoodJournal.isMouseInsideBox(mouseX, mouseY, allTimeX, allTimeY, allTimeW, this.field_146289_q.field_78288_b)) {
            this.drawHoveringText(Collections.singletonList(StatCollector.func_74838_a((String)"spiceoflife.gui.alltime.food.eaten")), mouseX, mouseY, this.field_146289_q);
        }
        GL11.glDisable((int)2896);
    }

    protected void drawItemStack(ItemStack par1ItemStack, int par2, int par3) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiScreenFoodJournal.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (par1ItemStack != null) {
            font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), par1ItemStack, par2, par3);
        this.field_73735_i = 0.0f;
        GuiScreenFoodJournal.field_146296_j.field_77023_b = 0.0f;
    }

    public static boolean isMouseInsideBox(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                --this.pageNum;
            } else if (button.field_146127_k == 2) {
                ++this.pageNum;
            }
            this.updateButtons();
        }
    }
}

