/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import com.kuba6000.mobsinfo.api.MobDrop;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.skeleton.Entity_SpecialSkeleton;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityUndeadWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/undead.png")};
    public byte skeletonCount;

    public EntityUndeadWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.skeletonCount = (byte)(this.field_70146_Z.nextInt(3) + 3);
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.1);
        this.func_70062_b(0, new ItemStack(Items.field_151103_aS));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void tryDrinkPotion() {
        if (this.potionThrowDelay <= 0) {
            if (this.func_70027_ad() && !this.func_70644_a(Potion.field_76426_n)) {
                this.drinkPotion(8195);
            } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(Potion.field_76427_o)) {
                this.drinkPotion(8205);
            } else if (this.field_70146_Z.nextFloat() < 0.025f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.drinkPotion(16396);
            } else if (this.field_70146_Z.nextFloat() < 0.025f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.drinkPotion(16428);
            } else if (this.field_70146_Z.nextFloat() < 0.2f && this.func_70638_az() != null && !this.func_70644_a(Potion.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.drinkPotion(16386);
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float range) {
        if (this.skeletonCount > 0 && this.field_70146_Z.nextInt(4) == 0) {
            this.skeletonCount = (byte)(this.skeletonCount - 1);
            Entity_SpecialSkeleton skeleton = new Entity_SpecialSkeleton(this.field_70170_p);
            skeleton.func_82149_j((Entity)this);
            skeleton.func_70624_b(this.func_70638_az());
            skeleton.func_110161_a(null);
            for (int i = 0; i < 4; ++i) {
                skeleton.func_70062_b(i, null);
            }
            skeleton.func_70062_b(4, new ItemStack((Item)Items.field_151024_Q, 1, Items.field_151024_Q.func_77612_l() - 2 - this.field_70146_Z.nextInt(5)));
            skeleton.field_70170_p.func_72838_d((Entity)skeleton);
            this.field_70170_p.func_72956_a((Entity)skeleton, "mob.ghast.fireball", 0.5f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        } else {
            super.func_82196_d(target, range);
        }
    }

    @Override
    protected boolean adjustSplashPotionByType(EntityPotion thrownPotion, EntityLivingBase target, float range, float distance) {
        super.adjustSplashPotionByType(thrownPotion, target, range, distance);
        return true;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntitySkeleton.class)).intValue()), 0.0f);
        }
    }

    protected void func_70600_l(int superRare) {
        this.func_145779_a(Items.field_151144_bL, 1);
    }

    @Override
    @Optional.Method(modid="mobsinfo")
    public void provideDropsInformation(@Nonnull ArrayList<MobDrop> drops) {
        super.provideDropsInformation(drops);
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntitySkeleton.class)).intValue())).withChance(0.3333).withLooting());
        drops.add(MobDrop.create((ItemStack)new ItemStack(Items.field_151144_bL)).withType(MobDrop.DropType.Rare).withChance(0.025));
        drops.add(MobDrop.create((Item)Items.field_151103_aS).withType(MobDrop.DropType.Additional).withChance(0.02125));
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("Skeletons", this.skeletonCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("Skeletons")) {
            this.skeletonCount = saveTag.func_74771_c("Skeletons");
        } else if (tag.func_74764_b("Skeletons")) {
            this.skeletonCount = tag.func_74771_c("Skeletons");
        }
    }
}

