/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.ghast;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialGhast
extends EntityGhast
implements ISpecialMob {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/ghast/ghast.png"), new ResourceLocation("textures/entity/ghast/ghast_shooting.png")};
    public int field_92014_j = 1;
    public Entity field_70792_g;
    public int field_70798_h;
    private SpecialMobData specialData;

    public Entity_SpecialGhast(World world) {
        super(world);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
        this.setRangedAI(20, 60, 64.0f);
    }

    protected void setRangedAI(int minDelay, int maxDelay, float range) {
        SpecialMobData data = this.getSpecialData();
        data.arrowRefireMin = (short)minDelay;
        data.arrowRefireMax = (short)maxDelay;
        data.arrowRange = range;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        EntityGhast proxy = new EntityGhast(this.field_70170_p);
        proxy.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)proxy);
    }

    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u.func_151525_a() == 0) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.field_70794_e = this.field_70791_f;
        this.updateEntityGoal();
        if (!this.field_70170_p.field_72995_K) {
            boolean shouldBeShooting;
            boolean shooting = this.getFireTexture() == 1;
            boolean bl = shouldBeShooting = this.field_70791_f > 10;
            if (shooting != shouldBeShooting) {
                this.setFireTexture(shouldBeShooting);
            }
        }
    }

    protected void updateEntityGoal() {
        double vX = this.field_70795_b - this.field_70165_t;
        double vY = this.field_70796_c - this.field_70163_u;
        double vZ = this.field_70793_d - this.field_70161_v;
        double v = vX * vX + vY * vY + vZ * vZ;
        if (v < 1.0 || v > 3600.0) {
            this.setRandomWaypoints(32.0f);
        }
        if (this.field_70797_a-- <= 0) {
            this.field_70797_a += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(v = Math.sqrt(v))) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / v;
                this.field_70159_w += vX * speed;
                this.field_70181_x += vY * speed;
                this.field_70179_y += vZ * speed;
            } else {
                this.clearWaypoints();
            }
        }
        this.updateEntityTarget();
        if (this.field_70792_g != null && this.field_70792_g.func_70068_e((Entity)this) < (double)(this.getSpecialData().arrowRange * this.getSpecialData().arrowRange)) {
            double x = this.field_70792_g.field_70165_t - this.field_70165_t;
            double z = this.field_70792_g.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(x, z)) * 180.0f / (float)Math.PI;
            if (this.func_70685_l(this.field_70792_g)) {
                if (this.field_70791_f == this.getSpecialData().arrowRefireMin >> 1) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1007, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                }
                ++this.field_70791_f;
                if (this.field_70791_f >= this.getSpecialData().arrowRefireMin) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.shootFireballAtEntity(this.field_70792_g);
                    }
                    this.field_70791_f = this.getSpecialData().arrowRefireMin - this.getSpecialData().arrowRefireMax;
                }
            } else if (this.field_70791_f > 0) {
                --this.field_70791_f;
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.field_70791_f > 0) {
                --this.field_70791_f;
            }
        }
    }

    public void setRandomWaypoints(float range) {
        this.field_70795_b = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70796_c = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70793_d = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
    }

    public void clearWaypoints() {
        this.field_70795_b = this.field_70165_t;
        this.field_70796_c = this.field_70163_u;
        this.field_70793_d = this.field_70161_v;
    }

    public boolean isCourseTraversable(double v) {
        double dX = (this.field_70795_b - this.field_70165_t) / v;
        double dY = (this.field_70796_c - this.field_70163_u) / v;
        double dZ = (this.field_70793_d - this.field_70161_v) / v;
        AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < v) {
            aabb.func_72317_d(dX, dY, dZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void updateEntityTarget() {
        if (this.field_70792_g != null && this.field_70792_g.field_70128_L) {
            this.field_70792_g = null;
        }
        if (this.field_70792_g == null || this.field_70798_h-- <= 0) {
            this.field_70792_g = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.field_70792_g != null) {
                this.field_70798_h = 20;
            }
        }
    }

    public byte getFireTexture() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setFireTexture(boolean fire) {
        this.field_70180_af.func_75692_b(16, (Object)(fire ? (byte)1 : 0));
    }

    public void shootFireballAtEntity(Entity target) {
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - (double)(this.field_70131_O / 2.0f);
        double dZ = target.field_70161_v - this.field_70161_v;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX, dY, dZ);
        fireball.field_92057_e = Math.round((float)this.field_92014_j * this.getTypeExplosionMult());
        Vec3 vec3 = this.func_70676_i(1.0f);
        fireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * (double)this.field_70130_N;
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        fireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * (double)this.field_70130_N;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public boolean func_70652_k(Entity target) {
        boolean hit;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            knockback = EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (hit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int fireAspect;
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireAspect << 2);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
            this.onTypeAttack(target);
        }
        return hit;
    }

    protected void onTypeAttack(Entity target) {
    }

    protected float getTypeExplosionMult() {
        return 1.0f;
    }

    public void onImpact(Entity fireball, Entity entityHit, double x, double y, double z) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74768_a("ExplosionPower", this.field_92014_j);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("ExplosionPower")) {
            this.field_92014_j = saveTag.func_74762_e("ExplosionPower");
        } else if (tag.func_74764_b("ExplosionPower")) {
            this.field_92014_j = tag.func_74762_e("ExplosionPower");
        }
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

